/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.commons.impl;

import com.adobe.cq.social.commons.CollabUtil;
import com.adobe.cq.social.commons.CommentException;
import com.day.text.Text;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;

public class CommentInfo {
    private Resource component;
    private Resource resource;
    private Resource root;
    private String pagePath;
    private final boolean isComment;
    private final Resource target;

    public CommentInfo(Resource target) throws CommentException {
        this.target = target;
        this.isComment = CommentInfo.isComment(target);
        if (!this.isComment) {
            this.initComponent(target);
        } else {
            this.initComment(target);
        }
    }

    public boolean isComment() {
        return this.isComment;
    }

    public Resource getComponent() {
        return this.component;
    }

    public Resource getResource() {
        return this.resource;
    }

    public Resource getRoot() {
        return this.root;
    }

    public String getRootPath() {
        return this.root.getPath();
    }

    public String getPagePath() {
        return this.pagePath;
    }

    public Resource getTarget() {
        return this.target;
    }

    public void setPagePath(String path) {
        this.pagePath = path;
    }

    public static String getCollectionResourcePath(Resource target) throws CommentException {
        if (target == null) {
            throw new NullPointerException("target value can not be null.");
        }
        Node node = (Node)target.adaptTo(Node.class);
        boolean isComment = CommentInfo.isComment(node);
        String rootPath = null;
        rootPath = !isComment ? (StringUtils.contains((String)target.getPath(), (String)"/content/usergenerated") ? target.getPath() : CollabUtil.resourceToUGCPath(target)) : target.getPath();
        return rootPath;
    }

    public static String getComponentPath(Resource target) {
        if (CommentInfo.isComment(target)) {
            Resource root = CommentInfo.findCommentSystemRoot(target);
            return CommentInfo.getComponentPath(target, root);
        }
        return target.getPath();
    }

    private static boolean isComment(Resource target) throws CommentException {
        Node node = (Node)target.adaptTo(Node.class);
        return CommentInfo.isComment(node);
    }

    private static boolean isComment(Node target) throws CommentException {
        try {
            return target != null && target.getPath().startsWith("/content/usergenerated") && target.isNodeType("cq:Comment");
        }
        catch (RepositoryException e) {
            throw new CommentException("Failed to obtain comment info.", e);
        }
    }

    private void initComponent(Resource target) {
        this.component = target;
        this.pagePath = CollabUtil.getPagePath(target);
        ResourceResolver resolver = target.getResourceResolver();
        this.root = StringUtils.contains((String)target.getPath(), (String)"/content/usergenerated") ? (this.resource = resolver.resolve(target.getPath())) : (this.resource = resolver.resolve(CollabUtil.resourceToUGCPath(target)));
    }

    private void initComment(Resource target) {
        ResourceResolver resolver = target.getResourceResolver();
        this.resource = target;
        this.root = CommentInfo.findCommentSystemRoot(this.resource);
        String componentPath = CommentInfo.getComponentPath(target, this.root);
        this.component = resolver.resolve(componentPath);
        String segment = "/jcr:content";
        this.pagePath = componentPath.indexOf("/jcr:content") > 0 ? componentPath.substring(0, componentPath.indexOf("/jcr:content")) : componentPath;
    }

    private static String getComponentPath(Resource target, Resource root) {
        ResourceResolver resolver = target.getResourceResolver();
        String path = (String)((ValueMap)root.adaptTo(ValueMap.class)).get("commentsNode", null);
        if (path == null) {
            path = target.getPath();
            path = path.substring("/content/usergenerated".length());
            Resource cres = null;
            String prevName = "";
            while (cres == null && !"/".equals(path)) {
                prevName = Text.getName((String)path);
                path = path.substring(0, path.lastIndexOf("/"));
                cres = resolver.getResource(path);
            }
            path = path + "/par/" + prevName;
        }
        return path;
    }

    private static Resource findCommentSystemRoot(Resource resource) {
        ResourceResolver resolver = resource.getResourceResolver();
        Node node = (Node)resource.adaptTo(Node.class);
        Resource res = null;
        try {
            while (node.isNodeType("cq:Comment") || node.isNodeType("sling:Folder")) {
                Resource parentResource = resolver.getResource((node = node.getParent()).getParent().getPath());
                if (!ResourceUtil.isA((Resource)parentResource, (String)"sling:Folder")) continue;
                node = node.getParent();
            }
            res = resolver.getResource(node.getPath());
        }
        catch (Exception e) {
            // empty catch block
        }
        return res;
    }
}

