/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.commons.impl;

import com.adobe.cq.social.commons.Comment;
import com.adobe.cq.social.storage.buckets.NestedBucketStorageSystem;
import java.util.Iterator;
import org.apache.sling.api.resource.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommentIterable
implements Iterable<Comment> {
    private final Resource root;
    private final String postfix;

    public CommentIterable(Resource root, String postfix) {
        this.root = root;
        this.postfix = postfix;
    }

    @Override
    public Iterator<Comment> iterator() {
        return new CommentIterator(this.root, this.postfix);
    }

    public static Iterator<Resource> resourceIterator(Resource root, String postfix) {
        return new ResourceIterator(root, postfix);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CommentIterator
    implements Iterator<Comment> {
        ResourceIterator iterator;

        public CommentIterator(Resource root, String postfix) {
            this.iterator = new ResourceIterator(root, postfix);
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Comment next() {
            Resource resource = this.iterator.next();
            if (resource != null) {
                return (Comment)resource.adaptTo(Comment.class);
            }
            return null;
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResourceIterator
    implements Iterator<Resource> {
        Iterator<Resource> nodeIterator;

        public ResourceIterator(Resource root, String postfix) {
            NestedBucketStorageSystem bucketSystem = (NestedBucketStorageSystem)root.adaptTo(NestedBucketStorageSystem.class);
            bucketSystem.setBucketPostfix(postfix);
            this.nodeIterator = bucketSystem.listChildren();
        }

        @Override
        public boolean hasNext() {
            return this.nodeIterator.hasNext();
        }

        @Override
        public Resource next() {
            return this.nodeIterator.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

