/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.commons.impl;

import com.adobe.cq.social.commons.Comment;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.ui.JcrPayloadPathBuilder;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.resource.JcrResourceResolverFactory;
import org.osgi.service.component.ComponentContext;

@Component(metatype=false)
@Service
public class CommentJcrPathBuilder
implements JcrPayloadPathBuilder {
    public static final String TYPE_JCR_PATH = "JCR_PATH";
    @Reference
    private JcrResourceResolverFactory jcrResolverFactory;
    @Reference
    private SlingRepository repository;
    private Session admin;

    public String buildPath(WorkItem item) {
        if (item.getWorkflowData().getPayloadType().equals(TYPE_JCR_PATH)) {
            String path = item.getWorkflowData().getPayload().toString();
            Resource res = this.jcrResolverFactory.getResourceResolver(this.admin).getResource(path);
            if (res != null && res.adaptTo(Comment.class) != null) {
                return ((Comment)res.adaptTo(Comment.class)).getUrl();
            }
        }
        return null;
    }

    protected void activate(ComponentContext context) throws RepositoryException {
        this.admin = this.repository.loginAdministrative(null);
    }

    protected void deactivate(ComponentContext context) {
        if (this.admin != null) {
            this.admin.logout();
            this.admin = null;
        }
    }

    protected void bindJcrResolverFactory(JcrResourceResolverFactory jcrResourceResolverFactory) {
        this.jcrResolverFactory = jcrResourceResolverFactory;
    }

    protected void unbindJcrResolverFactory(JcrResourceResolverFactory jcrResourceResolverFactory) {
        if (this.jcrResolverFactory == jcrResourceResolverFactory) {
            this.jcrResolverFactory = null;
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }
}

