/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.commons.impl;

import com.adobe.cq.social.commons.CollabUtil;
import com.adobe.cq.social.commons.Comment;
import com.adobe.cq.social.commons.CommentException;
import com.adobe.cq.social.commons.CommentSystem;
import com.adobe.cq.social.commons.CommentUtil;
import com.adobe.cq.social.commons.impl.CommentBase;
import com.adobe.cq.social.commons.impl.CommentInfo;
import com.adobe.cq.social.commons.index.impl.comment.CommentIndexManager;
import com.adobe.cq.social.storage.index.IndexUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.activation.DataSource;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommentSystemImpl
extends CommentBase
implements CommentSystem {
    protected CommentSystemImpl() {
    }

    public CommentSystemImpl(Resource r) {
        if (r == null) {
            throw new CommentException("resource must not be null");
        }
        this.commentInfo = new CommentInfo(r);
        this.initCommentId();
    }

    @Override
    public Comment addComment(String message, String author) throws CommentException {
        return this.addComment(message, author, null);
    }

    @Override
    public Comment addComment(String message, String author, List<DataSource> fileAttachments) throws CommentException {
        this.prepareUserGeneratedContent();
        return this.createComment(message, author, fileAttachments);
    }

    @Override
    public List<Comment> getComments(int offset, int size) throws CommentException {
        try {
            Resource resource = this.commentInfo.getResource();
            String path = resource.getPath();
            String indexPath = IndexUtil.getBaseIndexFolder((ResourceResolver)this.resolver, (String)path);
            CommentIndexManager indexManager = CommentIndexManager.getInstance(this.resolver, indexPath, false);
            String parentRelPath = CommentIndexManager.getCommentRelativePath(path);
            if (parentRelPath != null && !parentRelPath.endsWith(resource.getName())) {
                indexManager.initCommentReplyIndexer(parentRelPath, this.resolver, false);
                return indexManager.getPageByOffset(parentRelPath + "all", size, this.resolver, offset, path);
            }
            return indexManager.getPageByOffset("all", size, this.resolver, offset, path);
        }
        catch (RepositoryException e) {
            throw new CommentException(e);
        }
    }

    @Override
    public Resource getResource() {
        return this.commentInfo.getComponent();
    }

    @Override
    public <T> T getProperty(String name, Class<T> type) {
        try {
            return (T)((ValueMap)this.getResource().adaptTo(ValueMap.class)).get(name, type);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public <T> T getProperty(String name, T defaultValue) {
        try {
            return (T)((ValueMap)this.getResource().adaptTo(ValueMap.class)).get(name, defaultValue);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    @Override
    public String getPath() {
        return this.commentInfo.getPagePath();
    }

    @Override
    public void setPath(String path) {
        this.commentInfo.setPagePath(path);
    }

    @Override
    public String getRootPath() {
        return this.getRoot().getPath();
    }

    @Override
    public String getUrl() {
        return this.commentInfo.getPagePath() + ".html" + "#" + this.getId();
    }

    @Override
    public boolean isModerated() {
        return CommentUtil.isSystemModerated(this.commentInfo.getComponent());
    }

    @Override
    public boolean isClosed() {
        return CommentUtil.isSystemClosed(this.commentInfo.getComponent());
    }

    @Override
    public boolean allowsEdit() {
        return !this.getProperty("editform", "").isEmpty();
    }

    @Override
    public boolean allowsAttachment() {
        return this.getProperty("allowFileUploads", (Object)Boolean.class) != null ? (Boolean)((Object)this.getProperty("allowFileUploads", (Object)Boolean.class)) : false;
    }

    @Override
    public boolean allowsReplies() {
        return this.getProperty("allowRepliesToComments", (Object)Boolean.class) != null ? (Boolean)((Object)this.getProperty("allowRepliesToComments", (Object)Boolean.class)) : false;
    }

    @Override
    public long getAttachmentSizeLimit() {
        if (this.allowsAttachment()) {
            return this.getProperty("maxFileSize", (Object)Long.class) != null ? (Long)((Object)this.getProperty("maxFileSize", (Object)Long.class)) : 0x6400000L;
        }
        return 0L;
    }

    @Override
    public List<String> getAllowedFileTypes() {
        if (this.allowsAttachment()) {
            String allowedFileTypes = (String)((Object)this.getProperty("acceptFileTypes", (Object)String.class));
            if (StringUtils.isNotBlank((String)allowedFileTypes)) {
                return Arrays.asList(allowedFileTypes.split("\\s*,\\s*"));
            }
            return null;
        }
        return null;
    }

    @Override
    public boolean allowsDelete() {
        return this.getProperty("allowDeleteComments", (Object)Boolean.class) != null ? (Boolean)((Object)this.getProperty("allowDeleteComments", (Object)Boolean.class)) : false;
    }

    @Override
    public List<String> deleteComment(Comment comment) {
        Session session = (Session)this.resolver.adaptTo(Session.class);
        List<String> paths = null;
        try {
            paths = this.getPaths(session, comment.getPath());
            Node commentNode = session.getNode(comment.getPath());
            commentNode.remove();
        }
        catch (RepositoryException e) {
            throw new CommentException("Repository Exception: Cound not find node for comment '" + comment.getPath() + "' " + e.getMessage() + " : " + e.toString());
        }
        return paths;
    }

    public Comment addComment(String message) throws CommentException {
        return this.addComment(message, ((Session)this.resolver.adaptTo(Session.class)).getUserID());
    }

    public void remove() {
        Session session = (Session)this.resolver.adaptTo(Session.class);
        if (session == null) {
            throw new IllegalArgumentException("resolver must be adaptable to session");
        }
        Resource r = this.getRoot();
        if (r != null) {
            try {
                session.removeItem(r.getPath());
                session.save();
            }
            catch (RepositoryException e) {
                throw new CommentException("Failed to remove collection " + r.getPath(), e);
            }
        }
    }

    @Override
    public boolean isRteEnabled() {
        return this.getProperty("rteEnabled", (Object)Boolean.class) != null ? (Boolean)((Object)this.getProperty("rteEnabled", (Object)Boolean.class)) : false;
    }

    private void initCommentId() {
        Resource r = this.commentInfo.getTarget();
        this.resolver = r.getResourceResolver();
        this.id = this.commentInfo.isComment() ? this.assembleCommentId() : CollabUtil.getIdFromResource(r);
    }

    private List<String> getPaths(Session session, String path) throws RepositoryException {
        ArrayList<String> paths = new ArrayList<String>();
        Node node = session.getNode(path);
        try {
            NodeIterator iter = node.getNodes();
            while (iter.hasNext()) {
                paths.addAll(this.getPaths(session, iter.nextNode().getPath()));
            }
            paths.add(path);
        }
        catch (PathNotFoundException e) {
            throw new RepositoryException("Error collecting paths for: " + e.toString());
        }
        return paths;
    }
}

