/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.commons.impl;

import com.adobe.cq.social.commons.CollabUtil;
import com.adobe.cq.social.commons.Comment;
import com.adobe.cq.social.commons.CommentException;
import com.adobe.cq.social.commons.CommentSystem;
import com.adobe.cq.social.commons.impl.CommentInfo;
import com.adobe.cq.social.commons.impl.CommentSystemImpl;
import com.adobe.granite.comments.CommentCollection;
import com.adobe.granite.comments.CommentingProvider;
import com.day.text.Text;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
@Service
@Properties(value={@Property(name="provider.commentTypes", classValue={Comment.class}), @Property(name="provider.collectionTypes", classValue={CommentSystem.class})})
public class CommentingProviderImpl
implements CommentingProvider {
    public static final String RESOURCE_TYPE_COLLECTION = "social/commons/components/comments";
    public static final String RESOURCE_TYPE_COMMENT = "social/commons/components/comments/comment";
    public static final String PROVIDER = "commentingProvider";
    private final Logger log = LoggerFactory.getLogger(CommentingProviderImpl.class);

    public <C extends CommentCollection> C getCollection(Resource target, Class<C> collectionType) {
        if (collectionType.equals(CommentSystem.class)) {
            Resource root = this.getCollectionResource(target);
            return (C)(null != root ? new CommentSystemImpl(target) : null);
        }
        throw new CommentException("Unsupported collection type " + collectionType.getName());
    }

    public <C extends CommentCollection> C createCollection(Resource target, Class<C> collectionType) {
        if (collectionType.equals(CommentSystem.class)) {
            Resource resource = this.createCollectionResource(target);
            return (C)new CommentSystemImpl(target);
        }
        throw new CommentException("Unsupported collection type " + collectionType.getName());
    }

    public String getCollectionResourceType() {
        return RESOURCE_TYPE_COLLECTION;
    }

    public String getCommentResourceType() {
        return RESOURCE_TYPE_COMMENT;
    }

    public final Resource createCollectionResource(Resource target) {
        String rootPath = this.getCollectionResourcePath(target);
        Session session = (Session)target.getResourceResolver().adaptTo(Session.class);
        try {
            if (session.itemExists(rootPath)) {
                throw new CommentException("Collection already exists: " + rootPath);
            }
            CommentInfo commentInfo = new CommentInfo(target);
            String pagePath = commentInfo.getPagePath();
            String ugcPagePath = CollabUtil.prepareUserGeneratedContent(target.getResourceResolver(), pagePath);
            Node pageNode = session.getNode(ugcPagePath);
            Node contentNode = pageNode.getNode("jcr:content");
            Node collectionRoot = contentNode.addNode(Text.getName((String)rootPath), "cq:CommentContent");
            collectionRoot.setProperty("commentsNode", commentInfo.getComponent().getPath());
            collectionRoot.setProperty(PROVIDER, this.getClass().getName());
            session.save();
            return target.getResourceResolver().getResource(collectionRoot.getPath());
        }
        catch (RepositoryException e) {
            this.log.error("error while creating collection root for target [{}]: ", (Object)target.getPath(), (Object)e);
            throw new CommentException("Could not create collection root for target: " + target.getPath(), e);
        }
    }

    protected final Resource getCollectionResource(Resource target) throws CommentException {
        Resource root = target.getResourceResolver().getResource(this.getCollectionResourcePath(target));
        this.checkCollectionType(root);
        return root;
    }

    protected String getCollectionResourcePath(Resource target) {
        return CommentInfo.getCollectionResourcePath(target);
    }

    private void checkCollectionType(Resource collectionResource) {
        if (null != collectionResource) {
            String type;
            ValueMap properties = (ValueMap)collectionResource.adaptTo(ValueMap.class);
            String string = type = null != properties ? (String)properties.get(PROVIDER, String.class) : null;
            if (!this.getClass().getName().equalsIgnoreCase(type)) {
                throw new CommentException("Collection has wrong type: " + type);
            }
        }
    }
}

