/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.commons.impl;

import com.adobe.cq.social.commons.Comment;
import com.adobe.cq.social.commons.CommentException;
import com.adobe.cq.social.commons.CommentUtil;
import com.adobe.cq.social.commons.index.impl.comment.CommentIndexManager;
import com.adobe.cq.social.storage.index.IndexUtil;
import com.day.cq.wcm.api.WCMMode;
import java.util.AbstractList;
import java.util.List;
import javax.jcr.RepositoryException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazyLoadedCommentList
extends AbstractList<Comment> {
    public static int DEFAULT_PAGE_SIZE = 100;
    private final Resource resource;
    private final Resource component;
    private final int pageSize;
    private long allIndexSize = -1L;
    private long filteredIndexSize = -1L;
    private int currentPage = -1;
    private List<Comment> list;
    private int size;
    private static final Logger log = LoggerFactory.getLogger(LazyLoadedCommentList.class);

    public LazyLoadedCommentList(Resource resource, Resource component) {
        this(resource, component, WCMMode.DISABLED);
    }

    public LazyLoadedCommentList(Resource resource, Resource component, WCMMode mode) {
        this(resource, component, mode, DEFAULT_PAGE_SIZE);
    }

    public LazyLoadedCommentList(Resource resource, Resource component, WCMMode mode, int pageSize) {
        this.resource = resource;
        this.component = component;
        this.pageSize = pageSize;
        this.size = this.countComments(mode);
    }

    @Override
    public Comment get(int index) {
        if (this.size > 0 && this.size >= index) {
            int page = index / this.pageSize;
            int pageOffset = index % this.pageSize;
            if (this.currentPage == -1 || page != this.currentPage) {
                int offset = (page - 1) * this.pageSize + 1;
                this.list = this.getComments(offset, this.pageSize);
            }
            return this.list.get(pageOffset);
        }
        throw new IndexOutOfBoundsException("Index (" + index + ") is out of bounds.");
    }

    @Override
    public int size() {
        return this.size;
    }

    private int countComments(WCMMode wcmMode) {
        if (!ResourceUtil.isNonExistingResource((Resource)this.resource)) {
            this.initIndex();
            if (wcmMode == WCMMode.EDIT || !CommentUtil.isSystemModerated(this.component)) {
                return (int)this.allIndexSize;
            }
            return (int)(this.allIndexSize - this.filteredIndexSize);
        }
        log.info("User generated content resource does not exist: " + this.resource.getPath());
        return 0;
    }

    private List<Comment> getComments(int offset, int size) throws CommentException {
        try {
            String path = this.resource.getPath();
            ResourceResolver resolver = this.resource.getResourceResolver();
            String indexPath = IndexUtil.getBaseIndexFolder((ResourceResolver)resolver, (String)path);
            CommentIndexManager indexManager = CommentIndexManager.getInstance(resolver, indexPath, false);
            String parentRelPath = CommentIndexManager.getCommentRelativePath(path);
            if (parentRelPath != null && !parentRelPath.endsWith(this.resource.getName())) {
                indexManager.initCommentReplyIndexer(parentRelPath, resolver, false);
                return indexManager.getPageByOffset(parentRelPath + "all", size, resolver, offset, path);
            }
            return indexManager.getPageByOffset("all", size, resolver, offset, path);
        }
        catch (RepositoryException e) {
            throw new CommentException(e);
        }
    }

    private void initIndex() {
        if (this.allIndexSize != -1L) {
            return;
        }
        ResourceResolver resolver = this.resource.getResourceResolver();
        String path = this.resource.getPath();
        try {
            String indexPath = IndexUtil.getBaseIndexFolder((ResourceResolver)resolver, (String)path);
            CommentIndexManager indexManager = CommentIndexManager.getInstance(resolver, indexPath, false);
            if (ResourceUtil.isA((Resource)this.resource, (String)"social/commons/components/comments/comment")) {
                String relPath = CommentIndexManager.getCommentRelativePath(path);
                indexManager.initCommentReplyIndexer(relPath, resolver, false);
                this.allIndexSize = indexManager.getSize(relPath + "all", resolver);
                this.filteredIndexSize = indexManager.getSize(relPath + "filtered", resolver);
            } else {
                this.allIndexSize = indexManager.getSize("all", resolver);
                this.filteredIndexSize = indexManager.getSize("filtered", resolver);
            }
        }
        catch (RepositoryException e) {
            log.error("Error initializing counts from index for " + path, (Throwable)e);
        }
    }
}

