/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.commons.impl;

import com.adobe.cq.social.commons.ToggleUtil;
import com.adobe.cq.social.commons.UserStateToggleManager;
import com.adobe.granite.security.user.UserProperties;
import com.adobe.granite.security.user.UserPropertiesManager;
import com.day.cq.security.User;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowService;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.event.WorkflowEvent;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.exec.Workflow;
import com.day.cq.workflow.exec.WorkflowData;
import com.day.cq.workflow.metadata.MetaDataMap;
import com.day.cq.workflow.metadata.SimpleMetaDataMap;
import com.day.cq.workflow.model.WorkflowModel;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.felix.scr.annotations.Services;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestDispatcherOptions;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;
import org.apache.sling.event.EventUtil;
import org.apache.sling.event.JobProcessor;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.resource.JcrResourceResolverFactory;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false)
@Services(value={@Service(value={Servlet.class}), @Service(value={UserStateToggleManager.class}), @Service(value={EventHandler.class})})
@Properties(value={@Property(name="sling.servlet.resourceTypes", value={"sling/servlet/default"}), @Property(name="sling.servlet.selectors", value={"socialuserstatetoggle"}), @Property(name="sling.servlet.methods", value={"POST", "GET"}), @Property(name="sling.servlet.extensions", value={"html", "json"}), @Property(name="event.topics", value={"com/day/cq/workflow/event"})})
public class UserStateToggleManagerImpl
extends SlingAllMethodsServlet
implements EventHandler,
JobProcessor,
UserStateToggleManager {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(UserStateToggleManagerImpl.class);
    public static final String EXTENSION_HTML = "html";
    public static final String EXTENSION_JSON = "json";
    private static final String[] SOCIALGROUP_WORKFLOW_MODEL_NAMES = new String[]{"Join Social Group", "Leave Community", "Approve Social Graph", "Deny Social Graph"};
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY, policy=ReferencePolicy.STATIC)
    private WorkflowService workflowService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY, policy=ReferencePolicy.STATIC)
    private SlingRepository repository;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY, policy=ReferencePolicy.STATIC)
    private JcrResourceResolverFactory resolverFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isTransitioning(String stateProviderPath, SlingHttpServletRequest request) {
        userProperties = (UserProperties)request.adaptTo(UserProperties.class);
        if (null == userProperties) {
            UserStateToggleManagerImpl.log.error("error accessing UserProperties for [{}].", (Object)request.getRequestURI());
            return false;
        }
        adminSession = null;
        try {
            block22: {
                block21: {
                    adminSession = this.repository.loginAdministrative(null);
                    resolver = this.getResourceResolver(adminSession);
                    upMgr = (UserPropertiesManager)resolver.adaptTo(UserPropertiesManager.class);
                    v0 = wfSession = null != adminSession ? this.workflowService.getWorkflowSession(adminSession) : null;
                    if (null == wfSession) break block22;
                    try {
                        arr$ = pendingWorkflows = (String[])userProperties.getProperty("socialstateToggleWorkflows", (Object)new String[0], String[].class);
                        len$ = arr$.length;
                        i$ = 0;
lbl16:
                        // 2 sources

                        while (true) {
                            if (i$ >= len$) return false;
                            var12_14 = arr$[i$];
                            try {
                                workflow = wfSession.getWorkflow(var12_14);
                                if (null != workflow && !"COMPLETED".equals(workflow.getState()) && !"ABORTED".equals(workflow.getState())) {
                                    metadata = workflow.getMetaDataMap();
                                    path = (String)metadata.get("toggleStateProvider", (Object)"");
                                    if (StringUtils.equals((String)stateProviderPath, (String)path) && workflow.getWorkflowData().getPayload().equals(request.getResource().getPath())) {
                                        var16_21 = true;
                                        return var16_21;
                                    }
                                    break block21;
                                }
                            }
                            catch (WorkflowException e) {
                                UserStateToggleManagerImpl.log.error("error getting workflow [{}]: ", (Object)var12_14, (Object)e);
                                break block21;
                            }
                            break;
                        }
                    }
                    catch (RepositoryException e) {
                        UserStateToggleManagerImpl.log.error("error while saving UserProperties [{}] during pending workflows cleanup: ", (Object)userProperties, (Object)e);
                        return false;
                    }
                    {
                        try {
                            editUserProperties = upMgr.getUserProperties(userProperties.getAuthorizableID(), "profile");
                            pNode = editUserProperties.getNode();
                            pNode.setProperty("socialstateToggleWorkflows", (String[])ArrayUtils.removeElement((Object[])pendingWorkflows, (Object)var12_14));
                            try {
                                adminSession.save();
                            }
                            catch (RepositoryException e) {
                                UserStateToggleManagerImpl.log.error("error while saving userProperties [{}] during pending workflows cleanup: ", (Object)userProperties, (Object)e);
                            }
                        }
                        catch (RepositoryException e) {
                            UserStateToggleManagerImpl.log.error("error getting UserProperties [[]], cannot cleanup pending workflows.", (Object)userProperties, (Object)e);
                        }
                    }
                }
                ++i$;
                ** continue;
            }
            UserStateToggleManagerImpl.log.error("could not get workflow session for [{}].", (Object)request.getRequestURI());
            return false;
        }
        catch (RepositoryException e) {
            UserStateToggleManagerImpl.log.error("error while accessing repository: ", (Throwable)e);
            return false;
        }
        finally {
            if (null != adminSession && adminSession.isLive()) {
                adminSession.logout();
            }
        }
    }

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("utf-8");
        Session session = this.getAdminSession();
        ResourceResolver resolver = this.getResourceResolver(session);
        if (null != resolver) {
            Resource resource = request.getResource();
            String stateProviderPath = request.getParameter("sp");
            if (StringUtils.isNotBlank((String)stateProviderPath)) {
                Resource stateProviderResource = resolver.getResource(stateProviderPath);
                if (null != stateProviderResource && ResourceUtil.isA((Resource)stateProviderResource, (String)"social/commons/components/toggle/stateproviders/base")) {
                    RequestDispatcherOptions options = new RequestDispatcherOptions();
                    options.setForceResourceType(stateProviderPath);
                    options.setReplaceSelectors("");
                    RequestDispatcher dispatcher = request.getRequestDispatcher(resource, options);
                    dispatcher.include((ServletRequest)request, (ServletResponse)response);
                    ToggleUtil.STATE state = ToggleUtil.fromRequest(request);
                    JSONWriter writer = new JSONWriter((Writer)response.getWriter());
                    try {
                        String label;
                        String resourcePath = request.getParameter("r");
                        Resource r = null;
                        if (StringUtils.isNotBlank((String)resourcePath)) {
                            r = resolver.getResource(resourcePath);
                        }
                        ValueMap props = ResourceUtil.getValueMap(r);
                        switch (state) {
                            case TRANSITION: {
                                label = (String)props.get("transitionLabel", (Object)"Transitioning");
                                break;
                            }
                            case TOGGLED: {
                                label = (String)props.get("toggleLabel", (Object)"Toggled");
                                break;
                            }
                            default: {
                                label = (String)props.get("untoggleLabel", (Object)"Untoggled");
                            }
                        }
                        writer.object();
                        writer.key("state").value((Object)(null != state ? state.toString() : ToggleUtil.STATE.UNTOGGLED.toString()));
                        writer.key("label").value((Object)label);
                        writer.endObject();
                    }
                    catch (JSONException e) {
                        log.error("could not write json: ", (Throwable)e);
                    }
                } else {
                    log.error("could not determine state for resource [{}], component [{}] doesn't exist or is not a state provider.", (Object)resource.getPath(), (Object)stateProviderPath);
                }
            } else {
                log.error("could not determine state for resource [{}], no state provider given.", (Object)resource.getPath());
            }
        } else {
            log.error("cannot get state, resolver/session unavailable for [{}].", (Object)request.getRequestURI());
        }
        if (null != session && session.isLive()) {
            session.logout();
        }
    }

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        ValueMap props;
        ToggleUtil.STATE oldState;
        Session session;
        block21: {
            session = this.getAdminSession();
            ResourceResolver resolver = this.getResourceResolver(session);
            String oldStateName = request.getParameter("cs");
            final UserManager userMgr = (UserManager)resolver.adaptTo(UserManager.class);
            oldState = ToggleUtil.STATE.UNTOGGLED;
            if (null != oldStateName) {
                try {
                    oldState = ToggleUtil.STATE.valueOf(oldStateName);
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
            }
            props = null;
            if (null != resolver) {
                String resourcePath = request.getParameter("r");
                if (StringUtils.isNotBlank((String)resourcePath)) {
                    props = ResourceUtil.getValueMap((Resource)resolver.getResource(resourcePath));
                    final String stateProviderPath = (String)props.get("stateProvider", (Object)"");
                    String wfModelPath = ToggleUtil.STATE.TOGGLED == oldState ? (String)props.get("untoggleWorkflowModel", (Object)"") : (String)props.get("toggleWorkflowModel", (Object)"");
                    final String needApproval = request.getParameter("na");
                    if (!"".equals(wfModelPath) && !"".equals(stateProviderPath)) {
                        WorkflowSession wfSession = this.workflowService.getWorkflowSession(session);
                        try {
                            WorkflowModel model = wfSession.getModel(wfModelPath);
                            if (null != model) {
                                Resource resource = request.getResource();
                                final UserProperties userProperties = (UserProperties)request.adaptTo(UserProperties.class);
                                if (null != userProperties) {
                                    WorkflowData data = wfSession.newWorkflowData("JCR_PATH", (Object)resource.getPath());
                                    Workflow workflow = wfSession.startWorkflow(model, data, (Map)new SimpleMetaDataMap(){
                                        private static final long serialVersionUID = 1L;
                                        {
                                            String authId = userProperties.getAuthorizableID();
                                            this.put("toggleStateProvider", stateProviderPath);
                                            this.put("socialstateToggleUser", userMgr.getAuthorizable(authId).getPath());
                                            this.put("toggleStateApproval", needApproval);
                                        }
                                    });
                                    if (!this.isSocialGroupWorkflow(model.getTitle())) {
                                        this.updateUserToggleStateList("WorkflowStarted", workflow.getId(), workflow.getMetaDataMap());
                                    }
                                    log.info("started workflow [{}] for user state toggle on [{}].", (Object)workflow, (Object)request.getRequestURI());
                                } else {
                                    log.error("userProperties missing, will not start toggle workflow.");
                                }
                                break block21;
                            }
                            log.error("could not find workflow model [{}].", (Object)wfModelPath);
                        }
                        catch (WorkflowException e) {
                            log.error("a workflow error occurred: ", (Throwable)e);
                        }
                        catch (RepositoryException re) {
                            log.error("a repository error occurred: ", (Throwable)re);
                        }
                    } else {
                        log.error("state provider [{}] or workflow model [{}] are missing.", (Object)stateProviderPath, (Object)wfModelPath);
                    }
                }
            } else {
                log.error("cannot handle request, session/resolver unavailale on [{}].", (Object)request.getRequestURI());
            }
        }
        if (EXTENSION_HTML.equals(request.getRequestPathInfo().getExtension())) {
            String referer = request.getHeader("Referer");
            String url = null != referer ? referer : request.getResource() + ".html";
            url = StringUtils.substringBefore((String)url, (String)"?");
            url = url + "?os=" + (null != oldState ? oldState : "");
            response.sendRedirect(url);
        } else if (EXTENSION_JSON.equals(request.getRequestPathInfo().getExtension())) {
            response.setContentType("application/json");
            response.setCharacterEncoding("utf-8");
            JSONWriter writer = new JSONWriter((Writer)response.getWriter());
            try {
                writer.object();
                String message = ToggleUtil.STATE.TOGGLED == oldState ? (null != props ? (String)props.get("confirmationMessageUntoggle", (Object)"") : "") : (null != props ? (String)props.get("confirmationMessageToggle", (Object)"") : "");
                String label = null != props ? (String)props.get("transitionLabel", (Object)"") : "";
                writer.key("message").value((Object)message);
                writer.key("label").value((Object)label);
                writer.endObject();
            }
            catch (JSONException e) {
                log.error("error while writing back json for [{}].", (Object)request.getRequestURI());
            }
        }
        if (null != session && session.isLive()) {
            session.logout();
        }
    }

    public void handleEvent(Event event) {
        if (EventUtil.isLocal((Event)event)) {
            EventUtil.processJob((Event)event, (JobProcessor)this);
        }
    }

    private boolean isSocialGroupWorkflow(String modelName) {
        for (String model : SOCIALGROUP_WORKFLOW_MODEL_NAMES) {
            if (!model.equals(modelName)) continue;
            return true;
        }
        return false;
    }

    public boolean process(Event job) {
        String topic = job.getTopic();
        if ("com/day/cq/workflow/event".equals(topic) && null != job.getProperty("WorkflowInstanceId")) {
            String eventType = (String)job.getProperty("EventType");
            log.debug("processing workflow event: [{}]", (Object)eventType);
            WorkflowEvent event = (WorkflowEvent)job;
            String modelName = (String)event.getProperty("WorkflowName");
            if (this.isSocialGroupWorkflow(modelName)) {
                return true;
            }
            String workflowId = (String)event.getProperty("WorkflowInstanceId");
            MetaDataMap metadata = this.getWorkflowMetadata(event);
            this.updateUserToggleStateList(eventType, workflowId, metadata);
        } else {
            log.debug("skipping non-workflow event: [{}]", (Object)job.toString());
        }
        return true;
    }

    private MetaDataMap getWorkflowMetadata(WorkflowEvent event) {
        String workflowId = (String)event.getProperty("WorkflowInstanceId");
        WorkItem item = (WorkItem)event.getProperty("Workitem");
        Workflow workflow = null != item ? item.getWorkflow() : null;
        WorkflowData data = (WorkflowData)event.getProperty("Workdata");
        MetaDataMap metadata = null;
        if (null != workflow) {
            metadata = workflow.getMetaDataMap();
        } else if (null != data) {
            metadata = data.getMetaDataMap();
        } else {
            Session session = this.getAdminSession();
            ResourceResolver resolver = this.getResourceResolver(session);
            if (null != resolver) {
                metadata = new SimpleMetaDataMap();
                ValueMap props = ResourceUtil.getValueMap((Resource)resolver.getResource(workflowId + "/metaData"));
                metadata.putAll((Map)props);
            } else {
                log.error("cannot get workflow metadata, resolver unavailable for [{}].", (Object)event);
            }
            if (null != session && session.isLive()) {
                session.logout();
            }
        }
        return metadata;
    }

    private void updateUserToggleStateList(String eventType, String workflowId, MetaDataMap metadata) {
        if (UserStateToggleManagerImpl.isStateToggleWorkflow(metadata)) {
            Session session;
            block16: {
                session = this.getAdminSession();
                ResourceResolver resolver = this.getResourceResolver(session);
                if (null != resolver) {
                    String userHomePath = (String)metadata.get("socialstateToggleUser", (Object)"");
                    Resource userResource = resolver.getResource(userHomePath);
                    UserPropertiesManager upMgr = (UserPropertiesManager)resolver.adaptTo(UserPropertiesManager.class);
                    if (null != userResource) {
                        User user = (User)userResource.adaptTo(User.class);
                        if (null != user) {
                            try {
                                boolean userPropertiesUpdated = true;
                                UserProperties userProperties = upMgr.getUserProperties(user.getID(), "profile");
                                Object[] pendingWorkflows = (String[])userProperties.getProperty("socialstateToggleWorkflows", (Object)new String[0], String[].class);
                                Node pNode = userProperties.getNode();
                                if ("WorkflowCompleted".equals(eventType) && ArrayUtils.contains((Object[])pendingWorkflows, (Object)workflowId)) {
                                    pNode.setProperty("socialstateToggleWorkflows", (String[])ArrayUtils.removeElement((Object[])pendingWorkflows, (Object)workflowId));
                                } else if ("WorkflowStarted".equals(eventType) && !ArrayUtils.contains((Object[])pendingWorkflows, (Object)workflowId)) {
                                    pNode.setProperty("socialstateToggleWorkflows", (String[])ArrayUtils.add((Object[])pendingWorkflows, (Object)workflowId));
                                } else {
                                    userPropertiesUpdated = false;
                                }
                                if (!userPropertiesUpdated) break block16;
                                try {
                                    session.save();
                                }
                                catch (RepositoryException e) {
                                    log.error("error while saving toggle state to user userProperties [{}]: ", (Object)userHomePath, (Object)e);
                                }
                            }
                            catch (RepositoryException e) {
                                log.error("error while getting user userProperties [{}]:", (Object)user.getID(), (Object)e);
                            }
                        } else {
                            log.error("given user home path [{}] doesn't resolve to user, cannot process [{}].", (Object)userHomePath, (Object)workflowId);
                        }
                    } else {
                        log.error("user [{}] has no resource, cannot process [{}].", (Object)userHomePath, (Object)workflowId);
                    }
                } else {
                    log.error("cannot handle user toggle update, session/resolver unavailable for [{}].", (Object)workflowId);
                }
            }
            if (null != session && session.isLive()) {
                session.logout();
            }
        }
    }

    private static boolean isStateToggleWorkflow(MetaDataMap metadata) {
        String userHomePath = null != metadata ? (String)metadata.get("socialstateToggleUser", (Object)"") : null;
        return StringUtils.isNotBlank(userHomePath);
    }

    private Session getAdminSession() {
        try {
            return this.repository.loginAdministrative(null);
        }
        catch (RepositoryException e) {
            log.error("error while accessing repository: ", (Throwable)e);
            return null;
        }
    }

    private ResourceResolver getResourceResolver(Session session) {
        return null != session ? this.resolverFactory.getResourceResolver(session) : null;
    }

    protected void bindWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    protected void unbindWorkflowService(WorkflowService workflowService) {
        if (this.workflowService == workflowService) {
            this.workflowService = null;
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    protected void bindResolverFactory(JcrResourceResolverFactory jcrResourceResolverFactory) {
        this.resolverFactory = jcrResourceResolverFactory;
    }

    protected void unbindResolverFactory(JcrResourceResolverFactory jcrResourceResolverFactory) {
        if (this.resolverFactory == jcrResourceResolverFactory) {
            this.resolverFactory = null;
        }
    }
}

