/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.commons.impl.servlets;

import com.adobe.cq.social.commons.AbstractCreateCommentServlet;
import com.adobe.cq.social.commons.CollabUtil;
import com.adobe.cq.social.commons.Comment;
import com.adobe.cq.social.commons.CommentException;
import com.adobe.cq.social.commons.CommentSystem;
import com.adobe.cq.social.commons.events.CommentEvent;
import com.adobe.granite.security.user.UserProperties;
import com.day.cq.commons.TidyJSONWriter;
import com.day.cq.commons.jcr.JcrUtil;
import com.day.cq.replication.ReplicationActionType;
import java.io.IOException;
import java.io.Writer;
import java.util.Calendar;
import java.util.List;
import javax.activation.DataSource;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.request.RequestParameterMap;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.commons.json.JSONException;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true, label="%createcommentservlet.name", description="%createcommentservlet.description")
@Service(value={Servlet.class})
@Properties(value={@Property(name="service.vendor", value={"%day"}), @Property(name="service.description", value={"%createcommentservlet.name"}), @Property(name="sling.servlet.resourceTypes", value={"social/commons/components/comments", "social/commons/components/comments/comment"}, propertyPrivate=true), @Property(name="sling.servlet.methods", value={"POST"}, propertyPrivate=true), @Property(name="sling.servlet.selectors", value={"social.createcomment", "social.deletecomment", "social.editcomment"}, propertyPrivate=true), @Property(name="sling.servlet.extensions", value={"html", "json"}, propertyPrivate=true), @Property(name="reverseReplicate", boolValue={true}), @Property(name="fieldWhitelist", cardinality=100), @Property(name="attachmentTypeBlacklist", value={".ade", ".adp", ".app", ".asa", ".asp", ".bas", ".bat", ".cer", ".chm", ".cmd", ".com", ".cpl", ".crt", ".csh", ".dll", ".exe", ".fxp", ".hlp", ".hta", ".htm", ".html", ".htr", ".inf", ".ins", ".isp", ".its", ".js", ".jse", ".ksh", ".lnk", ".mad", ".maf", ".mag", ".mam", ".maq", ".mar", ".mas", ".mat", ".mau", ".mav", ".maw", ".mda", ".mdb", ".mde", ".mdt", ".mdw", ".mdz", ".mht", ".mhtm", ".mhtml", ".msc", ".msi", ".msp", ".mst", ".ocx", ".ops", ".pcd", ".pif", ".prf", ".prg", ".reg", ".scf", ".scr", ".sct", ".shb", ".shs", ".tmp", ".url", ".vb", ".vbe", ".vbs", ".vbx", ".vsmacros", ".vss", ".vst", ".vsw", ".ws", ".wsc", ".wsf", ".wsh", ".xsl"})})
public class CreateCommentServlet
extends AbstractCreateCommentServlet {
    public static final String TIDY = "tidy";
    public static final String TRUE = "true";
    public static final String SELECTOR_CREATECOMMENT = "social.createcomment";
    public static final String SELECTOR_DELETECOMMENT = "social.deletecomment";
    public static final String SELECTOR_EDITCOMMENT = "social.editcomment";
    public static final String SN_COMMENT_RESOURCETYPE = "commentresourcetype";
    public static final String SELECTOR_UPLOAD = "uploadCommentAttachment";
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(CreateCommentServlet.class);
    @Reference
    private EventAdmin eventAdmin;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        block26: {
            RequestPathInfo info = request.getRequestPathInfo();
            String selector = info.getSelectorString();
            UserProperties up = (UserProperties)request.adaptTo(UserProperties.class);
            String userId = up == null ? null : up.getAuthorizableID();
            Session adminSession = null;
            Session session = CollabUtil.hasModeratePermissions(request.getResource()) ? this.getSessionFromResource(request.getResource()) : (adminSession = this.createAdminSession());
            if (null == session) {
                throw new CommentException("session unavailable");
            }
            try {
                CommentSystem cs = this.getCommentSystem(request.getResource(), session);
                String msg = "";
                if (cs == null) {
                    throw new CommentException("Failed to get comment system for target '" + request.getResource().getPath() + "' ");
                }
                Session checkSession = (Session)request.getResourceResolver().adaptTo(Session.class);
                if (!CollabUtil.canAddNode(checkSession, "/content/usergenerated")) {
                    msg = "User not allowed to post comment";
                    log.warn(msg);
                    this.sendResponse(request, response, cs, null, msg);
                    return;
                }
                if (selector.equals(SELECTOR_CREATECOMMENT)) {
                    if (this.isBot(request)) {
                        msg = "Bot check failed: Parameter id is missing or has unexpected value";
                        log.info(msg);
                        this.sendResponse(request, response, cs, null, msg);
                        return;
                    }
                    String message = request.getParameter("jcr:description");
                    if (message == null || "".equals(message)) {
                        msg = "Parameter jcr:description missing or empty";
                        log.error(msg);
                        this.sendResponse(request, response, cs, null, msg);
                        return;
                    }
                    String name = request.getParameter("userIdentifier");
                    if (StringUtils.isBlank((String)name)) {
                        name = "Anonymous";
                    }
                    Comment comment = null;
                    try {
                        this.checkAuthorizableId(request, session);
                        boolean rootPathExists = this.getNode(cs.getRootPath(), session) != null;
                        List<DataSource> attachments = null;
                        if (BooleanUtils.toBoolean((Boolean)cs.allowsAttachment())) {
                            RequestParameter[] fileRequestParameters = request.getRequestParameters("file");
                            attachments = CollabUtil.getAttachmentsFromRequest(fileRequestParameters, cs.getAttachmentSizeLimit(), cs.getAllowedFileTypes(), this.attachmentTypeBlacklist);
                        }
                        comment = cs.addComment(message, name, attachments);
                        this.setCommentProperties(request, this.getNode(comment.getPath(), session));
                        cs.save();
                        msg = "Comment created: " + comment.getPath();
                        log.info(msg);
                        if (!rootPathExists) {
                            this.reverseReplicate(cs.getRootPath());
                        }
                        this.reverseReplicate(comment.getPath());
                        this.postEvent(new CommentEvent(comment.getPath(), cs.getPath(), userId, CommentEvent.CommentActions.CREATED));
                    }
                    catch (Exception e) {
                        msg = "Failed to create comment: " + e.getMessage();
                        log.error(msg, (Throwable)e);
                    }
                    if (!this.writeUGCResponse(request, response, request.getResourceResolver().getResource(comment.getPath()))) {
                        this.sendResponse(request, response, cs, comment, msg);
                    }
                    break block26;
                }
                if (selector.equals(SELECTOR_DELETECOMMENT) && cs.allowsDelete()) {
                    Comment comment = (Comment)request.getResource().adaptTo(Comment.class);
                    if (comment != null && (CollabUtil.hasModeratePermissions(comment.getResource()) || CollabUtil.isResourceOwner(comment.getResource()))) {
                        try {
                            this.deleteComment(cs, comment, session);
                        }
                        catch (RepositoryException e) {
                            response.setStatus(404);
                            log.error(e.toString());
                        }
                        response.setStatus(204);
                        break block26;
                    }
                    response.setStatus(404);
                    break block26;
                }
                if (selector.equals(SELECTOR_EDITCOMMENT) && cs.allowsEdit()) {
                    Comment comment = (Comment)request.getResource().adaptTo(Comment.class);
                    if (comment != null && (CollabUtil.hasModeratePermissions(comment.getResource()) || CollabUtil.isResourceOwner(comment.getResource()))) {
                        try {
                            this.editComment(request, comment, session);
                        }
                        catch (RepositoryException e) {
                            log.error("Editing Comment failed: '" + comment.getPath() + "'");
                        }
                        this.redirect(request, response, comment.getCommentSystem().getUrl());
                        break block26;
                    }
                    response.setStatus(404);
                    break block26;
                }
                response.setStatus(404);
            }
            finally {
                this.closeAdminSession(adminSession);
            }
        }
    }

    protected void setCommentProperties(SlingHttpServletRequest request, Node node) throws RepositoryException {
        super.setCommentProperties(request, node);
        RequestParameterMap params = request.getRequestParameterMap();
        for (String key : params.keySet()) {
            if (!ArrayUtils.contains((Object[])this.fieldWhitelist, (Object)key) || key.contains(":")) {
                log.debug("skipped custom form field [{}], not in white list.", (Object)key);
                continue;
            }
            if (!ArrayUtils.contains((Object[])RESERVED_PROPERTY_NAMES, (Object)key)) {
                RequestParameter[] values = (RequestParameter[])params.get((Object)key);
                if (values.length > 0 && values[0].isFormField()) {
                    Object value = values.length == 1 ? values[0].getString() : request.getParameterValues(key);
                    if (null == value) continue;
                    if (key.equals("userIdentifier") && ((String)value).length() == 0) {
                        log.debug("skipped custom form field \"userIdentifier\", empty value is not allowed.");
                        continue;
                    }
                    JcrUtil.setProperty((Node)node, (String)key, (Object)value);
                    continue;
                }
                log.debug("skipped custom form field [{}], empty or binary not allowed.", (Object)key);
                continue;
            }
            log.debug("skipped custom form field [{}], matches reserved field name.", (Object)key);
        }
    }

    protected void sendResponse(SlingHttpServletRequest request, SlingHttpServletResponse response, CommentSystem cs, Comment comment, String msg) {
        if (request.getPathInfo().endsWith(".json")) {
            String redirect;
            String path;
            boolean success;
            boolean bl = success = comment != null;
            if (comment != null) {
                path = comment.getPath();
                redirect = comment.getRefreshUrl();
            } else {
                path = "";
                redirect = cs.getUrl();
            }
            try {
                TidyJSONWriter out = new TidyJSONWriter((Writer)response.getWriter());
                out.setTidy(TRUE.equals(request.getParameter(TIDY)));
                out.object();
                out.key("success").value(success);
                out.key("message").value((Object)msg);
                out.key("path").value((Object)path);
                out.key("redirect").value((Object)redirect);
                out.endObject();
            }
            catch (JSONException e) {
                log.error("Unable to send JSON response", (Throwable)e);
            }
            catch (IOException e) {
                log.error("Unable to send JSON response", (Throwable)e);
            }
        } else {
            String url = request.getHeader("Referer");
            if (StringUtils.isBlank((String)url)) {
                url = null != comment ? comment.getRefreshUrl() : cs.getUrl();
            } else {
                url = StringUtils.substringBefore((String)url, (String)"#");
                url = StringUtils.substringBefore((String)url, (String)"?");
                if (null != comment) {
                    url = url + "?cq_ck=" + System.currentTimeMillis();
                    url = url + "#" + comment.getId();
                } else {
                    url = url + "#" + cs.getId();
                }
            }
            this.redirect(request, response, url);
        }
    }

    private void deleteComment(CommentSystem cs, Comment comment, Session adminSession) throws ServletException, IOException, RepositoryException {
        List<String> affectedPaths = cs.deleteComment(comment);
        adminSession.save();
        if (this.reverseReplicate) {
            this.replicator.reverseReplicate(ReplicationActionType.DELETE, affectedPaths);
        }
    }

    private void editComment(SlingHttpServletRequest request, Comment comment, Session aSession) throws RepositoryException {
        Node commentNode = aSession.getNode(comment.getPath());
        CommentSystem cs = this.getCommentSystem(request.getResource(), aSession);
        commentNode.setProperty("cq:lastModified", Calendar.getInstance());
        if (CollabUtil.hasModeratePermissions(comment.getResource())) {
            commentNode.setProperty("cq:lastModifiedBy", aSession.getUserID());
        } else {
            commentNode.setProperty("cq:lastModifiedBy", comment.getAuthor().getId());
        }
        commentNode.setProperty("jcr:description", request.getParameter("jcr:description"));
        commentNode.setProperty("jcr:title", request.getParameter("jcr:title"));
        commentNode.setProperty("approved", (Value)null);
        commentNode.setProperty("moderate", Boolean.TRUE.booleanValue());
        this.setCommentProperties(request, commentNode);
        List<DataSource> attachments = null;
        if (cs.allowsAttachment()) {
            RequestParameter[] fileRequestParameters = request.getRequestParameters("file");
            attachments = CollabUtil.getAttachmentsFromRequest(fileRequestParameters, cs.getAttachmentSizeLimit(), cs.getAllowedFileTypes(), this.attachmentTypeBlacklist);
            comment.addAttachments(attachments);
        }
        aSession.save();
        if (this.reverseReplicate) {
            this.reverseReplicate(comment.getPath());
        }
    }

    private void postEvent(CommentEvent event) {
        EventAdmin localEventAdminRef = this.eventAdmin;
        if (null != localEventAdminRef) {
            localEventAdminRef.postEvent((Event)event);
        }
    }

    protected void bindEventAdmin(EventAdmin eventAdmin) {
        this.eventAdmin = eventAdmin;
    }

    protected void unbindEventAdmin(EventAdmin eventAdmin) {
        if (this.eventAdmin == eventAdmin) {
            this.eventAdmin = null;
        }
    }
}

