/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.commons.impl.servlets;

import com.day.cq.commons.servlets.NonExistingResourceServlet;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestDispatcherOptions;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="%commonsoptingservlet.name", description="%commonsoptingservlet.description", metatype=false)
@Service(value={NonExistingResourceServlet.class})
@Property(name="service.ranking", intValue={20})
public class NonExistingResourcePostServlet
extends SlingAllMethodsServlet
implements NonExistingResourceServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(NonExistingResourcePostServlet.class);
    protected final String ATTR_SEL = "selector";
    protected static final Map<String, String> RESOURCE_TYPES = new HashMap<String, String>();

    public boolean accepts(SlingHttpServletRequest request) {
        String path = request.getResource().getPath();
        if (!request.getMethod().equalsIgnoreCase("post")) {
            return false;
        }
        for (String sel : RESOURCE_TYPES.keySet()) {
            if (!path.contains(sel)) continue;
            request.setAttribute("selector", (Object)sel);
            return true;
        }
        return false;
    }

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        String sel = (String)request.getAttribute("selector");
        if (sel != null) {
            this.forward(sel, request, response);
            return;
        }
        LOG.debug("no supported selector found");
        response.sendError(404);
    }

    protected void forward(String selector, SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        RequestDispatcherOptions options = new RequestDispatcherOptions();
        options.setReplaceSelectors(selector);
        options.setForceResourceType(RESOURCE_TYPES.get(selector));
        RequestDispatcher dispatcher = request.getRequestDispatcher(request.getResource(), options);
        dispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }

    static {
        RESOURCE_TYPES.put("social.createcomment", "social/commons/components/comments");
    }
}

