/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.commons.impl.servlets;

import com.day.cq.commons.TidyJSONWriter;
import com.day.cq.search.PredicateGroup;
import com.day.cq.search.Query;
import com.day.cq.search.QueryBuilder;
import com.day.cq.search.result.Hit;
import com.day.cq.search.result.SearchResult;
import com.day.cq.tagging.Tag;
import com.day.cq.tagging.TagManager;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.ServletException;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.commons.json.JSONException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service
@Properties(value={@Property(name="sling.servlet.paths", value={"/services/tagfilter"})})
public class TagFilterServlet
extends SlingSafeMethodsServlet {
    private static final Logger LOG = LoggerFactory.getLogger(TagFilterServlet.class);
    private static final long serialVersionUID = 1L;
    private Session session;

    protected final void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("utf-8");
        String searchTerm = request.getParameter("term");
        String tagFilter = request.getParameter("tagfilter");
        if (tagFilter == null) {
            tagFilter = "/etc/tags";
        }
        ResourceResolver resolver = request.getResource().getResourceResolver();
        this.session = (Session)resolver.adaptTo(Session.class);
        TagManager tm = (TagManager)resolver.adaptTo(TagManager.class);
        TidyJSONWriter writer = new TidyJSONWriter((Writer)response.getWriter());
        Query query = this.generateQuery(resolver, tagFilter, searchTerm);
        SearchResult result = null;
        try {
            if (query != null) {
                query.setStart(0L);
                result = query.getResult();
                writer.array();
                for (Hit hit : result.getHits()) {
                    String tagPath = hit.getPath();
                    Object titleObj = hit.getProperties().get((Object)"jcr:title");
                    String tagTitle = titleObj == null ? "" : titleObj.toString();
                    Tag tag = tm.resolve(tagPath);
                    writer.object();
                    writer.key("label");
                    writer.value((Object)tagTitle);
                    writer.key("value");
                    writer.value((Object)tagTitle);
                    writer.key("tagid");
                    writer.value((Object)tag.getTagID());
                    writer.endObject();
                }
                writer.endArray();
            }
        }
        catch (RepositoryException e) {
            LOG.error("Repository Exception", (Throwable)e);
        }
        catch (JSONException e) {
            LOG.error("JSON Exception", (Throwable)e);
        }
    }

    private Query generateQuery(ResourceResolver resolver, String tagFilter, String searchTerm) {
        Query query = null;
        int gIndex = 1;
        QueryBuilder builder = (QueryBuilder)resolver.adaptTo(QueryBuilder.class);
        HashMap<String, String> map = new HashMap<String, String>();
        String[] tagFilterArr = tagFilter.split(",");
        map.put("type", "cq:Tag");
        map.put(gIndex + "_group.p.or", "true");
        for (int i = 0; i < tagFilterArr.length; ++i) {
            map.put(gIndex + "_group." + (i + 1) + "_path", tagFilterArr[i]);
        }
        map.put(++gIndex + "_group.p.or", "false");
        map.put(gIndex + "_group.1_fulltext", searchTerm + "*");
        map.put(gIndex + "_group.1_fulltext.relPath", "@jcr:title");
        query = builder.createQuery(PredicateGroup.create(map), this.session);
        return query;
    }
}

