/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.commons.index.impl.comment;

import com.adobe.cq.social.commons.Comment;
import com.adobe.cq.social.commons.index.impl.comment.CommentIndexManager;
import com.adobe.cq.social.commons.index.impl.comment.CommentReindexer;
import com.adobe.cq.social.storage.index.AbstractBaseIndexHandler;
import com.adobe.cq.social.storage.index.CommentIndexHandlerExtension;
import com.adobe.cq.social.storage.index.EventTopicsType;
import com.adobe.cq.social.storage.index.IndexHandler;
import com.adobe.cq.social.storage.index.IndexHandlerCollection;
import com.adobe.cq.social.storage.index.IndexUtil;
import com.day.text.Text;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(metatype=true, immediate=true, policy=ConfigurationPolicy.OPTIONAL, label="%commentIndexHandler.name", description="%commentIndexHandler.description")
@Service(value={IndexHandler.class, CommentReindexer.class})
@Reference(name="extensionProvider", referenceInterface=CommentIndexHandlerExtension.class, bind="bindExtension", unbind="unbindExtension", cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC)
public class CommentIndexHandler
extends AbstractBaseIndexHandler
implements CommentReindexer {
    @Reference
    private IndexHandlerCollection indexHandlers;
    private static final Set<String> TARGET_MODIFIED_ATTRIBUTES = new HashSet<String>();
    private static final Set<String> TARGET_ADDED_REMOVED_ATTRIBUTES;
    private static final Set<String> ADDED_CHANGED_RESOURCE_TYPES;
    private static Set<String> allowedComponentResourceTypes;
    private static Set<String> allowedComponentParName;
    private static final Logger log;

    public CommentIndexHandler() {
        super(TARGET_MODIFIED_ATTRIBUTES, TARGET_ADDED_REMOVED_ATTRIBUTES, ADDED_CHANGED_RESOURCE_TYPES, ADDED_CHANGED_RESOURCE_TYPES);
    }

    protected void activate(ComponentContext context) {
        this.indexHandlers.registerIndexHandler((IndexHandler)this);
    }

    public void bindExtension(CommentIndexHandlerExtension extension) {
        allowedComponentResourceTypes.add(extension.getComponentResourceType());
        allowedComponentParName.add(extension.getParName());
    }

    public void unbindExtension(CommentIndexHandlerExtension extension) {
        allowedComponentResourceTypes.remove(extension.getComponentResourceType());
        allowedComponentParName.remove(extension.getParName());
    }

    @Override
    public void indexExec(ResourceResolver resolver, String nodePath) throws Exception {
        this.indexExec(resolver, nodePath, (Enum<EventTopicsType>)EventTopicsType.ADDED);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void indexExec(ResourceResolver resolver, String nodePath, Enum<EventTopicsType> eventTopicsType) throws Exception {
        String prevIndexKey;
        boolean isDelete = eventTopicsType == EventTopicsType.DELETED;
        String indexPath = IndexUtil.getBaseIndexFolder((ResourceResolver)resolver, (String)nodePath);
        Resource resourcePathRes = resolver.getResource(indexPath);
        if (isDelete && resourcePathRes == null) {
            return;
        }
        CommentIndexManager indexManager = CommentIndexManager.getInstance(resolver, indexPath, true);
        String keyIndexName = null;
        String allIndexName = "all";
        String filteredIndexName = "filtered";
        Resource resource = isDelete ? null : resolver.getResource(nodePath);
        Comment target = isDelete ? null : (Comment)resource.adaptTo(Comment.class);
        String parentCommentRelPath = null;
        if (isDelete) {
            Resource parentResource = resolver.getResource(nodePath.substring(0, nodePath.lastIndexOf(47)));
            if (null == parentResource) {
                return;
            }
            parentCommentRelPath = CommentIndexManager.getParentRelPath(parentResource);
        } else {
            parentCommentRelPath = CommentIndexManager.getParentRelPath(resource);
        }
        if (parentCommentRelPath != null) {
            indexManager.initCommentReplyIndexer(parentCommentRelPath, resolver, true);
            keyIndexName = parentCommentRelPath;
            allIndexName = parentCommentRelPath + "all";
            filteredIndexName = parentCommentRelPath + "filtered";
        }
        String relPath = CommentIndexManager.getCommentRelativePath(nodePath);
        String targetId = relPath.substring(relPath.lastIndexOf(47) + 1);
        String keyIndexContent = indexManager.getKeyIndexer(keyIndexName).getIndex(resolver, (Object)targetId, null);
        String string = prevIndexKey = keyIndexContent == null ? null : keyIndexContent.split(",")[1];
        if (isDelete) {
            if (prevIndexKey == null) return;
            indexManager.unindex(allIndexName, resolver, keyIndexName, targetId, new Long(prevIndexKey), relPath);
            indexManager.unindex(filteredIndexName, resolver, keyIndexName, targetId, new Long(prevIndexKey), relPath);
            indexManager.delete(relPath, resolver);
        } else if (keyIndexContent != null) {
            String prevIndex;
            if (target.isApproved()) {
                prevIndex = indexManager.getIndex(filteredIndexName, resolver, new Long(prevIndexKey), relPath);
                if (prevIndex != null) {
                    indexManager.unindex(filteredIndexName, resolver, null, targetId, new Long(prevIndexKey), relPath);
                }
            } else {
                prevIndex = indexManager.getIndex(filteredIndexName, resolver, new Long(prevIndexKey), relPath);
                if (prevIndex == null) {
                    indexManager.index(filteredIndexName, resolver, keyIndexName, targetId, target, new Long(prevIndexKey), relPath);
                }
            }
        } else {
            indexManager.index(allIndexName, resolver, keyIndexName, targetId, target, target.getDate().getTime(), relPath);
            if (!target.isApproved()) {
                indexManager.index(filteredIndexName, resolver, keyIndexName, targetId, target, target.getDate().getTime(), relPath);
            }
        }
        Session session = (Session)resolver.adaptTo(Session.class);
        if (session == null) {
            throw new IllegalArgumentException("resolver must be adaptable to session");
        }
        session.save();
    }

    public boolean handleEvent(ResourceResolver resolver, String resourceType, String eventTopics, String nodePath, String[] resourceChangedAttributes, String[] resourceAddedAttributes, String[] resourceRemovedAttributes) throws Exception {
        boolean isDelete = eventTopics.equals("org/apache/sling/api/resource/Resource/REMOVED");
        EventTopicsType eventTopicsType = null;
        if (isDelete) {
            eventTopicsType = EventTopicsType.DELETED;
        }
        if (!this.isIndexableComment(nodePath, resolver)) {
            return false;
        }
        return this.handleEvent(resolver, resourceType, eventTopics, nodePath, resourceChangedAttributes, resourceAddedAttributes, resourceRemovedAttributes, (Enum)eventTopicsType);
    }

    private boolean isIndexableComment(String nodePath, ResourceResolver resolver) {
        if (nodePath == null || !nodePath.startsWith("/content/usergenerated")) {
            return false;
        }
        String componentPath = nodePath.substring("/content/usergenerated".length());
        int parLoc = componentPath.indexOf("jcr:content");
        if (parLoc == -1) {
            return false;
        }
        int endLoc = componentPath.indexOf(47, parLoc += "jcr:content".length() + 1);
        if (endLoc == -1) {
            return false;
        }
        Resource resource = null;
        resource = resolver.getResource(componentPath = componentPath.substring(0, parLoc) + "par/" + componentPath.substring(parLoc, endLoc));
        if (resource == null) {
            String path = this.getComponentPath(nodePath, resolver);
            if (path == null) {
                return false;
            }
            resource = resolver.getResource(path);
            if (resource == null && this.isCQIncludeComponentNode(path)) {
                return true;
            }
        }
        if (resource == null) {
            for (String parName : allowedComponentParName) {
                resource = resolver.getResource(componentPath = componentPath.substring(0, parLoc) + "par/" + parName);
                if (resource == null) continue;
                break;
            }
        }
        if (resource == null) {
            return false;
        }
        for (String cResourceType : allowedComponentResourceTypes) {
            if (!ResourceUtil.isA((Resource)resource, (String)cResourceType)) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return "CommentIndexHandler";
    }

    private boolean isCQIncludeComponentNode(String componentNodePath) {
        return componentNodePath.endsWith("social.createcomment.html") || componentNodePath.endsWith("social.createcomment.json");
    }

    private String getComponentPath(String nodePath, ResourceResolver resolver) {
        String componentPath = null;
        Resource resource = resolver.getResource(nodePath);
        if (resource != null) {
            Node parent = null;
            if ((resource = resource.getParent()) != null) {
                parent = (Node)resource.adaptTo(Node.class);
            }
            try {
                while (parent != null && !"jcr:content".equals(parent.getName())) {
                    if (parent.hasProperty("commentsNode")) {
                        componentPath = parent.getProperty("commentsNode").getString();
                        break;
                    }
                    parent = parent.getParent();
                }
            }
            catch (RepositoryException e) {
                log.error("Error computing component path for " + nodePath, (Throwable)e);
            }
        }
        if (componentPath == null) {
            String path = nodePath.substring("/content/usergenerated".length());
            Resource cres = null;
            String prevName = "";
            while (cres == null && !"/".equals(path)) {
                prevName = Text.getName((String)path);
                path = path.substring(0, path.lastIndexOf("/"));
                cres = resolver.getResource(path);
            }
            Resource parent = resolver.getResource(path);
            Iterator children = parent.listChildren();
            while (children.hasNext()) {
                String parName = ((Resource)children.next()).getName();
                String childPath = path + "/" + parName + "/" + prevName;
                Resource child = resolver.getResource(childPath);
                if (child == null || !ResourceUtil.isA((Resource)child, (String)"social/commons/components/comments")) continue;
                componentPath = childPath;
                break;
            }
        }
        return componentPath;
    }

    static {
        TARGET_MODIFIED_ATTRIBUTES.add("approved");
        TARGET_MODIFIED_ATTRIBUTES.add("isSpam");
        TARGET_ADDED_REMOVED_ATTRIBUTES = new HashSet<String>();
        TARGET_ADDED_REMOVED_ATTRIBUTES.add("approved");
        TARGET_ADDED_REMOVED_ATTRIBUTES.add("isSpam");
        ADDED_CHANGED_RESOURCE_TYPES = new HashSet<String>();
        ADDED_CHANGED_RESOURCE_TYPES.add("social/commons/components/comments/comment");
        allowedComponentResourceTypes = Collections.synchronizedSet(new HashSet());
        allowedComponentResourceTypes.add("social/commons/components/comments");
        allowedComponentParName = Collections.synchronizedSet(new HashSet());
        log = LoggerFactory.getLogger(CommentIndexHandler.class);
    }

    protected void bindIndexHandlers(IndexHandlerCollection indexHandlerCollection) {
        this.indexHandlers = indexHandlerCollection;
    }

    protected void unbindIndexHandlers(IndexHandlerCollection indexHandlerCollection) {
        if (this.indexHandlers == indexHandlerCollection) {
            this.indexHandlers = null;
        }
    }
}

