/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.commons.index.impl.comment;

import com.adobe.cq.social.commons.Comment;
import com.adobe.cq.social.commons.index.impl.comment.CommentIndexer;
import com.adobe.cq.social.storage.index.AbstractBaseIndexManager;
import com.adobe.cq.social.storage.index.KeyIndexer;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommentIndexManager
extends AbstractBaseIndexManager<Long, Comment> {
    private final String path;
    private static final Logger log = LoggerFactory.getLogger(CommentIndexManager.class);

    private CommentIndexManager(String path) {
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        this.path = path;
    }

    public static CommentIndexManager getInstance(ResourceResolver resolver, String path, boolean writeMode) throws RepositoryException {
        CommentIndexManager indexManager = new CommentIndexManager(path);
        CommentIndexer allIndex = new CommentIndexer("all", "all", resolver, path, writeMode);
        CommentIndexer filteredIndex = new CommentIndexer("filtered", "filtered", resolver, path, writeMode);
        KeyIndexer keyIndexer = new KeyIndexer(null, resolver, path, "key", writeMode);
        indexManager.indexers.put(allIndex.getId(), allIndex);
        indexManager.indexers.put(filteredIndex.getId(), filteredIndex);
        indexManager.keyIndexers.put(keyIndexer.getName(), keyIndexer);
        return indexManager;
    }

    public void initCommentReplyIndexer(String parentRelPath, ResourceResolver resolver, boolean writeMode) throws RepositoryException {
        if (!this.isRegistered(parentRelPath)) {
            String indexPath = this.path + parentRelPath;
            CommentIndexer allIndex = new CommentIndexer("all", parentRelPath + "all", resolver, indexPath, writeMode);
            CommentIndexer filteredIndex = new CommentIndexer("filtered", parentRelPath + "filtered", resolver, indexPath, writeMode);
            KeyIndexer keyIndexer = new KeyIndexer(parentRelPath, resolver, indexPath, "key", writeMode);
            this.indexers.put(allIndex.getId(), allIndex);
            this.indexers.put(filteredIndex.getId(), filteredIndex);
            this.keyIndexers.put(keyIndexer.getName(), keyIndexer);
        }
    }

    public static String getCommentRelativePath(String path) {
        int relPathStart = path.indexOf("jcr:content") + "jcr:content".length() + 2;
        relPathStart = path.indexOf(47, relPathStart) + 1;
        String relPath = path.substring(relPathStart);
        return relPath;
    }

    public static String getParentRelPath(Resource resource) {
        for (Resource parent = resource.getParent(); parent != null; parent = parent.getParent()) {
            try {
                Property primaryType = ((Node)parent.adaptTo(Node.class)).getProperty("jcr:primaryType");
                if (primaryType.getString().equals("nt:unstructured")) {
                    return null;
                }
                if (!primaryType.getString().equals("cq:Comment")) continue;
                String nodePath = parent.getPath();
                int relPathStart = nodePath.indexOf("jcr:content") + "jcr:content".length() + 2;
                relPathStart = nodePath.indexOf(47, relPathStart) + 1;
                String relPath = nodePath.substring(relPathStart);
                return relPath;
            }
            catch (RepositoryException e) {
                log.error("Error computing parentRelPath for " + resource.getPath(), (Throwable)e);
                return null;
            }
        }
        return null;
    }

    public void delete(String relPath, ResourceResolver resolver) throws RepositoryException {
        Resource folder = resolver.getResource(this.path + relPath);
        if (folder == null) {
            return;
        }
        Node folderNode = (Node)folder.adaptTo(Node.class);
        folderNode.remove();
    }
}

