/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.commons.index.impl.comment;

import com.adobe.cq.social.commons.CollabUtil;
import com.adobe.cq.social.commons.index.impl.comment.CommentReindexer;
import com.adobe.cq.social.storage.index.AbstractBaseReindexer;
import java.util.Dictionary;
import java.util.List;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.sling.api.adapter.AdapterFactory;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.jcr.api.SlingRepository;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true, immediate=true, policy=ConfigurationPolicy.OPTIONAL, label="%commentReindexHandler.name", description="%commentReindexHandler.description")
public class CommentReindexHandler
extends AbstractBaseReindexer {
    private static final Logger log = LoggerFactory.getLogger(CommentReindexHandler.class);
    @Reference
    private CommentReindexer commentReindexer;
    @Reference
    protected ResourceResolverFactory resolverFactory;
    @Reference(policy=ReferencePolicy.STATIC, bind="bind", unbind="unbind")
    private SlingRepository repository;
    @Reference(bind="bindCommentAdapter", unbind="unbindCommentAdapter", target="(adapters=com.adobe.cq.social.commons.Comment)")
    private AdapterFactory commentAdapter;
    @Property(value={"5"})
    private static final String THROTTLE_PER_SEC_PROPERTY = "throttle.persec";
    private int throttle = 5;

    public void unbindCommentAdapter(AdapterFactory adapter) {
        this.commentAdapter = null;
    }

    public void bindCommentAdapter(AdapterFactory adapter) {
        this.commentAdapter = adapter;
        List reindexPaths = this.findReindexPaths(this.resolverFactory, "/content/usergenerated", "commentsNode");
        if (reindexPaths != null) {
            for (String path : reindexPaths) {
                try {
                    this.reindex(path, this.throttle, this.resolverFactory, this.repository);
                }
                catch (Exception e) {
                    log.error("Error reindexing " + path, (Throwable)e);
                }
            }
        }
    }

    protected void activate(ComponentContext context) throws Exception {
        Dictionary props = context.getProperties();
        Object prop = props.get(THROTTLE_PER_SEC_PROPERTY);
        if (prop != null && prop.toString().length() > 0) {
            this.throttle = Integer.parseInt(prop.toString().trim());
        }
    }

    protected void bind(SlingRepository repository) {
        this.repository = repository;
    }

    protected void unbind(SlingRepository repository) {
        this.repository = null;
    }

    public boolean checkResource(Resource resource) {
        return ResourceUtil.isA((Resource)resource, (String)"social/commons/components/comments");
    }

    public String getUGCPath(Resource resource) {
        return CollabUtil.resourceToUGCPath(resource);
    }

    public String getTopLevelPrefix() {
        return "Bucket";
    }

    public String getLowerLevelPrefix() {
        return "Bucket";
    }

    public void indexExec(ResourceResolver resolver, String nodePath) throws Exception {
        this.commentReindexer.indexExec(resolver, nodePath);
    }

    protected void bindCommentReindexer(CommentReindexer commentReindexer) {
        this.commentReindexer = commentReindexer;
    }

    protected void unbindCommentReindexer(CommentReindexer commentReindexer) {
        if (this.commentReindexer == commentReindexer) {
            this.commentReindexer = null;
        }
    }

    protected void bindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resolverFactory = resourceResolverFactory;
    }

    protected void unbindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resolverFactory == resourceResolverFactory) {
            this.resolverFactory = null;
        }
    }
}

