/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.commons.ugc.impl.index;

import com.adobe.cq.social.commons.Comment;
import com.adobe.cq.social.commons.CommentSystem;
import com.adobe.cq.social.commons.index.CommentSCIndexExtension;
import com.adobe.cq.social.commons.ugc.impl.index.ModerationExtension;
import com.adobe.cq.social.ugc.api.AbstractUgcNodeIndexerExtension;
import com.adobe.cq.social.ugc.api.UgcIndexProperty;
import com.adobe.cq.social.ugc.api.UgcIndexerUtil;
import com.adobe.cq.social.ugc.api.UgcNodeIndexerExtension;
import com.day.cq.wcm.api.WCMMode;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeType;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(metatype=true, immediate=true, policy=ConfigurationPolicy.OPTIONAL, label="%moderationUgcNodeIndexerExtension.name", description="%moderationUgcNodeIndexerExtension.description")
@Service(value={UgcNodeIndexerExtension.class, ModerationExtension.class})
@Reference(name="extensionProvider", referenceInterface=CommentSCIndexExtension.class, bind="bindExtension", unbind="unbindExtension", cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC)
public class ModerationUgcNodeIndexerExtension
extends AbstractUgcNodeIndexerExtension
implements ModerationExtension {
    private final Map<String, CommentSCIndexExtension> extensions = new HashMap<String, CommentSCIndexExtension>();
    private static final String FIELD_MODIFIED_DATE = "modifiedDate";
    private static final String FIELD_USER_IDENTIFIER = "userIdentifier".intern();
    private static final String FIELD_SPAM = "spam".intern();
    private static final String FIELD_ATTACHMENTS = "attachments";
    private static final String FIELD_REPLIES = "replies";
    private static final String FIELD_ALLOW_THREADED_REPLIES = "allowThreadedReply";
    private static final String FIELD_STATE_APPROVED = "approved";
    private static final String FIELD_STATE_PENDING = "pending";
    private static final String FIELD_STATE_DENIED = "denied";
    private static final String FIELD_STATE_SPAM = "spam";
    private static final String FIELD_FLAGGED = "flagged";
    private static final String FIELD_READ = "read";
    private static final String FIELD_INFLUENCE = "influence";
    private static final String FIELD_SENTIMENT = "sentiment";
    private static final String FIELD_PARENT_PATH = "parentPath";
    private static final String FIELD_PARENT_TITLE = "parentTitle";
    private static final String PROP_FLAGGED = "isFlagged";
    private static final String FIELD_STATE = "state".intern();
    private static final String CONTENT_PATH = "/content/usergenerated/content";
    public static final String NAME = "ugc-sc";
    private static final Logger log = LoggerFactory.getLogger(ModerationUgcNodeIndexerExtension.class);

    public String getName() {
        return NAME;
    }

    @Activate
    protected void activate(ComponentContext context) throws RepositoryException {
        this.enabled = OsgiUtil.toBoolean(context.getProperties().get("indexer.extension.enabled"), (boolean)true);
    }

    protected void deactivate(ComponentContext context) {
    }

    public void bindExtension(CommentSCIndexExtension extension) {
        this.extensions.put(extension.getName(), extension);
    }

    public void unbindExtension(CommentSCIndexExtension extension) {
        this.extensions.remove(extension.getName());
    }

    public boolean checkPrimaryType(NodeType primaryType) {
        return primaryType.getName().equals("cq:Comment");
    }

    public boolean checkResource(Resource resource) {
        return resource != null && (ResourceUtil.isA((Resource)resource, (String)"social/commons/components/comments/comment") || ResourceUtil.isA((Resource)resource, (String)"collab/commons/components/comments/comment"));
    }

    @Override
    public String getContextURL(Comment comment) throws RepositoryException {
        Resource resource = comment.getResource();
        String resourceType = resource.getResourceType();
        Node node = (Node)resource.adaptTo(Node.class);
        for (CommentSCIndexExtension ext : this.extensions.values()) {
            if (!ext.checkPrimaryType(node.getPrimaryNodeType().getName()) || resourceType == null || !ext.checkResource(resource)) continue;
            return ext.getContextURL(resource);
        }
        return comment.getUrl();
    }

    public List<UgcIndexProperty> getUgcIndexProperties(ResourceResolver resolver, Node node) throws RepositoryException {
        String val;
        Resource resource = resolver.getResource(node.getPath());
        LinkedList<UgcIndexProperty> result = new LinkedList<UgcIndexProperty>();
        Comment comment = (Comment)resource.adaptTo(Comment.class);
        result.add(new UgcIndexProperty(FIELD_SPAM, (Object)Boolean.toString(comment.isSpam()), false, UgcIndexProperty.Index.NOT_ANALYZED_NO_NORMS));
        Property flagged = node.hasProperty(PROP_FLAGGED) ? node.getProperty(PROP_FLAGGED) : null;
        Property read = node.hasProperty(FIELD_READ) ? node.getProperty(FIELD_READ) : null;
        Property influence = node.hasProperty(FIELD_INFLUENCE) ? node.getProperty(FIELD_INFLUENCE) : null;
        Property sentiment = node.hasProperty(FIELD_SENTIMENT) ? node.getProperty(FIELD_SENTIMENT) : null;
        String state = null;
        if (comment.isApproved()) {
            state = FIELD_STATE_APPROVED;
        } else if (comment.isDenied()) {
            state = FIELD_STATE_DENIED;
        } else if (comment.isPending()) {
            state = FIELD_STATE_PENDING;
        } else if (comment.isSpam()) {
            state = FIELD_STATE_SPAM;
        }
        if (state != null) {
            result.add(new UgcIndexProperty(FIELD_STATE, (Object)state, false, UgcIndexProperty.Index.NOT_ANALYZED_NO_NORMS));
        }
        result.add(new UgcIndexProperty(FIELD_FLAGGED, (Object)(flagged == null ? Boolean.FALSE.toString() : flagged.getString()), false, UgcIndexProperty.Index.NOT_ANALYZED_NO_NORMS));
        if (node.hasProperty("added")) {
            result.add(new UgcIndexProperty("added", (Object)UgcIndexerUtil.dateToString((Date)node.getProperty("added").getDate().getTime()), false, UgcIndexProperty.Index.NOT_ANALYZED_NO_NORMS));
        } else {
            result.add(new UgcIndexProperty("added", (Object)UgcIndexerUtil.dateToString((Date)comment.getDate()), false, UgcIndexProperty.Index.NOT_ANALYZED_NO_NORMS));
        }
        result.add(new UgcIndexProperty(FIELD_READ, (Object)(read == null ? Boolean.FALSE.toString() : read.getString()), false, UgcIndexProperty.Index.NOT_ANALYZED_NO_NORMS));
        result.add(new UgcIndexProperty(FIELD_INFLUENCE, (Object)(influence == null ? "1" : String.valueOf(influence.getLong())), false, UgcIndexProperty.Index.NOT_ANALYZED_NO_NORMS));
        result.add(new UgcIndexProperty(FIELD_SENTIMENT, (Object)(sentiment == null ? "1" : String.valueOf(sentiment.getLong())), false, UgcIndexProperty.Index.NOT_ANALYZED_NO_NORMS));
        Property date = node.hasProperty("jcr:lastModified") ? node.getProperty("jcr:lastModified") : node.getProperty("jcr:created");
        result.add(new UgcIndexProperty(FIELD_MODIFIED_DATE, (Object)UgcIndexerUtil.dateToString((Date)date.getDate().getTime()), false, UgcIndexProperty.Index.NOT_ANALYZED_NO_NORMS));
        if (node.hasProperty("userIdentifier")) {
            Property userIdentifierProperty = node.getProperty("userIdentifier");
            result.add(new UgcIndexProperty(FIELD_USER_IDENTIFIER, (Object)userIdentifierProperty.getString(), false, UgcIndexProperty.Index.NOT_ANALYZED_NO_NORMS));
        }
        if (node.hasProperty("jcr:title")) {
            val = node.getProperty("jcr:title").getString();
            result.add(new UgcIndexProperty("jcr:title", (Object)val, true, UgcIndexProperty.Index.ANALYZED));
        }
        if (node.hasProperty("jcr:description")) {
            val = node.getProperty("jcr:description").getString();
            result.add(new UgcIndexProperty("jcr:description", (Object)val, true, UgcIndexProperty.Index.ANALYZED));
        }
        result.add(new UgcIndexProperty(FIELD_ATTACHMENTS, (Object)Boolean.toString(node.hasNode(FIELD_ATTACHMENTS)), false, UgcIndexProperty.Index.NOT_ANALYZED_NO_NORMS));
        String resourceType = resource.getResourceType();
        boolean extUsed = false;
        HashMap<String, UgcIndexProperty> extProps = new HashMap<String, UgcIndexProperty>();
        for (CommentSCIndexExtension ext : this.extensions.values()) {
            if (!ext.checkPrimaryType(node.getPrimaryNodeType().getName()) || resourceType == null || !ext.checkResource(resource)) continue;
            try {
                ext.getUgcIndexProperties(extProps, resolver, node);
            }
            catch (Throwable t) {
                log.error("Error retriving extention properties for " + node.getPath(), t);
            }
            extUsed = true;
        }
        result.addAll(extProps.values());
        if (!extUsed && ResourceUtil.isA((Resource)resource, (String)"social/commons/components/comments/comment")) {
            result.add(new UgcIndexProperty("resourceType", (Object)resourceType, false, UgcIndexProperty.Index.NOT_ANALYZED_NO_NORMS));
            CommentSystem cs = (CommentSystem)resource.adaptTo(CommentSystem.class);
            result.add(new UgcIndexProperty(FIELD_REPLIES, (Object)String.valueOf(cs.countComments(WCMMode.EDIT)), false, UgcIndexProperty.Index.NOT_ANALYZED_NO_NORMS));
            result.add(new UgcIndexProperty(FIELD_ALLOW_THREADED_REPLIES, (Object)String.valueOf(cs.allowsReplies()), false, UgcIndexProperty.Index.NOT_ANALYZED_NO_NORMS));
            for (Node parent = node.getNode("../"); parent != null && !"jcr:content".equals(parent.getName()); parent = parent.getNode("../")) {
                String pResourceType;
                String string = pResourceType = parent.hasProperty("sling:resourceType") ? parent.getProperty("sling:resourceType").getString() : null;
                if (!"social/commons/components/comments/comment".equals(pResourceType)) continue;
                result.add(new UgcIndexProperty(FIELD_PARENT_PATH, (Object)parent.getPath(), false, UgcIndexProperty.Index.NOT_ANALYZED_NO_NORMS));
                Property msg = parent.hasProperty("jcr:description") ? parent.getProperty("jcr:description") : null;
                result.add(new UgcIndexProperty(FIELD_PARENT_TITLE, (Object)(msg == null ? "" : msg.getString()), false, UgcIndexProperty.Index.NOT_ANALYZED_NO_NORMS));
            }
        }
        return result;
    }

    public String[] getPrimaryTypes() {
        return new String[]{"cq:Comment"};
    }

    public String getIncludePaths() {
        return CONTENT_PATH;
    }
}

