/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.commons.ugc.impl.servlets;

import com.adobe.cq.social.commons.CollabUtil;
import com.adobe.cq.social.commons.Comment;
import com.adobe.cq.social.commons.ugc.impl.index.ModerationExtension;
import com.adobe.cq.social.ugc.api.RelatedSearch;
import com.adobe.cq.social.ugc.api.SearchResults;
import com.adobe.cq.social.ugc.api.UgcFilter;
import com.adobe.cq.social.ugc.api.UgcIndexProperty;
import com.adobe.cq.social.ugc.api.UgcIndexerUtil;
import com.adobe.cq.social.ugc.api.UgcSearch;
import com.adobe.granite.xss.XSSAPI;
import com.day.cq.commons.servlets.AbstractListServlet;
import com.day.cq.security.profile.Profile;
import com.day.cq.security.profile.ProfileManager;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.PageManagerFactory;
import com.day.text.Text;
import java.io.IOException;
import java.io.Writer;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.servlet.ServletException;
import org.apache.commons.collections.Predicate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.io.JSONWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(metatype=false)
@Service
@Properties(value={@Property(name="sling.servlet.resourceTypes", value={"sling/servlet/default"}), @Property(name="sling.servlet.selectors", value={"ugcsc"}), @Property(name="sling.servlet.extensions", value={"json"}), @Property(name="sling.servlet.methods", value={"GET"})})
public class ScCommentListServlet
extends AbstractListServlet {
    private static final long serialVersionUID = 1L;
    @Reference
    private ModerationExtension moderationExtension;
    public static final String QUERY = "query";
    public static final String START = "start";
    public static final String LIMIT = "limit";
    public static final String VIEW = "view";
    public static final String NOT_VIEW = "notview";
    public static final String RESOURCE_TYPE = "resourcetype";
    public static final String NOT_RESOURCE_TYPE = "notresourcetype";
    public static final String PATH = "path";
    public static final String MIN_DATE = "mindate";
    public static final String MAX_DATE = "maxdate";
    public static final String SORT = "sort";
    public static final String DIR = "dir";
    public static final String ADDED_BY = "addedBy";
    public static final String NOT_ADDED_BY = "notaddedby";
    public static final String VIEW_SPAM = "spam";
    public static final String VIEW_NOT_SPAM = "notspam";
    public static final String VIEW_PENDING = "pending";
    public static final String VIEW_APPROVED = "approved";
    public static final String VIEW_DENIED = "denied";
    public static final String FLAGGED = "flagged";
    private static final String STATE_CONSTRAINT_GROUP = "state";
    private static final String FEATURES_CONSTRAINT_GROUP = "features";
    public static final String ANSWERED = "answered";
    public static final String CHOSEN_ANSWER = "chosenanswer";
    public static final String ATTACHMENTS = "attachments";
    public static final String ATTACHMENT_PATHS = "attachmentpaths";
    public static final String REPLIED = "replied";
    public static final String REPLIES = "replies";
    public static final String READ = "read";
    public static final String SENTIMENT_GTE = "sentimentgte";
    public static final String SENTIMENT_LTE = "sentimentlte";
    public static final String INFLUENCE_GTE = "influencegte";
    public static final String INFLUENCE_LTE = "influencelte";
    public static final String SENTIMENT = "sentiment";
    public static final String INFLUENCE = "influence";
    private static final Map<String, String> SORT_PARAM_PROPERTY_MAP = new HashMap<String, String>();
    private static final String DEFAULT_SORT = "added";
    private PageManager pageManager;
    @Reference
    protected UgcSearch ugcSearch;
    @Reference
    private RelatedSearch relatedSearch;
    @Reference
    protected ProfileManager profileMgr;
    @Reference
    protected PageManagerFactory pageManagerFactory;
    @Reference
    private XSSAPI xssAPI;

    protected List<AbstractListServlet.ListItem> applyPaging(SlingHttpServletRequest request, List<AbstractListServlet.ListItem> items, int total) {
        return items;
    }

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response, Predicate predicate) throws ServletException, IOException {
        try {
            if (request.getParameter("index") != null) {
                String path = request.getParameter(PATH);
                this.writePagingIndex(request, response, path, this.getUgcFilter(request));
                return;
            }
            SearchResults<AbstractListServlet.ListItem> results = this.searchItems(request, predicate);
            int total = (int)results.getTotalNumberOfResults();
            List items = results.getResults();
            String[] customProps = request.getParameterValues("prop");
            this.write(request, response, items, customProps, total);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected void writePagingIndex(SlingHttpServletRequest request, SlingHttpServletResponse response, String path, UgcFilter filter) throws Exception {
        int pageIndex;
        response.setContentType("application/json");
        response.setCharacterEncoding("utf-8");
        JSONWriter writer = new JSONWriter((Writer)response.getWriter());
        writer.setTidy("true".equals(request.getParameter("tidy")));
        writer.object();
        Resource resource = request.getResource();
        ResourceResolver resolver = resource.getResourceResolver();
        Resource target = resolver.getResource(path);
        if (target == null) {
            pageIndex = 0;
        } else {
            long added = ((Node)target.adaptTo(Node.class)).getProperty(DEFAULT_SORT).getDate().getTime().getTime();
            int index = this.ugcSearch.getIndex("ugc-sc", (Session)request.getResourceResolver().adaptTo(Session.class), filter, path, added);
            String limitString = request.getParameter(LIMIT);
            int limit = 30;
            if (null != limitString) {
                try {
                    limit = Integer.parseInt(limitString);
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
            pageIndex = index / limit;
        }
        writer.key("index").value((long)pageIndex);
        writer.endObject();
    }

    private UgcFilter getUgcFilter(SlingHttpServletRequest request) throws ParseException {
        int i;
        String[] views = request.getParameterValues(VIEW);
        String[] notViews = request.getParameterValues(NOT_VIEW);
        String[] addedBy = request.getParameterValues(ADDED_BY);
        String[] notAddedBy = request.getParameterValues(NOT_ADDED_BY);
        String[] resourceTypes = request.getParameterValues(RESOURCE_TYPE);
        String[] notResourceTypes = request.getParameterValues(NOT_RESOURCE_TYPE);
        String[] paths = request.getParameterValues(PATH);
        String answered = request.getParameter(ANSWERED);
        String chosenAnswer = request.getParameter(CHOSEN_ANSWER);
        String attachments = request.getParameter(ATTACHMENTS);
        String replied = request.getParameter(REPLIED);
        String read = request.getParameter(READ);
        String flagged = request.getParameter(FLAGGED);
        String sentimentgte = request.getParameter(SENTIMENT_GTE);
        String sentimentlte = request.getParameter(SENTIMENT_LTE);
        String influencegte = request.getParameter(INFLUENCE_GTE);
        String influencelte = request.getParameter(INFLUENCE_LTE);
        if (addedBy == null || addedBy.length == 0) {
            addedBy = request.getParameterValues(ADDED_BY.toLowerCase());
        }
        String mindate = request.getParameter(MIN_DATE);
        String maxdate = request.getParameter(MAX_DATE);
        UgcFilter filter = new UgcFilter();
        String sortString = request.getParameter(SORT);
        String dirString = request.getParameter(DIR);
        String sortProperty = SORT_PARAM_PROPERTY_MAP.get(sortString == null ? DEFAULT_SORT : sortString);
        if (dirString == null || dirString.equalsIgnoreCase("asc")) {
            filter.sortByAscending(sortProperty);
        } else {
            filter.sortByDescending(sortProperty);
        }
        if (notViews == null || notViews.length == 0) {
            for (i = 0; i < (views == null ? 0 : views.length); ++i) {
                if (VIEW_SPAM.equals(views[i])) {
                    filter.filterOrByProperty(STATE_CONSTRAINT_GROUP, VIEW_SPAM, UgcFilter.Comparison.EQUALS);
                    continue;
                }
                if (VIEW_NOT_SPAM.equals(views[i])) {
                    filter.filterOrByProperty(STATE_CONSTRAINT_GROUP, VIEW_SPAM, UgcFilter.Comparison.NOT_EQUALS);
                    continue;
                }
                if (VIEW_APPROVED.equals(views[i])) {
                    filter.filterOrByProperty(STATE_CONSTRAINT_GROUP, VIEW_APPROVED, UgcFilter.Comparison.EQUALS);
                    continue;
                }
                if (VIEW_DENIED.equals(views[i])) {
                    filter.filterOrByProperty(STATE_CONSTRAINT_GROUP, VIEW_DENIED, UgcFilter.Comparison.EQUALS);
                    continue;
                }
                if (!VIEW_PENDING.equals(views[i])) continue;
                filter.filterOrByProperty(STATE_CONSTRAINT_GROUP, VIEW_PENDING, UgcFilter.Comparison.EQUALS);
            }
        }
        if (notViews != null && notViews.length == 1 && (flagged == null || Boolean.getBoolean(flagged))) {
            if (VIEW_SPAM.equals(notViews[0])) {
                filter.filterOrByProperty(STATE_CONSTRAINT_GROUP, VIEW_SPAM, UgcFilter.Comparison.NOT_EQUALS);
            } else if (VIEW_NOT_SPAM.equals(notViews[0])) {
                filter.filterOrByProperty(STATE_CONSTRAINT_GROUP, VIEW_SPAM, UgcFilter.Comparison.EQUALS);
            } else if (VIEW_APPROVED.equals(notViews[0])) {
                filter.filterOrByProperty(STATE_CONSTRAINT_GROUP, VIEW_APPROVED, UgcFilter.Comparison.NOT_EQUALS);
            } else if (VIEW_DENIED.equals(notViews[0])) {
                filter.filterOrByProperty(STATE_CONSTRAINT_GROUP, VIEW_DENIED, UgcFilter.Comparison.NOT_EQUALS);
            } else if (VIEW_PENDING.equals(notViews[0])) {
                filter.filterOrByProperty(STATE_CONSTRAINT_GROUP, VIEW_PENDING, UgcFilter.Comparison.NOT_EQUALS);
            }
        }
        if (flagged != null && (Boolean.getBoolean(flagged) || notViews == null || notViews.length == 0)) {
            filter.filterOrByConstraintGroup(STATE_CONSTRAINT_GROUP, FLAGGED, flagged, UgcFilter.Comparison.EQUALS);
        }
        for (i = 0; i < (addedBy == null ? 0 : addedBy.length); ++i) {
            if (addedBy[i].isEmpty()) continue;
            filter.filterOrByProperty("userIdentifier", addedBy[i], UgcFilter.Comparison.EQUALS);
        }
        for (i = 0; i < (notAddedBy == null ? 0 : notAddedBy.length); ++i) {
            if (notAddedBy[i].isEmpty()) continue;
            filter.filterOrByProperty("userIdentifier", notAddedBy[i], UgcFilter.Comparison.NOT_EQUALS);
        }
        for (i = 0; i < (resourceTypes == null ? 0 : resourceTypes.length); ++i) {
            filter.filterOrByProperty("resourceType", resourceTypes[i], UgcFilter.Comparison.EQUALS);
        }
        for (i = 0; i < (notResourceTypes == null ? 0 : notResourceTypes.length); ++i) {
            filter.filterOrByProperty("resourceType", notResourceTypes[i], UgcFilter.Comparison.NOT_EQUALS);
        }
        if (paths != null && paths.length > 0) {
            for (i = 0; i < paths.length; ++i) {
                filter.filterByPath(paths[i]);
            }
        } else {
            filter.filterByPath(request.getResource().getPath());
        }
        if (mindate != null) {
            Date md = new Date(Long.parseLong(mindate));
            filter.filterAndByProperty(DEFAULT_SORT, UgcIndexerUtil.dateToString((Date)md), UgcFilter.Comparison.GREATER_THAN_EQUAL_TO);
        }
        if (maxdate != null) {
            Date md = new Date(Long.parseLong(maxdate));
            filter.filterAndByProperty(DEFAULT_SORT, UgcIndexerUtil.dateToString((Date)md), UgcFilter.Comparison.LESS_THAN_EQUAL_TO);
        }
        if (answered != null) {
            filter.filterOrByConstraintGroup(FEATURES_CONSTRAINT_GROUP, ANSWERED, answered, UgcFilter.Comparison.EQUALS);
        }
        if (chosenAnswer != null) {
            filter.filterOrByConstraintGroup(FEATURES_CONSTRAINT_GROUP, CHOSEN_ANSWER, chosenAnswer, UgcFilter.Comparison.EQUALS);
        }
        if (attachments != null) {
            filter.filterOrByConstraintGroup(FEATURES_CONSTRAINT_GROUP, ATTACHMENTS, attachments, UgcFilter.Comparison.EQUALS);
        }
        if (replied != null) {
            boolean b = Boolean.parseBoolean(replied);
            if (b) {
                filter.filterOrByConstraintGroup(FEATURES_CONSTRAINT_GROUP, REPLIES, "0", UgcFilter.Comparison.GREATER_THAN);
            } else {
                filter.filterOrByConstraintGroup(FEATURES_CONSTRAINT_GROUP, REPLIES, "0", UgcFilter.Comparison.EQUALS);
            }
        }
        if (read != null) {
            filter.filterOrByProperty(READ, read, UgcFilter.Comparison.EQUALS);
        }
        if (influencegte != null) {
            filter.filterAndByProperty(INFLUENCE, influencegte, UgcFilter.Comparison.GREATER_THAN_EQUAL_TO);
        }
        if (influencelte != null) {
            filter.filterAndByProperty(INFLUENCE, influencelte, UgcFilter.Comparison.LESS_THAN_EQUAL_TO);
        }
        if (sentimentgte != null) {
            filter.filterAndByProperty(SENTIMENT, sentimentgte, UgcFilter.Comparison.GREATER_THAN_EQUAL_TO);
        }
        if (sentimentlte != null) {
            filter.filterAndByProperty(SENTIMENT, sentimentlte, UgcFilter.Comparison.LESS_THAN_EQUAL_TO);
        }
        return filter;
    }

    protected SearchResults<AbstractListServlet.ListItem> searchItems(SlingHttpServletRequest request, Predicate predicate) throws Exception {
        Resource resource = request.getResource();
        ResourceResolver resolver = resource.getResourceResolver();
        this.pageManager = this.pageManagerFactory.getPageManager(resolver);
        String offsetString = request.getParameter(START);
        String limitString = request.getParameter(LIMIT);
        int offset = 0;
        int limit = 30;
        if (null != limitString) {
            try {
                limit = Integer.parseInt(limitString);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        if (null != offsetString) {
            try {
                offset = Integer.parseInt(offsetString);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        ArrayList<CommentListItem> items = new ArrayList<CommentListItem>();
        long numResults = 0L;
        String query = request.getParameter(QUERY);
        if (null != query) {
            List mltNodes = this.relatedSearch.findMLT("ugc-sc", query, null, null, new String[]{"jcr:description", "jcr:title", "userIdentifier"}, limit, 0, 0);
            for (String node : mltNodes) {
                Resource commentRes = resolver.getResource(node);
                if (commentRes == null) continue;
                CommentListItem item = new CommentListItem(offset, (Comment)commentRes.adaptTo(Comment.class));
                items.add(item);
            }
            numResults = mltNodes.size();
        } else {
            UgcFilter filter = this.getUgcFilter(request);
            SearchResults<Comment> comments = this.getComments((Session)request.getResourceResolver().adaptTo(Session.class), null, resolver, resource, filter, offset, limit);
            for (Comment comment : comments.getResults()) {
                CommentListItem item = new CommentListItem(offset, comment);
                items.add(item);
                ++offset;
            }
            numResults = comments.getTotalNumberOfResults();
        }
        return new ListSearchResults<AbstractListServlet.ListItem>(items, numResults);
    }

    private SearchResults<Comment> getComments(Session session, List<Comment> comments, ResourceResolver resolver, Resource resource, UgcFilter filter, int offset, int limit) throws Exception {
        if (null == comments) {
            comments = new ArrayList<Comment>();
        }
        SearchResults results = this.ugcSearch.find("ugc-sc", session, filter, offset, limit);
        List nodes = results.getResults();
        for (Node node : nodes) {
            Resource resultResource = resolver.getResource(node.getPath());
            Comment comment = (Comment)resultResource.adaptTo(Comment.class);
            if (null == comment) continue;
            comments.add(comment);
        }
        return new ListSearchResults<Comment>(comments, results.getTotalNumberOfResults());
    }

    static {
        SORT_PARAM_PROPERTY_MAP.put(null, DEFAULT_SORT);
        SORT_PARAM_PROPERTY_MAP.put("title_xss", "parent".intern());
        SORT_PARAM_PROPERTY_MAP.put("content_xss", "jcr:description");
        SORT_PARAM_PROPERTY_MAP.put(ADDED_BY, "userIdentifier");
        SORT_PARAM_PROPERTY_MAP.put(DEFAULT_SORT, DEFAULT_SORT);
        SORT_PARAM_PROPERTY_MAP.put("type", "resourceType");
        SORT_PARAM_PROPERTY_MAP.put("status", STATE_CONSTRAINT_GROUP.intern());
    }

    protected void bindModerationExtension(ModerationExtension moderationExtension) {
        this.moderationExtension = moderationExtension;
    }

    protected void unbindModerationExtension(ModerationExtension moderationExtension) {
        if (this.moderationExtension == moderationExtension) {
            this.moderationExtension = null;
        }
    }

    protected void bindUgcSearch(UgcSearch ugcSearch) {
        this.ugcSearch = ugcSearch;
    }

    protected void unbindUgcSearch(UgcSearch ugcSearch) {
        if (this.ugcSearch == ugcSearch) {
            this.ugcSearch = null;
        }
    }

    protected void bindRelatedSearch(RelatedSearch relatedSearch) {
        this.relatedSearch = relatedSearch;
    }

    protected void unbindRelatedSearch(RelatedSearch relatedSearch) {
        if (this.relatedSearch == relatedSearch) {
            this.relatedSearch = null;
        }
    }

    protected void bindProfileMgr(ProfileManager profileManager) {
        this.profileMgr = profileManager;
    }

    protected void unbindProfileMgr(ProfileManager profileManager) {
        if (this.profileMgr == profileManager) {
            this.profileMgr = null;
        }
    }

    protected void bindPageManagerFactory(PageManagerFactory pageManagerFactory) {
        this.pageManagerFactory = pageManagerFactory;
    }

    protected void unbindPageManagerFactory(PageManagerFactory pageManagerFactory) {
        if (this.pageManagerFactory == pageManagerFactory) {
            this.pageManagerFactory = null;
        }
    }

    protected void bindXssAPI(XSSAPI xSSAPI) {
        this.xssAPI = xSSAPI;
    }

    protected void unbindXssAPI(XSSAPI xSSAPI) {
        if (this.xssAPI == xSSAPI) {
            this.xssAPI = null;
        }
    }

    public class CommentListItem
    implements AbstractListServlet.ListItem {
        public static final String CONTEXT_URL = "contextUrl";
        public static final String COMMENT_ID = "commentId";
        public static final String CONTENT = "content";
        public static final String ADDED = "added";
        public static final String MODIFIED = "modified";
        public static final String ADDED_BY = "addedBy";
        public static final String WEBSITE = "website";
        public static final String STATUS = "status";
        public static final String MODERATED = "moderated";
        public static final String LEVEL = "level";
        public static final String ORPHAN = "orphan";
        public static final String AVATAR = "avatar";
        public static final String TYPE_TITLE = "typeTitle";
        public static final String ADDED_BY_PATH = "addedByPath";
        public static final String ADDED_BY_DISPLAY_NAME = "addedByDisplayName";
        public static final String MODERATION_HISTORY = "moderationHistory";
        public static final int STATUS_SPAM = 3;
        public static final int STATUS_DENIED = 2;
        public static final int STATUS_PENDING = 1;
        public static final int STATUS_OK = 0;
        public int index;
        public String path;
        public String label;
        public String type;
        public String typeTitle;
        public String title;
        public String description;
        public String ip;
        public String contextUrl;
        public String content;
        public long added;
        public long modified;
        public String addedBy;
        public String website;
        public int status;
        public boolean moderated;
        public boolean orphan;
        public String avatarPath;
        public String addedByPath;
        public String addedByDisplayName;
        public Value[] moderationHistory;
        private final Comment comment;
        private Resource resource;
        private Page page;
        private String commentId;
        private int level;

        public CommentListItem(int i, Comment c) throws Exception {
            this.index = i;
            this.comment = c;
            this.init();
        }

        private void init() throws Exception {
            Node resourceTypeNode;
            Resource resourceType;
            this.resource = this.comment.getResource();
            Node node = (Node)this.resource.adaptTo(Node.class);
            this.path = this.resource.getPath();
            this.label = Text.getName((String)this.path);
            this.type = this.resource.getResourceType();
            if (this.type != null && (resourceType = this.resource.getResourceResolver().getResource(this.type)) != null && (resourceTypeNode = (Node)resourceType.adaptTo(Node.class)) != null && resourceTypeNode.hasProperty("jcr:title")) {
                this.typeTitle = resourceTypeNode.getProperty("jcr:title").getString();
            }
            if (this.resource.getResourceSuperType() != null) {
                this.type = this.type + "," + this.resource.getResourceSuperType();
            }
            if (!this.resource.getResourceType().equals(node.getPrimaryNodeType().getName())) {
                this.type = this.type + "," + node.getPrimaryNodeType().getName();
            }
            this.level = this.getLevel((Node)this.resource.adaptTo(Node.class), this.level);
            this.path = this.comment.getPath();
            String contextPath = this.comment.getCommentSystem().getPath();
            this.commentId = this.comment.getId();
            this.page = null;
            if (ScCommentListServlet.this.pageManager != null) {
                this.page = ScCommentListServlet.this.pageManager.getPage(contextPath);
            }
            this.orphan = this.page == null;
            this.ip = this.comment.getProperty("ip", "");
            this.contextUrl = ScCommentListServlet.this.moderationExtension != null ? ScCommentListServlet.this.moderationExtension.getContextURL(this.comment) : this.comment.getUrl();
            if (!this.orphan) {
                this.title = this.page.getTitle();
                this.description = this.page.getDescription();
            } else {
                this.title = Text.getName((String)contextPath);
            }
            this.added = this.comment.getDate().getTime();
            if (node.hasProperty("cq:lastModified")) {
                Calendar mod = node.getProperty("cq:lastModified").getDate();
                this.modified = mod.getTimeInMillis();
            } else {
                this.modified = this.added;
            }
            this.addedBy = this.comment.getAuthor().getName();
            this.website = this.comment.getAuthor().getWebsite(null);
            this.content = this.comment.getMessage();
            this.status = this.comment.isSpam() ? 3 : (this.comment.isDenied() ? 2 : (this.comment.isPending() ? 1 : 0));
            this.moderated = this.comment.getCommentSystem().isModerated();
            String authorId = this.comment.getAuthor().getId();
            if (authorId != null && authorId.length() > 0) {
                Profile profile = CollabUtil.getProfile(this.resource.getResourceResolver(), ScCommentListServlet.this.profileMgr, authorId);
                if (profile != null) {
                    this.avatarPath = CollabUtil.getAvatar(profile, null, null, CollabUtil.AVATAR_SIZE.FOURTY_EIGHT);
                    this.addedByPath = profile.getPath();
                    this.addedByDisplayName = profile.getName();
                } else {
                    this.avatarPath = "/etc/designs/default/images/social/avatar.png";
                    this.addedByDisplayName = this.addedBy;
                }
            }
            if (node.hasProperty(MODERATION_HISTORY)) {
                this.moderationHistory = node.getProperty(MODERATION_HISTORY).getValues();
            }
        }

        private int getLevel(Node node, int level) {
            try {
                Node parent = node.getParent();
                if (parent.isNodeType("cq:Comment")) {
                    return this.getLevel(parent, ++level);
                }
                return level;
            }
            catch (Exception e) {
                return level;
            }
        }

        public Resource getResource() {
            return this.resource;
        }

        public void write(JSONWriter out, String[] customProps) throws Exception {
            out.setTidy(true);
            out.object();
            ScCommentListServlet.this.writeKey(out, "index", this.index);
            ScCommentListServlet.this.writeKey(out, ScCommentListServlet.PATH, this.path);
            ScCommentListServlet.this.writeKey(out, "label", this.label);
            ScCommentListServlet.this.writeKey(out, "title", ScCommentListServlet.this.xssAPI.filterHTML(this.title));
            ScCommentListServlet.this.writeKey(out, LEVEL, this.level);
            ScCommentListServlet.this.writeKey(out, ORPHAN, this.orphan);
            ScCommentListServlet.this.writeOptionalKey(out, "type", this.type);
            ScCommentListServlet.this.writeOptionalKey(out, TYPE_TITLE, this.typeTitle);
            ScCommentListServlet.this.writeKey(out, "description", ScCommentListServlet.this.xssAPI.filterHTML(this.description));
            ScCommentListServlet.this.writeKey(out, "ip", this.ip);
            ScCommentListServlet.this.writeKey(out, CONTEXT_URL, this.contextUrl);
            ScCommentListServlet.this.writeKey(out, COMMENT_ID, this.commentId);
            ScCommentListServlet.this.writeKey(out, CONTENT, ScCommentListServlet.this.xssAPI.filterHTML(this.content));
            ScCommentListServlet.this.writeKey(out, "added", this.added);
            ScCommentListServlet.this.writeKey(out, MODIFIED, this.modified);
            if (this.avatarPath != null) {
                ScCommentListServlet.this.writeKey(out, AVATAR, this.avatarPath);
            }
            if (this.addedByPath != null) {
                ScCommentListServlet.this.writeKey(out, ADDED_BY_PATH, this.addedByPath);
            }
            if (this.addedByDisplayName != null) {
                ScCommentListServlet.this.writeKey(out, ADDED_BY_DISPLAY_NAME, this.addedByDisplayName);
            }
            if (this.moderationHistory != null) {
                JSONArray jsonArray = new JSONArray();
                for (int i = 0; i < this.moderationHistory.length; ++i) {
                    jsonArray.put((Object)this.moderationHistory[i].getString());
                }
                ScCommentListServlet.this.writeKey(out, MODERATION_HISTORY, jsonArray);
            }
            ScCommentListServlet.this.writeKey(out, "addedBy", this.addedBy);
            ScCommentListServlet.this.writeKey(out, WEBSITE, this.website);
            ScCommentListServlet.this.writeKey(out, STATUS, this.status);
            ScCommentListServlet.this.writeKey(out, MODERATED, this.moderated);
            ScCommentListServlet.this.writeCustomProperties(out, this.resource, customProps);
            this.resource = this.comment.getResource();
            Node node = (Node)this.resource.adaptTo(Node.class);
            if (ScCommentListServlet.this.moderationExtension != null) {
                List<UgcIndexProperty> indexProps = ScCommentListServlet.this.moderationExtension.getAllUgcIndexProperties(this.resource.getResourceResolver(), node);
                boolean hasAttachment = node.hasNode(ScCommentListServlet.ATTACHMENTS);
                for (UgcIndexProperty indexProp : indexProps) {
                    Node attachmentsFolder;
                    Object val;
                    if ("added".equals(indexProp.getName()) || (val = indexProp.getValue()) == null) continue;
                    ScCommentListServlet.this.writeKey(out, indexProp.getName(), ScCommentListServlet.this.xssAPI.filterHTML(val.toString()));
                    if (!hasAttachment || !ScCommentListServlet.ATTACHMENTS.endsWith(indexProp.getName()) || (attachmentsFolder = node.getNode(ScCommentListServlet.ATTACHMENTS)) == null) continue;
                    NodeIterator nodeIter = attachmentsFolder.getNodes();
                    JSONArray jsonArray = new JSONArray();
                    while (nodeIter.hasNext()) {
                        Node attachment = (Node)nodeIter.next();
                        jsonArray.put((Object)("attachments/" + attachment.getName()));
                    }
                    ScCommentListServlet.this.writeKey(out, ScCommentListServlet.ATTACHMENT_PATHS, jsonArray);
                }
            }
            out.endObject();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ListSearchResults<T>
    implements SearchResults<T> {
        private final long totalNumberOfResults;
        private final List<T> results;

        public ListSearchResults(List<T> results, long totalNumberOfResults) {
            this.results = results;
            this.totalNumberOfResults = totalNumberOfResults;
        }

        public long getTotalNumberOfResults() {
            return this.totalNumberOfResults;
        }

        public List<T> getResults() {
            return this.results;
        }
    }
}

