/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.commons.ugc.impl.servlets;

import com.adobe.cq.social.commons.Comment;
import com.adobe.cq.social.ugc.api.RelatedSearch;
import com.day.cq.commons.TidyJSONWriter;
import com.day.cq.commons.servlets.AbstractSearchServlet;
import com.day.cq.wcm.api.Page;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;
import javax.servlet.ServletException;
import org.apache.commons.collections.Predicate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

@Component(metatype=false)
@Service
@Properties(value={@Property(name="sling.servlet.resourceTypes", value={"sling/servlet/default"}), @Property(name="sling.servlet.selectors", value={"ugcsearchsc"}), @Property(name="sling.servlet.extensions", value={"json"}), @Property(name="sling.servlet.methods", value={"GET"})})
public class ScCommentSearchServlet
extends AbstractSearchServlet {
    private static final long serialVersionUID = -5680571968898669215L;
    @Reference
    private RelatedSearch relatedSearch;
    private static final int MAX_RESULTS = 30;

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response, Predicate predicate) throws ServletException, IOException {
        if ("json".equals(request.getRequestPathInfo().getExtension())) {
            response.setContentType("application/json");
            response.setCharacterEncoding("utf-8");
            String queryString = request.getParameter("query");
            if (queryString == null) {
                return;
            }
            try {
                List mltNodes = this.relatedSearch.findMLT("ugc-sc", queryString, null, null, new String[]{"jcr:description", "jcr:title", "userIdentifier"}, 30, 0, 0);
                ResourceResolver resolver = request.getResource().getResourceResolver();
                PrintWriter out = response.getWriter();
                TidyJSONWriter writer = new TidyJSONWriter((Writer)out);
                writer.setTidy("true".equals(request.getParameter("tidy")));
                writer.object();
                writer.key("hits");
                writer.array();
                for (String node : mltNodes) {
                    Resource commentRes = resolver.getResource(node);
                    if (commentRes == null) continue;
                    Comment comment = (Comment)commentRes.adaptTo(Comment.class);
                    String path = comment.getCommentSystem().getPath();
                    String fullPath = comment.getPath();
                    String title = this.getTitle(comment, resolver);
                    String excerpt = this.getExcerpt(comment.getMessage(), 150);
                    writer.object();
                    writer.key("path").value((Object)fullPath);
                    writer.key("name").value((Object)path);
                    writer.key("excerpt").value((Object)excerpt);
                    writer.key("title").value((Object)title);
                    writer.endObject();
                }
                writer.endArray();
                writer.key("results").value((long)mltNodes.size());
                writer.endObject();
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
        }
    }

    private String getTitle(Comment comment, ResourceResolver resolver) {
        Page page;
        String title = comment.getProperty("jcr:title", null);
        if (title == null && (page = (Page)resolver.getResource(comment.getCommentSystem().getPath()).adaptTo(Page.class)) != null) {
            return page.getTitle();
        }
        return title;
    }

    private String getExcerpt(String msg, int maxLength) {
        if (msg.length() > maxLength + 3) {
            msg = msg.substring(0, maxLength) + "...";
        }
        return msg;
    }

    protected void bindRelatedSearch(RelatedSearch relatedSearch) {
        this.relatedSearch = relatedSearch;
    }

    protected void unbindRelatedSearch(RelatedSearch relatedSearch) {
        if (this.relatedSearch == relatedSearch) {
            this.relatedSearch = null;
        }
    }
}

