/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.group.api;

import com.adobe.granite.security.user.UserProperties;
import com.adobe.granite.security.user.UserPropertiesManager;
import com.adobe.granite.security.user.UserPropertiesService;
import com.adobe.granite.socialgraph.Direction;
import com.adobe.granite.socialgraph.GraphNode;
import com.adobe.granite.socialgraph.Relationship;
import com.adobe.granite.socialgraph.SocialGraph;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupUtil {
    private static final Logger log = LoggerFactory.getLogger(GroupUtil.class);

    public static boolean validateGroupName(ResourceResolver resolver, String name, String groupRoot) {
        if (name.startsWith("_")) {
            log.info("Group name {} begins with invalid charactor", (Object)name);
            return false;
        }
        PageManager pm = (PageManager)resolver.adaptTo(PageManager.class);
        Page childPage = pm.getPage(groupRoot + "/" + name);
        if (childPage != null) {
            log.info("Page {} already exists in {}", (Object)name, (Object)groupRoot);
            return false;
        }
        SocialGraph socialGraph = (SocialGraph)resolver.adaptTo(SocialGraph.class);
        GraphNode authorizable = socialGraph.getNode(name + "-admins");
        if (authorizable != null) {
            log.info("Authorizable {} already exists", (Object)(name + "-admins"));
            return false;
        }
        authorizable = socialGraph.getNode(name + "-members");
        if (authorizable != null) {
            log.info("Authorizable {} already exists", (Object)(name + "-members"));
            return false;
        }
        return true;
    }

    public static int getNumberOfMembers(UserPropertiesService userPropertiesService, ResourceResolver resourceResolver, String groupId) {
        List<UserProperties> relations = GroupUtil.establishMemberRelation(userPropertiesService, resourceResolver, groupId);
        if (relations != null) {
            return relations.size();
        }
        return 0;
    }

    public static Iterator<UserProperties> getMembers(UserPropertiesService userPropertiesService, ResourceResolver resourceResolver, String groupId) {
        List<UserProperties> relations = GroupUtil.establishMemberRelation(userPropertiesService, resourceResolver, groupId);
        if (relations != null) {
            return relations.iterator();
        }
        return null;
    }

    public static boolean isMember(UserPropertiesService userPropertiesService, ResourceResolver resourceResolver, String authId, String groupId) {
        if (StringUtils.isEmpty((String)authId) || StringUtils.isEmpty((String)groupId)) {
            return false;
        }
        List<UserProperties> relations = GroupUtil.establishMemberRelation(userPropertiesService, resourceResolver, groupId);
        if (relations != null) {
            for (UserProperties r : relations) {
                if (!r.getAuthorizableID().equals(authId)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private static List<UserProperties> establishMemberRelation(UserPropertiesService userPropertiesService, ResourceResolver resourceResolver, String groupId) {
        ArrayList<UserProperties> results = new ArrayList<UserProperties>();
        if (StringUtils.isEmpty((String)groupId)) {
            return results;
        }
        try {
            UserPropertiesManager upm = userPropertiesService.createUserPropertiesManager(resourceResolver);
            SocialGraph socialGraph = (SocialGraph)resourceResolver.adaptTo(SocialGraph.class);
            GraphNode group = socialGraph.getNode(groupId);
            if (group == null) {
                return results;
            }
            String relation = "member";
            Direction direction = Direction.INCOMING;
            for (Relationship r : group.getRelationships(direction, new String[]{"member"})) {
                String authId = r.getOtherNode(group).getId();
                UserProperties memberProperties = upm.getUserProperties(authId, "profile");
                if (memberProperties == null || memberProperties.getNode().getPath().contains("groups")) continue;
                results.add(memberProperties);
            }
        }
        catch (RepositoryException e) {
            log.error("establishMemberRelation: error while establish relation for [{}]", (Object)groupId);
            log.error("", (Throwable)e);
        }
        return results;
    }

    public static String getCommunityRootPagePath(ResourceResolver resolver, String targetPath) {
        String parentPath = ResourceUtil.getParent((String)targetPath);
        Resource parentResource = resolver.getResource(parentPath);
        String communityRootPagePath = null;
        Resource parentPage = resolver.resolve(parentResource.getPath() + "/" + "jcr:content");
        if (parentPage != null && !ResourceUtil.isNonExistingResource((Resource)parentPage)) {
            Node parentNode = (Node)parentPage.adaptTo(Node.class);
            try {
                if (parentNode.hasProperty("membergroup")) {
                    communityRootPagePath = parentResource.getPath();
                    return communityRootPagePath;
                }
                if (parentResource.getParent() == null) {
                    return communityRootPagePath;
                }
                communityRootPagePath = GroupUtil.getCommunityRootPagePath(resolver, parentResource.getPath());
            }
            catch (RepositoryException e) {
                log.error("GroupUtil getParent() failed", (Throwable)e);
            }
        } else if (parentResource.getParent() != null) {
            communityRootPagePath = GroupUtil.getCommunityRootPagePath(resolver, parentResource.getPath());
        } else {
            return communityRootPagePath;
        }
        return communityRootPagePath;
    }
}

