/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.group.impl;

import com.adobe.cq.social.group.api.GroupException;
import com.adobe.cq.social.group.api.GroupMSMService;
import com.adobe.cq.social.group.api.GroupUtil;
import com.day.cq.commons.jcr.JcrUtil;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.WCMException;
import com.day.cq.wcm.msm.api.LiveRelationship;
import com.day.cq.wcm.msm.api.LiveRelationshipManager;
import com.day.cq.wcm.msm.api.RolloutConfig;
import com.day.cq.wcm.msm.api.RolloutConfigManager;
import com.day.cq.wcm.msm.api.RolloutManager;
import com.day.text.Text;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.detect.Detector;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(metatype=false, label="GroupMSMService", description="to create a copy of social group (MSM)")
@Service
@Property(name="service.description", value={"GroupMSMService to create a live copy based on the social group blueprint"})
public class GroupMSMServiceImpl
implements GroupMSMService {
    private static final Logger log = LoggerFactory.getLogger(GroupMSMServiceImpl.class);
    @Reference
    RolloutManager rolloutManager = null;
    @Reference
    LiveRelationshipManager relationshipManager = null;

    @Override
    public Page createLiveCopy(SlingRepository repository, ResourceResolver resolver, RolloutManager rolloutMgr, String liveCopyName, String liveCopyTitle, String bluePrintPath, String liveCopyPath, ValueMap properties) throws GroupException, RepositoryException, WCMException {
        if (!GroupUtil.validateGroupName(resolver, liveCopyName, liveCopyPath)) {
            throw new GroupException("Social Community Group name " + liveCopyName + " already in use.");
        }
        if (Text.isDescendantOrEqual((String)bluePrintPath, (String)liveCopyPath)) {
            throw new GroupException("Destination path cannot contain source path.");
        }
        PageManager pageManager = (PageManager)resolver.adaptTo(PageManager.class);
        this.relationshipManager = (LiveRelationshipManager)resolver.adaptTo(LiveRelationshipManager.class);
        if (rolloutMgr == null) {
            return null;
        }
        this.rolloutManager = rolloutMgr;
        String languagePath = (String)properties.get((Object)"msmMasterPages");
        if (languagePath != null) {
            bluePrintPath = languagePath;
        }
        Page master = pageManager.getPage(bluePrintPath);
        Object prop = properties.get((Object)"msmChapterPages");
        String[] chapters = null;
        if (prop instanceof String) {
            chapters = StringUtils.split((String)prop.toString(), (char)',');
        } else if (prop instanceof String[]) {
            chapters = (String[])prop;
        }
        boolean rolloutAllChapters = chapters != null && chapters.length == 1 && chapters[0].equals("all");
        Page lcPage = this.createLiveCopy(master, liveCopyPath, resolver, rolloutAllChapters, liveCopyName, liveCopyTitle, new String[0]);
        Node node = (Node)lcPage.getContentResource().adaptTo(Node.class);
        for (String key : properties.keySet()) {
            if (this.isInternalProperty(key) || !"jcr:description".equals(key) && !JcrUtil.isValidName((String)key)) continue;
            Object value = properties.get((Object)key);
            if (null != value) {
                try {
                    JcrUtil.setProperty((Node)node, (String)key, (Object)value);
                }
                catch (RepositoryException e) {
                    log.debug("failed to set property [{}].", (Object)key);
                }
                continue;
            }
            log.debug("skipped custom form field [{}], empty or binary not allowed.", (Object)key);
        }
        JcrUtil.setProperty((Node)node, (String)"pageTitle", (Object)properties.get((Object)"liveCopyTitle"));
        Resource image = resolver.getResource(properties.get((Object)"formPayload") + "/" + "image");
        if (image != null) {
            Node imageNode = (Node)image.adaptTo(Node.class);
            String mimeType = this.getResourceMIMEType(image);
            if (StringUtils.startsWithIgnoreCase((String)mimeType, (String)"image")) {
                Node imageCopy = JcrUtil.createPath((String)(liveCopyPath + "/" + liveCopyName + "/" + "photos"), (String)"sling:Folder", (Session)((Session)resolver.adaptTo(Session.class)));
                JcrUtil.copy((Node)imageNode, (Node)imageCopy, (String)"image");
            } else {
                log.error("upload invalid image type {}", (Object)mimeType);
            }
        } else {
            log.error("no image uploaded");
        }
        String destPath = lcPage.getPath();
        if (chapters != null && !rolloutAllChapters) {
            for (String chapter : chapters) {
                String relPath = Text.getName((String)chapter);
                String chapSrc = chapter;
                String chapDst = destPath + "/" + relPath;
                Page chapPage = pageManager.getPage(chapSrc);
                if (chapPage != null) {
                    log.info("rollout chapter {} -> {}", (Object)chapSrc, (Object)chapDst);
                    this.createLiveCopy(chapPage, destPath, resolver, true, null, null, new String[0]);
                    continue;
                }
                log.info("chapter does not exist in this language {}", (Object)chapSrc);
            }
        }
        return lcPage;
    }

    protected Page createLiveCopy(Page master, String dstPath, ResourceResolver resolver, boolean deep, String pageName, String pageTitle, String ... rolloutConfigs) throws RepositoryException, WCMException {
        Page lcPage = this.createCopyTarget(master, dstPath, pageName, pageTitle);
        LiveRelationship ship = this.establishRelationship(master, lcPage, deep, resolver, rolloutConfigs);
        this.rollout(master, lcPage, ship, deep, resolver);
        return lcPage;
    }

    protected Page createCopyTarget(Page master, String dstPath, String pageName, String pageTitle) throws WCMException, RepositoryException {
        if (StringUtils.isEmpty((String)pageName)) {
            pageName = master.getName();
        }
        if (StringUtils.isEmpty((String)pageTitle)) {
            pageTitle = pageName;
        }
        String before = null;
        String destination = dstPath + "/" + pageName;
        Page lcPage = master.getPageManager().copy(master, destination, before, true, true, false);
        Resource newLiveCopyResource = lcPage.getContentResource();
        Node contentNode = (Node)newLiveCopyResource.adaptTo(Node.class);
        if (!contentNode.canAddMixin("cq:LiveRelationship")) {
            contentNode.getSession().refresh(false);
            throw new WCMException(String.format("Can't establish LiveRelationship from %s to %s: Node does not allow to set mixin of %s", master.getPath(), lcPage.getPath(), "cq:LiveRelationship"));
        }
        if (!StringUtils.isEmpty((String)pageTitle)) {
            contentNode.setProperty("jcr:title", pageTitle);
            log.debug("Set Page Title {} to new Live Copy at {}", (Object)pageTitle, (Object)newLiveCopyResource.getPath());
        }
        if (this.relationshipManager.hasLiveRelationship(master.getContentResource())) {
            this.relationshipManager.endRelationship(newLiveCopyResource, false);
            log.debug("Create a LiveCopy at {} from a LiveCopy at {}", (Object)master.getPath(), (Object)lcPage.getPath());
        }
        log.debug("Created Live Copy Resource at {}", (Object)lcPage.getPath());
        return lcPage;
    }

    protected void rollout(Page master, Page liveCopy, LiveRelationship ship, boolean deep, ResourceResolver resolver) throws WCMException {
        this.rolloutManager.rollout(resolver, ship, false);
        if (!deep) {
            log.debug("Live Copy at {} set to be shallow", (Object)liveCopy.getPath());
        } else {
            this.rolloutChildren(master.listChildren(), resolver, liveCopy.getPath());
        }
    }

    private void rolloutChildren(Iterator<Page> children, ResourceResolver resolver, String ... target) throws WCMException {
        while (children.hasNext()) {
            Page child = children.next();
            Iterator itr = this.relationshipManager.getLiveRelationships(child, null, target, true).iterator();
            if (!itr.hasNext()) {
                throw new WCMException("Failed to access relation for child at " + child.getPath());
            }
            this.rolloutManager.rollout(resolver, (LiveRelationship)itr.next(), false);
            this.rolloutChildren(child.listChildren(), resolver, target);
        }
    }

    protected LiveRelationship establishRelationship(Page master, Page liveCopy, boolean deep, ResourceResolver resolver, String ... rolloutConfigs) throws WCMException {
        RolloutConfig[] configs;
        if (this.isEmpty(rolloutConfigs)) {
            rolloutConfigs = new String[]{"/etc/msm/rolloutconfigs/default"};
        }
        if (rolloutConfigs != null) {
            RolloutConfigManager rolloutConfigManager = (RolloutConfigManager)resolver.adaptTo(RolloutConfigManager.class);
            ArrayList<RolloutConfig> tmp = new ArrayList<RolloutConfig>();
            for (String path : rolloutConfigs) {
                RolloutConfig rc = rolloutConfigManager.getRolloutConfig(path);
                if (rc == null) continue;
                tmp.add(rc);
            }
            configs = tmp.toArray(new RolloutConfig[tmp.size()]);
        } else {
            configs = null;
        }
        return this.relationshipManager.establishRelationship(master, liveCopy, deep, true, configs);
    }

    boolean isEmpty(String[] values) {
        if (values != null) {
            for (String value : values) {
                if (StringUtils.isEmpty((String)value)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isInternalProperty(String key) {
        return key.equals("userGroupPath") || key.equals("uid") || key.equals("socialGroupName") || key.equals("liveCopyTitle") || key.equals("liveCopyPath") || key.equals("bluePrintPath") || key.equals("msmMasterPages") || key.equals("msmChapterPages") || key.equals("msmRolloutConfigs");
    }

    private String getResourceMIMEType(Resource res) throws RepositoryException {
        Node node = (Node)res.adaptTo(Node.class);
        Node ntResourceNode = node.getNode("jcr:content");
        try {
            Binary bin = ntResourceNode.getProperty("jcr:data").getBinary();
            TikaConfig config = TikaConfig.getDefaultConfig();
            Detector detector = config.getDetector();
            TikaInputStream stream = TikaInputStream.get((InputStream)bin.getStream());
            Metadata metadata = new Metadata();
            metadata.add("resourceName", "image");
            MediaType mediaType = detector.detect((InputStream)stream, metadata);
            return mediaType.getType();
        }
        catch (PathNotFoundException el) {
            return null;
        }
        catch (IOException e) {
            return ntResourceNode.getProperty("jcr:mimeType").getString();
        }
    }

    protected void bindRolloutManager(RolloutManager rolloutManager) {
        this.rolloutManager = rolloutManager;
    }

    protected void unbindRolloutManager(RolloutManager rolloutManager) {
        if (this.rolloutManager == rolloutManager) {
            this.rolloutManager = null;
        }
    }

    protected void bindRelationshipManager(LiveRelationshipManager liveRelationshipManager) {
        this.relationshipManager = liveRelationshipManager;
    }

    protected void unbindRelationshipManager(LiveRelationshipManager liveRelationshipManager) {
        if (this.relationshipManager == liveRelationshipManager) {
            this.relationshipManager = null;
        }
    }
}

