/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.group.impl;

import com.adobe.cq.social.commons.CollabUtil;
import com.adobe.cq.social.group.api.GroupException;
import com.adobe.cq.social.group.api.GroupService;
import com.day.cq.commons.Filter;
import com.day.cq.replication.ReplicationActionType;
import com.day.cq.replication.ReplicationException;
import com.day.cq.replication.Replicator;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageFilter;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowService;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.Workflow;
import com.day.cq.workflow.exec.WorkflowData;
import com.day.cq.workflow.model.WorkflowModel;
import java.security.AccessControlException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlList;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.AccessControlPolicyIterator;
import javax.jcr.security.Privilege;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.AuthorizableExistsException;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.settings.SlingSettingsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(metatype=false, label="GroupService", description="to create a copy of social group")
@Service
@Property(name="service.description", value={"GroupService to create a live copy based on the social group blueprint"})
public class GroupServiceImpl
implements GroupService {
    private static final Logger log = LoggerFactory.getLogger(GroupServiceImpl.class);
    @Reference
    protected SlingSettingsService settingsService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY, policy=ReferencePolicy.STATIC)
    private WorkflowService workflowService;
    private final String WORKFLOW_MODEL = "/etc/workflow/models/social/group/new-community/jcr:content/model";
    private final String ROOT = "root";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Group createGroup(SlingRepository repository, ResourceResolver resolver, final String groupId, String intermediatePath, String liveCopyPath, String liveCopyName, String type) throws GroupException, RepositoryException {
        if (null == liveCopyName || liveCopyName.equals("")) {
            log.error("GroupService: live copy name cannot be empty.");
            throw new GroupException("GroupService: live copy name cannot be empty.");
        }
        if (null == liveCopyPath || liveCopyPath.equals("")) {
            log.error("GroupService: live copy path cannot be empty.");
            throw new GroupException("GroupService: live copy path cannot be empty.");
        }
        Session session = repository.loginAdministrative(null);
        UserManager um = ((JackrabbitSession)session).getUserManager();
        try {
            Authorizable group = um.getAuthorizable(groupId);
            if (group != null) {
                if (!group.isGroup()) {
                    log.error("GroupService: " + groupId + " is already used by another User");
                } else {
                    log.error("GroupService: " + groupId + " already exists");
                }
            }
            if (group == null) {
                Principal groupPrincipal = new Principal(){

                    public String getName() {
                        return groupId;
                    }
                };
                group = um.createGroup(groupPrincipal, intermediatePath);
            }
            PageManager pageManager = (PageManager)resolver.adaptTo(PageManager.class);
            Page livecopy = pageManager.getPage(liveCopyPath + "/" + liveCopyName);
            Node node = (Node)livecopy.getContentResource().adaptTo(Node.class);
            node.setProperty(type, intermediatePath + "/" + groupId);
            Group group2 = (Group)group;
            return group2;
        }
        catch (AuthorizableExistsException e2) {
            log.error("GroupService: group already exists", (Throwable)e2);
        }
        catch (RepositoryException e1) {
            log.error("GroupService: failed to add user to group", (Throwable)e1);
        }
        catch (AccessControlException e3) {
            log.error("GroupService: failed to grant priviledges", (Throwable)e3);
        }
        finally {
            if (session != null) {
                if (session.hasPendingChanges()) {
                    session.save();
                }
                session.logout();
            }
        }
        return null;
    }

    @Override
    public void addGroupMember(SlingRepository repository, String groupId, String authorizableId) throws GroupException, RepositoryException {
        this.addGroupMembers(repository, groupId, new String[]{authorizableId});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addGroupMembers(SlingRepository repository, String groupId, String[] authorizableIds) throws GroupException, RepositoryException {
        Session session = repository.loginAdministrative(null);
        UserManager um = ((JackrabbitSession)session).getUserManager();
        try {
            Authorizable group = um.getAuthorizable(groupId);
            if (group == null || !group.isGroup()) {
                log.error("GroupService: Group '" + groupId + "' does not exist");
                throw new GroupException("Group '" + groupId + "' does not exist");
            }
            for (String authorizableId : authorizableIds) {
                if (authorizableIds == null || authorizableIds.length == 0) {
                    log.error("GroupService: authorizableId cannot be null");
                    continue;
                }
                Authorizable authorizable = um.getAuthorizable(authorizableId);
                if (authorizable == null) {
                    log.error("GroupService.addGroupMembers: Authorizable '" + authorizableId + "' does not exist");
                    continue;
                }
                if (((Group)group).isMember(authorizable)) continue;
                ((Group)group).addMember(authorizable);
            }
        }
        catch (RepositoryException e1) {
            log.error("GroupService: failed to add user to group", (Throwable)e1);
        }
        finally {
            if (session != null) {
                if (session.hasPendingChanges()) {
                    session.save();
                }
                session.logout();
            }
        }
    }

    @Override
    public void removeGroupMember(SlingRepository repository, String groupId, String authorizableId) throws GroupException, RepositoryException {
        this.removeGroupMembers(repository, groupId, new String[]{authorizableId});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeGroupMembers(SlingRepository repository, String groupId, String[] authorizableIds) throws GroupException, RepositoryException {
        Session session = repository.loginAdministrative(null);
        UserManager um = ((JackrabbitSession)session).getUserManager();
        try {
            Authorizable group = um.getAuthorizable(groupId);
            if (group == null || !group.isGroup()) {
                log.error("GroupService: Group '" + groupId + "' does not exist");
                throw new GroupException("Group '" + groupId + "' does not exist");
            }
            for (String authorizableId : authorizableIds) {
                if (authorizableIds == null || authorizableIds.length == 0) {
                    log.error("GroupService: authorizableId cannot be null");
                    throw new GroupException("authorizableId cannot be null");
                }
                Authorizable authorizable = um.getAuthorizable(authorizableId);
                if (authorizable == null) {
                    log.error("GroupService: Authorizable '" + authorizableId + "' does not exist");
                    throw new GroupException("Authorizable '" + authorizableId + "' does not exist");
                }
                this.removeMember((Group)group, authorizable);
            }
        }
        catch (RepositoryException e1) {
            log.error("GroupService: failed to add user to group", (Throwable)e1);
        }
        finally {
            if (session != null) {
                if (session.hasPendingChanges()) {
                    session.save();
                }
                session.logout();
            }
        }
    }

    private void removeMember(Group group, Authorizable authorizable) throws GroupException, RepositoryException {
        if (group.isDeclaredMember(authorizable)) {
            group.removeMember(authorizable);
        }
        if (group.isMember(authorizable)) {
            Iterator members = group.getDeclaredMembers();
            while (members.hasNext()) {
                Authorizable temp = (Authorizable)members.next();
                if (!temp.isGroup()) continue;
                this.removeMember((Group)temp, authorizable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyAccessControlPolicy(ResourceResolver resolver, String sourcePath, String langs, String destPath, String groupId, String type) throws GroupException, RepositoryException, AccessControlException {
        Session session = (Session)resolver.adaptTo(Session.class);
        try {
            AccessControlManager acMgr = ((JackrabbitSession)session).getAccessControlManager();
            UserManager um = ((JackrabbitSession)session).getUserManager();
            Authorizable admins = um.getAuthorizable(groupId + "-admins");
            Authorizable moderators = um.getAuthorizable(groupId + "-moderators");
            Authorizable members = um.getAuthorizable(groupId + "-members");
            if (StringUtils.isEmpty((String)type)) {
                type = "Open";
            }
            if ("Closed".equalsIgnoreCase(type = type.toLowerCase())) {
                this.copyAccessControlEntry(resolver, acMgr, admins, moderators, members, sourcePath, destPath, type + "root");
            } else {
                this.copyAccessControlEntry(resolver, acMgr, admins, moderators, members, sourcePath, destPath, type);
            }
            PageManager pageManager = (PageManager)resolver.adaptTo(PageManager.class);
            Page master = pageManager.getPage(destPath);
            Iterator children = master.listChildren((Filter)new PageFilter());
            while (children.hasNext()) {
                Page child = (Page)children.next();
                String dPath = child.getPath();
                String sPath = langs + dPath.substring(dPath.lastIndexOf(47));
                this.copyAccessControlEntry(resolver, acMgr, admins, moderators, members, sPath, dPath, type);
            }
        }
        catch (RepositoryException e1) {
            log.error("GroupService: failed to add user to group", (Throwable)e1);
        }
        catch (AccessControlException e3) {
            log.error("GroupService: failed to grant priviledges", (Throwable)e3);
        }
        finally {
            if (session != null && session.hasPendingChanges()) {
                session.save();
            }
        }
    }

    protected void copyAccessControlEntry(ResourceResolver resolver, AccessControlManager acMgr, Authorizable admins, Authorizable moderators, Authorizable members, String sourcePath, String destPath, String type) throws RepositoryException, AccessControlException {
        AccessControlPolicy[] existing;
        String ugcPath = CollabUtil.prepareUserGeneratedContent((ResourceResolver)resolver, (String)destPath);
        AccessControlList acl = null;
        AccessControlList acl_dest = null;
        AccessControlList acl_ugc = null;
        acl_dest = this.getACL(acMgr, destPath);
        acl_ugc = this.getACL(acMgr, ugcPath);
        Session session = (Session)resolver.adaptTo(Session.class);
        PrincipalManager principalManager = ((JackrabbitSession)session).getPrincipalManager();
        Principal p = principalManager.getEveryone();
        if (p != null && acl_dest instanceof JackrabbitAccessControlList && acl_ugc instanceof JackrabbitAccessControlList) {
            Privilege[] read = new Privilege[]{acMgr.privilegeFromName("{http://www.jcp.org/jcr/1.0}read")};
            Privilege[] addChildNodes = new Privilege[]{acMgr.privilegeFromName("{http://www.jcp.org/jcr/1.0}addChildNodes")};
            if ("Closed".equalsIgnoreCase(type)) {
                ((JackrabbitAccessControlList)acl_dest).addEntry(p, read, false);
                ((JackrabbitAccessControlList)acl_dest).addEntry(members.getPrincipal(), read, true);
                acMgr.setPolicy(destPath, (AccessControlPolicy)acl_dest);
            } else if ("Closedroot".equalsIgnoreCase(type)) {
                type = "Closed".toLowerCase();
            } else if ("Secret".equalsIgnoreCase(type)) {
                ((JackrabbitAccessControlList)acl_dest).addEntry(p, read, false);
                ((JackrabbitAccessControlList)acl_ugc).addEntry(p, read, false);
                acMgr.setPolicy(destPath, (AccessControlPolicy)acl_dest);
            }
            ((JackrabbitAccessControlList)acl_ugc).addEntry(p, addChildNodes, false);
            ((JackrabbitAccessControlList)acl_ugc).addEntry(members.getPrincipal(), addChildNodes, true);
            acMgr.setPolicy(ugcPath, (AccessControlPolicy)acl_ugc);
        }
        for (AccessControlPolicy pol : existing = acMgr.getPolicies(sourcePath)) {
            AccessControlEntry[] aces;
            if (!(pol instanceof AccessControlList)) continue;
            acl = (AccessControlList)pol;
            for (AccessControlEntry entry : aces = acl.getAccessControlEntries()) {
                Privilege[] privs = entry.getPrivileges();
                String principal = entry.getPrincipal().getName();
                if (!principal.startsWith(type)) continue;
                if (principal.contains("-admins")) {
                    acl_dest.addAccessControlEntry(admins.getPrincipal(), privs);
                    acl_ugc.addAccessControlEntry(admins.getPrincipal(), privs);
                    continue;
                }
                if (principal.contains("-moderators")) {
                    acl_dest.addAccessControlEntry(moderators.getPrincipal(), privs);
                    acl_ugc.addAccessControlEntry(moderators.getPrincipal(), privs);
                    continue;
                }
                acl_dest.addAccessControlEntry(members.getPrincipal(), privs);
                acl_ugc.addAccessControlEntry(members.getPrincipal(), privs);
            }
            acMgr.setPolicy(destPath, (AccessControlPolicy)acl_dest);
            acMgr.setPolicy(ugcPath, (AccessControlPolicy)acl_ugc);
            break;
        }
    }

    protected void removeAccessControlEntry(AccessControlManager acMgr, String path, Principal principal, String privilegeName) throws RepositoryException, AccessControlException, PathNotFoundException {
        AccessControlEntry[] aces;
        AccessControlList acl = this.getACL(acMgr, path);
        block0: for (AccessControlEntry entry : aces = acl.getAccessControlEntries()) {
            if (entry.getPrincipal() != principal) continue;
            Privilege[] privs = entry.getPrivileges();
            if (privs.length == 1 && privs[0].getName().equals(privilegeName)) {
                acl.removeAccessControlEntry(entry);
                break;
            }
            int j = 0;
            for (Privilege priv : privs) {
                if (priv.getName().equals(privilegeName)) {
                    Privilege[] new_privs = new Privilege[privs.length - 1];
                    for (int i = 0; i <= privs.length - 2; ++i) {
                        if (i < j) {
                            new_privs[i] = privs[i];
                            continue;
                        }
                        if (i <= j) continue;
                        new_privs[i - 1] = privs[i];
                    }
                    acl.addAccessControlEntry(principal, new_privs);
                    acl.removeAccessControlEntry(entry);
                    continue block0;
                }
                ++j;
            }
        }
        acMgr.setPolicy(path, (AccessControlPolicy)acl);
    }

    protected AccessControlList getACL(AccessControlManager acMgr, String path) {
        AccessControlList acl = null;
        try {
            AccessControlPolicy[] existing;
            for (AccessControlPolicy p : existing = acMgr.getPolicies(path)) {
                if (!(p instanceof AccessControlList)) continue;
                acl = (AccessControlList)p;
                break;
            }
            if (acl == null) {
                AccessControlPolicyIterator policyIterator = acMgr.getApplicablePolicies(path);
                while (policyIterator.hasNext()) {
                    AccessControlPolicy acp = policyIterator.nextAccessControlPolicy();
                    if (!(acp instanceof AccessControlList)) continue;
                    acl = (AccessControlList)acp;
                }
            }
        }
        catch (PathNotFoundException e) {
            log.error("GroupService: failed to get ACL for path " + path, (Throwable)e);
        }
        catch (AccessDeniedException e1) {
            log.error("GroupService: failed to get ACL for path " + path, (Throwable)e1);
        }
        catch (RepositoryException e2) {
            log.error("GroupService: failed to get ACL for path " + path, (Throwable)e2);
        }
        return acl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void activateCommunity(SlingRepository repository, ResourceResolver resolver, Replicator replicator, String page) throws GroupException, RepositoryException {
        if (this.isPublishMode()) {
            return;
        }
        Session session = repository.loginAdministrative(null);
        try {
            List<String> paths = this.getPaths(resolver, page);
            for (String subPath : paths) {
                replicator.replicate(session, ReplicationActionType.ACTIVATE, subPath);
            }
            this.triggerWorkflow(session, "/etc/workflow/models/social/group/new-community/jcr:content/model", page);
        }
        catch (ReplicationException e) {
            log.error("Error while triggering reverse replication of {}", (Object)page, (Object)e);
        }
        catch (AccessControlException e3) {
            log.error("GroupService: failed to grant priviledges", (Throwable)e3);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    private void triggerWorkflow(Session session, String wfModelPath, String payload) {
        if ("".equals(wfModelPath)) {
            log.error("workflow model [{}] are missing.", (Object)wfModelPath);
            return;
        }
        if (this.workflowService == null) {
            log.error("workflowService is not available.");
            return;
        }
        WorkflowSession wfSession = this.workflowService.getWorkflowSession(session);
        try {
            WorkflowModel model = wfSession.getModel(wfModelPath);
            if (null != model) {
                WorkflowData data = wfSession.newWorkflowData("JCR_PATH", (Object)payload);
                Workflow workflow = wfSession.startWorkflow(model, data);
                log.info("started workflow [{}] for new community on [{}].", (Object)workflow, (Object)payload);
            } else {
                log.error("could not find workflow model [{}].", (Object)wfModelPath);
            }
        }
        catch (WorkflowException e) {
            log.error("a workflow error occurred: ", (Throwable)e);
        }
    }

    private boolean isPublishMode() {
        return this.settingsService != null && this.settingsService.getRunModes().contains("publish");
    }

    private List<String> getPaths(ResourceResolver resolver, String path) {
        ArrayList<String> paths = new ArrayList<String>();
        Resource node = resolver.getResource(path);
        Iterator children = resolver.listChildren(node);
        paths.add(path);
        while (children.hasNext()) {
            String child = ((Resource)children.next()).getPath();
            if (child.contains("jcr:content") || child.contains("rep:policy")) continue;
            paths.add(child);
            paths.addAll(this.getPaths(resolver, child));
        }
        return paths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanup(SlingRepository repository, ResourceResolver resolver, String path) throws GroupException, RepositoryException {
        Node node = (Node)resolver.getResource(path).adaptTo(Node.class);
        Session session = repository.loginAdministrative(null);
        try {
            node.remove();
            node.getSession().save();
        }
        catch (RepositoryException e) {
            log.debug("failed to delete the community temporary node in etc ", (Throwable)e);
            session.refresh(false);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    protected void bindSettingsService(SlingSettingsService slingSettingsService) {
        this.settingsService = slingSettingsService;
    }

    protected void unbindSettingsService(SlingSettingsService slingSettingsService) {
        if (this.settingsService == slingSettingsService) {
            this.settingsService = null;
        }
    }

    protected void bindWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    protected void unbindWorkflowService(WorkflowService workflowService) {
        if (this.workflowService == workflowService) {
            this.workflowService = null;
        }
    }
}

