/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.group.impl.servlets;

import com.adobe.cq.social.group.api.GroupService;
import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.jcr.api.SlingRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="%CommunityServlet.name", description="%CommunityServlet.description", metatype=true)
@Service(value={Servlet.class})
@Properties(value={@Property(name="sling.servlet.resourceTypes", value={"sling/servlet/default"}), @Property(name="service.description", value={"%CommunityServlet.name"}), @Property(name="sling.servlet.methods", value={"POST"}, propertyPrivate=true), @Property(name="sling.servlet.selectors", value={"removemember", "addmember", "invite"}, propertyPrivate=true), @Property(name="sling.servlet.extensions", value={"html"}, propertyPrivate=true), @Property(name="reverseReplicate", boolValue={true})})
public class CommunityServlet
extends SlingAllMethodsServlet {
    private static final long serialVersionUID = -1156320244249099595L;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY, policy=ReferencePolicy.STATIC)
    protected SlingRepository repository;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY, policy=ReferencePolicy.STATIC)
    private GroupService groupService;
    private static final Logger log = LoggerFactory.getLogger(CommunityServlet.class);
    private static final String SELECTOR_REMOVE_MEMBER = "removemember";
    private static final String SELECTOR_ADD_MEMBER = "addmember";
    private static final String SELECTOR_INVITE = "invite";
    private static final String REQ_ATTR_REDIRECT = "cq.form.redirect";

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        String groupId = request.getParameter("groupid");
        String authorizable = request.getParameter("uid");
        Resource resource = request.getResource();
        String delimiters = "[\\s,;]+";
        String url = null;
        String selector = request.getRequestPathInfo().getSelectorString();
        String mode = "";
        try {
            if (selector.equals(SELECTOR_REMOVE_MEMBER)) {
                mode = "removing member";
                this.groupService.removeGroupMember(this.repository, groupId, authorizable);
            } else if (selector.equals(SELECTOR_ADD_MEMBER)) {
                mode = "adding member";
                this.groupService.addGroupMember(this.repository, groupId, authorizable);
            } else if (selector.equals(SELECTOR_INVITE)) {
                mode = SELECTOR_INVITE;
                if (authorizable != null) {
                    String[] invitelist = authorizable.split("[\\s,;]+");
                    this.groupService.addGroupMembers(this.repository, groupId, invitelist);
                }
            }
        }
        catch (Exception e) {
            log.error("doPost: error while [{}] into group [{}]", (Object)(mode + authorizable), (Object)groupId);
            log.error("", (Throwable)e);
        }
        url = resource.getPath();
        this.redirect(request, response, url);
    }

    protected void redirect(SlingHttpServletRequest request, SlingHttpServletResponse response, String url) {
        try {
            String cp = request.getContextPath();
            String newURL = url;
            if (newURL != null && newURL.endsWith("/")) {
                newURL = newURL.substring(0, newURL.length() - 1);
            }
            newURL = newURL + ".html";
            if (!("".equals(cp) || url.contains("://") || url.startsWith(cp))) {
                newURL = cp + url;
            }
            response.sendRedirect(newURL);
        }
        catch (IOException ioe) {
            log.error("failed to redirect to {}", (Object)url, (Object)ioe);
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    protected void bindGroupService(GroupService groupService) {
        this.groupService = groupService;
    }

    protected void unbindGroupService(GroupService groupService) {
        if (this.groupService == groupService) {
            this.groupService = null;
        }
    }
}

