/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.group.impl.servlets;

import com.adobe.cq.social.group.api.GroupUtil;
import com.adobe.granite.xss.XSSAPI;
import com.day.cq.commons.TidyJSONWriter;
import com.day.cq.commons.jcr.JcrUtil;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.ServletException;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.commons.json.JSONException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service
@Properties(value={@Property(name="sling.servlet.paths", value={"/services/validategroupname"})})
public class ValidateNameServlet
extends SlingSafeMethodsServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(ValidateNameServlet.class);
    @Reference
    private XSSAPI xssAPI;

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("utf-8");
        String liveCopyTitle = request.getParameter("liveCopyTitle");
        String name = JcrUtil.createValidName((String)liveCopyTitle);
        String root = request.getParameter("grouproot");
        TidyJSONWriter writer = new TidyJSONWriter((Writer)response.getWriter());
        try {
            ResourceResolver resolver = request.getResourceResolver();
            writer.object();
            if (StringUtils.isBlank((String)liveCopyTitle)) {
                writer.key("value").value((Object)"0");
            } else if (!StringUtils.equals((String)liveCopyTitle.trim(), (String)liveCopyTitle)) {
                writer.key("value").value((Object)"1");
            } else if (!StringUtils.equals((String)this.xssAPI.filterHTML(liveCopyTitle), (String)liveCopyTitle) && liveCopyTitle.contains("<")) {
                writer.key("value").value((Object)"2");
            } else if (!GroupUtil.validateGroupName(resolver, name, root)) {
                writer.key("value").value((Object)"3");
            } else {
                writer.key("value").value((Object)"true");
            }
            writer.endObject();
        }
        catch (JSONException e) {
            log.error("could not write json: ", (Throwable)e);
        }
    }

    protected void bindXssAPI(XSSAPI xSSAPI) {
        this.xssAPI = xSSAPI;
    }

    protected void unbindXssAPI(XSSAPI xSSAPI) {
        if (this.xssAPI == xSSAPI) {
            this.xssAPI = null;
        }
    }
}

