/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.storage;

import com.adobe.cq.social.storage.buckets.NestedBucketStorageSystem;
import com.adobe.cq.social.storage.buckets.impl.NestedBucketStorageSystemImpl;
import com.adobe.cq.social.storage.index.Index;
import com.adobe.cq.social.storage.index.IndexCounter;
import com.adobe.cq.social.storage.index.impl.IndexCounterImpl;
import com.adobe.cq.social.storage.index.impl.IndexImpl;
import org.apache.sling.api.adapter.AdapterFactory;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BucketStorageAdapterFactory
implements AdapterFactory {
    private static Logger log = LoggerFactory.getLogger(BucketStorageAdapterFactory.class);
    private static final Class<NestedBucketStorageSystem> NESTED_BUCKET_STORAGE_SYSTEM = NestedBucketStorageSystem.class;
    private static final Class<IndexCounter> INDEX_COUNTER_CLASS = IndexCounter.class;
    private static final Class<Index> INDEX_CLASS = Index.class;
    public static final String[] ADAPTER_CLASSES = new String[]{NESTED_BUCKET_STORAGE_SYSTEM.getName(), INDEX_COUNTER_CLASS.getName(), INDEX_CLASS.getName()};
    public static final String[] ADAPTABLE_CLASSES = new String[]{Resource.class.getName()};

    public <AdapterType> AdapterType getAdapter(Object adaptable, Class<AdapterType> type) {
        if (adaptable instanceof Resource) {
            return this.getAdapter((Resource)adaptable, type);
        }
        return null;
    }

    private <AdapterType> AdapterType getAdapter(Resource resource, Class<AdapterType> type) {
        if (NESTED_BUCKET_STORAGE_SYSTEM == type) {
            return (AdapterType)new NestedBucketStorageSystemImpl(resource);
        }
        if (type == INDEX_COUNTER_CLASS) {
            return (AdapterType)new IndexCounterImpl(resource);
        }
        if (INDEX_CLASS == type) {
            return (AdapterType)new IndexImpl(resource);
        }
        log.debug("Unable to adapt resource to requested type {}", (Object)type.getName());
        return null;
    }
}

