/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.storage.buckets.impl;

import com.adobe.cq.social.storage.buckets.NestedBucketStorageException;
import com.adobe.cq.social.storage.buckets.NestedBucketStorageProperties;
import com.adobe.cq.social.storage.buckets.impl.NestedBucketIterator;
import com.day.text.Text;
import java.util.Collections;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BucketStorageService {
    private static final Logger log = LoggerFactory.getLogger(BucketStorageService.class);
    private final Lock lock;
    protected static final Map locks = Collections.synchronizedMap(new ReferenceMap(0, 1));
    private final NestedBucketStorageProperties bucketStorageProperties;

    public BucketStorageService(NestedBucketStorageProperties bucketStorageInfo) {
        this.bucketStorageProperties = bucketStorageInfo;
        this.lock = BucketStorageService.getLock(bucketStorageInfo.getRoot().getPath());
        this.createFirstBucket(bucketStorageInfo);
    }

    public String getBucket() {
        Node currentBucket;
        try {
            currentBucket = this.getCurrentBucket();
            if (!this.isOverflowedBucket(currentBucket)) {
                return currentBucket.getPath();
            }
        }
        catch (RepositoryException e) {
            log.debug("Failed to get current bucket.", (Throwable)e);
            throw new NestedBucketStorageException("Failed to get bucket.", (Exception)((Object)e));
        }
        try {
            this.lock.lock();
            Resource root = this.bucketStorageProperties.getRoot();
            String nextBucketPath = this.getNextBucketPath(currentBucket);
            ResourceResolver resourceResolver = root.getResourceResolver();
            Resource res = resourceResolver.getResource(nextBucketPath);
            if (res == null || !ResourceUtil.isNonExistingResource((Resource)res)) {
                this.createBucketNode(resourceResolver, nextBucketPath, this.bucketStorageProperties.getNodeType());
            }
            log.debug("Create new bucket[{}]", (Object)nextBucketPath);
            String string = nextBucketPath;
            return string;
        }
        catch (RepositoryException e) {
            log.error("Failed to get bucket.", (Throwable)e);
            throw new NestedBucketStorageException("Failed to get bucket.", (Exception)((Object)e));
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFirstBucket(NestedBucketStorageProperties bucketStorageProperties) {
        try {
            this.lock.lock();
            Resource root = bucketStorageProperties.getRoot();
            String bucketName = this.getBucketName(1, bucketStorageProperties.getPostfix());
            String bucketPath = root.getPath() + "/" + bucketName;
            ResourceResolver resourceResolver = root.getResourceResolver();
            Resource firstBucket = resourceResolver.getResource(bucketPath);
            if (firstBucket == null) {
                this.createBucketNode(resourceResolver, bucketPath, bucketStorageProperties.getNodeType());
            }
        }
        catch (RepositoryException e) {
            log.error("Failed to create first bucket.", (Throwable)e);
        }
        finally {
            this.lock.unlock();
        }
    }

    private Node getCurrentBucket() throws RepositoryException {
        Resource root = this.bucketStorageProperties.getRoot();
        String bucketPostfix = this.bucketStorageProperties.getPostfix();
        NestedBucketIterator iterator = new NestedBucketIterator(this.bucketStorageProperties);
        Resource bucket = null;
        while (iterator.hasNext()) {
            bucket = iterator.next();
        }
        if (bucket == null) {
            throw new NestedBucketStorageException("Failed to obtain current bucket");
        }
        Node bucketNode = (Node)bucket.adaptTo(Node.class);
        log.debug("current bucket:[{}]", (Object)bucketNode.getPath());
        return bucketNode;
    }

    private String getNextBucket(Node currentBucket) throws RepositoryException {
        if (currentBucket != null) {
            Resource root = this.bucketStorageProperties.getRoot();
            ResourceResolver resourceResolver = root.getResourceResolver();
            Resource res = resourceResolver.getResource(currentBucket.getPath());
            String bucketPath = currentBucket.getPath();
            if (!ResourceUtil.isNonExistingResource((Resource)res) && this.isOverflowedBucket(currentBucket)) {
                bucketPath = this.getNextBucketPath(currentBucket);
                this.createBucketNode(resourceResolver, bucketPath, this.bucketStorageProperties.getNodeType());
            }
            return bucketPath;
        }
        return null;
    }

    private String getNextBucketPath(Node currentBucket) throws RepositoryException, ItemNotFoundException, AccessDeniedException {
        String bucketPostfix = this.bucketStorageProperties.getPostfix();
        String bucketName = currentBucket.getName();
        int bucketNumber = this.getBucketNumberFromBucketName(bucketName, bucketPostfix) + 1;
        Node parentBucket = currentBucket.getParent();
        String bucketPath = !this.isBucketOverflow(bucketNumber) ? parentBucket.getPath() + "/" + this.getBucketName(bucketNumber, bucketPostfix) : parentBucket.getPath() + "/" + bucketNumber + "/" + this.getBucketName(bucketNumber + 1, bucketPostfix);
        return bucketPath;
    }

    private int getBucketNumberFromBucketName(String bucketName, String bucketPostfix) {
        try {
            int len = bucketName.length() - bucketPostfix.length();
            if (len > 0) {
                String bucketNumber = bucketName.substring(0, len);
                return Integer.parseInt(bucketNumber);
            }
            throw new NestedBucketStorageException("Illegal bucket name: " + bucketName);
        }
        catch (NumberFormatException e) {
            log.debug("Failed to get bucket number.", (Throwable)e);
            throw e;
        }
    }

    private String getBucketName(int bucketNumber, String bucketPostfix) {
        return bucketNumber + bucketPostfix;
    }

    private boolean isBucketOverflow(int bucketNumber) {
        return bucketNumber % 1000 == 0;
    }

    private Node createBucketNode(ResourceResolver resolver, String nodePath, String nodeType) throws RepositoryException {
        Node retBucketNode;
        String path = nodePath;
        Session session = (Session)resolver.adaptTo(Session.class);
        if (session == null) {
            throw new NestedBucketStorageException("resolver must be adaptable to session");
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        log.debug("locking path {}", (Object)this.bucketStorageProperties.getRoot().getPath());
        try {
            this.lock.lock();
            Resource resource = resolver.getResource(nodePath);
            if (resource == null || ResourceUtil.isNonExistingResource((Resource)resource)) {
                String name;
                Node root = ((Session)resolver.adaptTo(Session.class)).getRootNode();
                StringTokenizer names = new StringTokenizer(Text.getRelativeParent((String)path, (int)1), "/");
                while (names.hasMoreTokens()) {
                    name = names.nextToken();
                    if (!root.hasNode(name)) {
                        root.addNode(name, nodeType);
                    }
                    root = root.getNode(name);
                }
                name = Text.getName((String)path);
                retBucketNode = root.addNode(name, nodeType);
                log.debug("added bucket node {}", (Object)retBucketNode.getPath());
                session.save();
            } else {
                retBucketNode = (Node)resource.adaptTo(Node.class);
            }
        }
        catch (InvalidItemStateException e) {
            try {
                log.debug("InvalidItemStateException", (Throwable)e);
                session.refresh(false);
                retBucketNode = (Node)resolver.getResource(path).adaptTo(Node.class);
            }
            catch (RepositoryException re) {
                log.error("Failed to rollback change", (Throwable)re);
                throw new NestedBucketStorageException("Unable to rollback change", (Exception)((Object)re));
            }
        }
        catch (Exception e) {
            log.error("Failed to create new bucket node: " + nodePath, (Throwable)e);
            throw new RepositoryException((Throwable)e);
        }
        finally {
            this.lock.unlock();
        }
        if (retBucketNode == null) {
            throw new NestedBucketStorageException("Failed to create bucket node.");
        }
        return retBucketNode;
    }

    private boolean isOverflowedBucket(Node bucket) throws RepositoryException {
        if (bucket != null) {
            return bucket.getNodes().getSize() >= 1000L;
        }
        return true;
    }

    protected static synchronized Lock getLock(String rootPath) {
        Lock lock = (Lock)locks.get(rootPath);
        if (lock == null) {
            lock = new ReentrantLock();
            log.debug("new lock for {}", (Object)rootPath);
            locks.put(rootPath, lock);
        }
        return lock;
    }
}

