/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.storage.buckets.impl;

import com.adobe.cq.social.storage.buckets.NestedBucketStorageProperties;
import java.util.Iterator;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NestedBucketIterator
implements Iterator<Resource> {
    final NestedBucketStorageProperties properties;
    Resource bucket;
    Iterator<Resource> buckets;
    private static final Logger log = LoggerFactory.getLogger(NestedBucketIterator.class);

    public NestedBucketIterator(NestedBucketStorageProperties properties) {
        this.properties = properties;
        this.buckets = properties.getRoot().listChildren();
    }

    public long size() {
        Node rootNode = (Node)this.properties.getRoot().adaptTo(Node.class);
        return this.countBuckets(rootNode);
    }

    private long countBuckets(Node rootNode) {
        long count = 0L;
        if (rootNode != null) {
            try {
                NodeIterator ni = rootNode.getNodes();
                long size = ni.getSize();
                if (size < 1000L) {
                    count += size;
                } else {
                    while (ni.hasNext()) {
                        Node child = (Node)ni.next();
                        if (child.getName().endsWith(this.properties.getPostfix())) {
                            ++count;
                            continue;
                        }
                        count += this.countBuckets(child);
                    }
                }
            }
            catch (RepositoryException e) {
                log.error("Error occured while counting buckets", (Throwable)e);
            }
        }
        return count;
    }

    @Override
    public boolean hasNext() {
        boolean retVal;
        if (this.bucket == null) {
            if (this.buckets.hasNext()) {
                this.bucket = this.buckets.next();
                if (!this.bucket.getResourceType().equals(this.properties.getNodeType())) {
                    return this.hasNext();
                }
                if (this.bucket.getName().indexOf(this.properties.getPostfix()) > 0) {
                    retVal = true;
                } else {
                    this.buckets = this.bucket.listChildren();
                    this.bucket = null;
                    retVal = this.hasNext();
                }
            } else {
                retVal = false;
            }
        } else {
            retVal = this.buckets.hasNext();
        }
        return retVal;
    }

    @Override
    public Resource next() {
        Resource retVal = null;
        if (this.bucket == null) {
            if (this.hasNext()) {
                retVal = this.bucket;
            }
        } else {
            retVal = this.bucket;
        }
        this.bucket = null;
        return retVal;
    }

    @Override
    public void remove() {
    }
}

