/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.storage.buckets.impl;

import com.adobe.cq.social.storage.buckets.NestedBucketStorageProperties;
import com.adobe.cq.social.storage.buckets.impl.NestedBucketIterator;
import java.util.Iterator;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NestedBucketNodesIterator
implements Iterator<Resource> {
    NestedBucketIterator bucketIterator;
    Iterator<Resource> iterator;
    Resource bucket;
    NestedBucketStorageProperties properties;
    private static final Logger log = LoggerFactory.getLogger(NestedBucketNodesIterator.class);

    public NestedBucketNodesIterator(NestedBucketStorageProperties properties) {
        this.properties = properties;
        this.bucketIterator = new NestedBucketIterator(properties);
        this.getNextIterator();
    }

    public long size() {
        long size = 0L;
        NestedBucketIterator iterator = new NestedBucketIterator(this.properties);
        while (iterator.hasNext()) {
            Node bucket = (Node)iterator.next().adaptTo(Node.class);
            if (bucket == null) continue;
            try {
                size += bucket.getNodes().getSize();
            }
            catch (RepositoryException e) {
                log.error("Error occured while counting nodes", (Throwable)e);
            }
        }
        return size;
    }

    @Override
    public boolean hasNext() {
        boolean retVal = false;
        if (this.iterator != null && !(retVal = this.iterator.hasNext())) {
            this.getNextIterator();
            return this.hasNext();
        }
        return retVal;
    }

    @Override
    public Resource next() {
        if (this.iterator != null) {
            return this.iterator.next();
        }
        return null;
    }

    private void getNextIterator() {
        if (this.bucketIterator.hasNext()) {
            this.bucket = this.bucketIterator.next();
            this.iterator = this.bucket.listChildren();
        } else {
            this.iterator = null;
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

