/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.storage.buckets.impl;

import com.adobe.cq.social.storage.buckets.NestedBucketStorageException;
import com.adobe.cq.social.storage.buckets.NestedBucketStorageProperties;
import com.adobe.cq.social.storage.buckets.NestedBucketStorageSystem;
import com.adobe.cq.social.storage.buckets.impl.BucketStoragePropertiesImpl;
import com.adobe.cq.social.storage.buckets.impl.BucketStorageService;
import com.adobe.cq.social.storage.buckets.impl.NestedBucketIterator;
import com.adobe.cq.social.storage.buckets.impl.NestedBucketNodesIterator;
import java.util.Iterator;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.sling.api.resource.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NestedBucketStorageSystemImpl
implements NestedBucketStorageSystem {
    protected final NestedBucketStorageProperties properties;

    public NestedBucketStorageSystemImpl(Resource root) {
        if (root == null) {
            throw new NestedBucketStorageException("Invalid root resource");
        }
        this.properties = new BucketStoragePropertiesImpl(root, "Bucket", "sling:Folder");
    }

    @Override
    public void setBucketPostfix(String postfix) {
        this.properties.setPostfix(postfix);
    }

    @Override
    public String getBucketPostfix() {
        return this.properties.getPostfix();
    }

    @Override
    public void setBucketResourceType(String type) {
        this.properties.setNodeType(type);
    }

    @Override
    public String getBucketResourceType() {
        return this.properties.getNodeType();
    }

    @Override
    public Resource getRoot() {
        return this.properties.getRoot();
    }

    @Override
    public long getNumberChildren() throws NestedBucketStorageException {
        return new NestedBucketNodesIterator(this.properties).size();
    }

    @Override
    public Iterator<Resource> listChildren() throws NestedBucketStorageException {
        return new NestedBucketNodesIterator(this.properties);
    }

    @Override
    public Resource addResource(String name, String primaryNodeTypeName) throws NestedBucketStorageException {
        Node newNode = this.addNode(name, primaryNodeTypeName);
        try {
            return this.getRoot().getResourceResolver().getResource(newNode.getPath());
        }
        catch (RepositoryException e) {
            throw new NestedBucketStorageException("Failed to add new resource.", (Exception)((Object)e));
        }
    }

    @Override
    public Node addNode(String name, String primaryNodeTypeName) throws NestedBucketStorageException {
        Node bucket = this.getBucket();
        try {
            if (bucket != null) {
                return bucket.addNode(name, primaryNodeTypeName);
            }
            throw new NestedBucketStorageException("Failed to obtain bucket.");
        }
        catch (Exception e) {
            throw new NestedBucketStorageException("Failed to add new node.", e);
        }
    }

    @Override
    public Iterator<Resource> listBuckets() throws NestedBucketStorageException {
        return new NestedBucketIterator(this.properties);
    }

    protected String getBucketType() {
        return this.properties.getNodeType();
    }

    protected Node getBucket() throws NestedBucketStorageException {
        BucketStorageService bucketStorageService = new BucketStorageService(this.properties);
        String bucketPath = bucketStorageService.getBucket();
        return (Node)this.getRoot().getResourceResolver().getResource(bucketPath).adaptTo(Node.class);
    }
}

