/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.storage.index;

import com.adobe.cq.social.storage.index.IndexManager;
import com.adobe.cq.social.storage.index.Indexer;
import com.adobe.cq.social.storage.index.KeyIndexer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.sling.api.resource.ResourceResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractBaseIndexManager<K, E>
implements IndexManager<K, E> {
    protected Map<String, Indexer<K, E>> indexers = new HashMap<String, Indexer<K, E>>();
    protected Map<String, KeyIndexer<E>> keyIndexers = new HashMap<String, KeyIndexer<E>>();

    @Override
    public long getSize(String indexName, ResourceResolver resolver) throws RepositoryException {
        return this.indexers.containsKey(indexName) ? this.indexers.get(indexName).getSize(resolver) : -1L;
    }

    @Override
    public long getNumberOfPages(String indexName, int pageSize, ResourceResolver resolver) throws RepositoryException {
        Indexer<K, E> indexer = this.indexers.get(indexName);
        long size = indexer.getSize(resolver);
        if (size == 0L) {
            return 0L;
        }
        long pages = size / (long)pageSize;
        long remainder = size % (long)pageSize;
        return remainder == 0L ? pages : pages + 1L;
    }

    @Override
    public String getIndex(String indexName, ResourceResolver resolver, K key, String endsWith) {
        return this.indexers.get(indexName).getIndex(resolver, key, endsWith);
    }

    @Override
    public int getIndexLoc(String indexName, ResourceResolver resolver, K key, String endsWith) {
        Indexer<K, E> indexer = this.indexers.get(indexName);
        if (indexer != null) {
            return this.indexers.get(indexName).getIndexLoc(resolver, key, endsWith);
        }
        return -1;
    }

    @Override
    public void unindex(String indexName, ResourceResolver resolver, String keyIndexName, String targetId, K key, String endsWith) throws RepositoryException {
        this.indexers.get(indexName).unindex(resolver, key, endsWith);
        this.keyIndexers.get(keyIndexName).unindex(resolver, targetId, null);
    }

    @Override
    public List<E> getPageByNumber(String indexName, int pageSize, ResourceResolver resolver, int pageNumber, String rootPath) {
        Indexer<K, E> indexer = this.indexers.get(indexName);
        long numIndexes = indexer.getSize(resolver);
        if (numIndexes == 0L) {
            return new ArrayList();
        }
        int start = (int)(numIndexes - (long)((pageNumber - 1) * pageSize)) - 1;
        return indexer.getElements(resolver, start, pageSize, rootPath);
    }

    @Override
    public List<E> getPageByOffset(String indexName, int pageSize, ResourceResolver resolver, int offset, String rootPath) {
        Indexer<K, E> indexer = this.indexers.get(indexName);
        long numIndexes = indexer.getSize(resolver);
        if (numIndexes == 0L) {
            return new ArrayList();
        }
        int start = (int)numIndexes - offset - 1;
        return indexer.getElements(resolver, start, pageSize, rootPath);
    }

    @Override
    public void index(String indexName, ResourceResolver resolver, String keyIndexName, String targetId, E target, K indexKey, String indexContent) throws RepositoryException {
        String indexInfo = this.indexers.get(indexName).index(resolver, target, indexKey, indexContent);
        this.keyIndexers.get(keyIndexName).index(resolver, target, targetId, indexInfo);
    }

    @Override
    public Indexer<K, E> getIndexer(String indexName) {
        return this.indexers.get(indexName);
    }

    @Override
    public void registerIndexer(Indexer<K, E> indexer) {
        this.indexers.put(indexer.getName(), indexer);
    }

    @Override
    public boolean isRegistered(String name) {
        return this.indexers.containsKey(name);
    }

    @Override
    public void reindex(String indexName, ResourceResolver resolver, String keyIndexName, String targetId, E target, K prevIndexKey, K indexKey, String indexContent, boolean force, String endsWith) throws RepositoryException {
        String keyIndex = this.indexers.get(indexName).reindex(resolver, target, prevIndexKey, indexKey, indexContent, force, endsWith);
        if (keyIndex != null) {
            this.keyIndexers.get(keyIndexName).reindex(resolver, target, targetId, targetId, keyIndex, force, null);
        }
    }

    @Override
    public KeyIndexer<E> getKeyIndexer(String indexName) {
        return this.keyIndexers.get(indexName);
    }
}

