/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.storage.index;

import com.adobe.cq.social.storage.index.IndexServiceException;
import com.day.cq.commons.jcr.JcrUtil;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.WCMException;
import com.day.text.Text;
import java.util.StringTokenizer;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

public class IndexUtil {
    public static final String INDEX_FOLDER = "index";

    public static String getBaseIndexFolder(ResourceResolver resolver, String path) {
        Resource resource = resolver.getResource(path);
        String indexPath = null;
        int end = path.indexOf("jcr:content");
        if (end > 0) {
            int componentNameEnd;
            int componentNameBegin = end + "jcr:content".length() + 1;
            if (resource != null && path.indexOf("/content/usergenerated") == -1) {
                componentNameBegin = path.indexOf(47, componentNameBegin) + 1;
            }
            componentNameEnd = (componentNameEnd = path.indexOf(47, componentNameBegin)) == -1 ? path.length() : componentNameEnd;
            indexPath = path.substring(0, end - 1) + "/" + path.substring(componentNameBegin, componentNameEnd) + "/" + INDEX_FOLDER;
            if (resolver.getResource(indexPath) == null) {
                indexPath = path.substring(0, end - 1) + "/" + "jcr:content" + "/" + path.substring(componentNameBegin, componentNameEnd) + "_" + INDEX_FOLDER;
            }
            return indexPath;
        }
        throw new IndexServiceException("Base path does not have content node.");
    }

    public static String getComponentName(ResourceResolver resolver, String path) {
        Resource resource = resolver.getResource(path);
        Object indexPath = null;
        int end = path.indexOf("jcr:content");
        if (end > 0) {
            int componentNameEnd;
            int componentNameBegin = end + "jcr:content".length() + 1;
            if (resource != null && path.indexOf("/content/usergenerated") == -1) {
                componentNameBegin = path.indexOf(47, componentNameBegin) + 1;
            }
            componentNameEnd = (componentNameEnd = path.indexOf(47, componentNameBegin)) == -1 ? path.length() : componentNameEnd;
            return path.substring(componentNameBegin, componentNameEnd);
        }
        throw new IndexServiceException("Base path does not have content node.");
    }

    public static String prepareUserGeneratedContent(ResourceResolver resolver, String pagePath) throws IndexServiceException {
        String ugcPagePath = "/content/usergenerated";
        StringTokenizer pathElems = new StringTokenizer(pagePath, "/");
        while (pathElems.hasMoreTokens()) {
            if (resolver.getResource(ugcPagePath = ugcPagePath + "/" + pathElems.nextToken()) != null) continue;
            if (ugcPagePath.equals("/content/usergenerated/content")) {
                IndexUtil.createNode(resolver, ugcPagePath, "sling:Folder");
                IndexUtil.save(resolver);
                continue;
            }
            IndexUtil.createPage(resolver, ugcPagePath, null, null, null, null);
        }
        return ugcPagePath;
    }

    public static void save(ResourceResolver resolver) throws IndexServiceException, IllegalArgumentException {
        Session session = (Session)resolver.adaptTo(Session.class);
        if (session == null) {
            throw new IllegalArgumentException("resolver must be adaptable to session");
        }
        try {
            session.save();
        }
        catch (RepositoryException re) {
            throw new IndexServiceException("failed to save changes", (Exception)((Object)re));
        }
    }

    public static Page createPage(ResourceResolver resolver, String path, String template, String resourceTypeProp, String resourceType, String title) throws IndexServiceException {
        Throwable e;
        try {
            String parentPath = Text.getRelativeParent((String)path, (int)1);
            String name = Text.getName((String)path);
            if (resolver.getResource(parentPath) == null) {
                IndexUtil.createNode(resolver, parentPath, "nt:unstructured");
                IndexUtil.save(resolver);
            }
            if (!JcrUtil.isValidName((String)name)) {
                name = JcrUtil.createValidName((String)name, (String[])JcrUtil.HYPHEN_LABEL_CHAR_MAPPING);
            }
            Page page = ((PageManager)resolver.adaptTo(PageManager.class)).create(parentPath, name, template, title);
            if (StringUtils.isNotEmpty((String)resourceTypeProp)) {
                ((Node)page.getContentResource().adaptTo(Node.class)).setProperty(resourceTypeProp, resourceType);
            }
            return page;
        }
        catch (RepositoryException re) {
            e = re;
        }
        catch (WCMException wcme) {
            e = wcme;
        }
        throw new IndexServiceException("failed to create page", (Exception)e);
    }

    public static Node createNode(ResourceResolver resolver, String path, String nodeType) throws IndexServiceException {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        try {
            Node root = ((Session)resolver.adaptTo(Session.class)).getRootNode();
            StringTokenizer names = new StringTokenizer(Text.getRelativeParent((String)path, (int)1), "/");
            while (names.hasMoreTokens()) {
                String name = names.nextToken();
                if (!root.hasNode(name)) {
                    root.addNode(name);
                }
                root = root.getNode(name);
            }
            return root.addNode(Text.getName((String)path), nodeType);
        }
        catch (Exception e) {
            throw new IndexServiceException("failed to create node", e);
        }
    }
}

