/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.storage.index.impl;

import com.adobe.cq.social.storage.index.IndexHandler;
import com.adobe.cq.social.storage.index.IndexHandlerCollection;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.resource.JcrResourceResolverFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexService
implements EventHandler {
    private static final Logger log = LoggerFactory.getLogger(IndexService.class);
    private SlingRepository repository;
    private JcrResourceResolverFactory resolverFactory;
    private volatile Session adminSession;
    private static final int MAX_TRIES = 2;
    private static boolean isMaster;
    private IndexHandlerCollection indexHandlers;

    public void handleEvent(Event event) {
        if (!isMaster) {
            return;
        }
        String resourceType = (String)event.getProperty("resourceType");
        String eventTopics = (String)event.getProperty("event.topics");
        String nodePath = (String)event.getProperty("path");
        if (eventTopics == null || nodePath == null) {
            return;
        }
        if (nodePath.indexOf("jcr:content") == -1) {
            return;
        }
        Session session = this.getSession();
        if (session != null) {
            for (int i = 0; i < 2; ++i) {
                try {
                    ResourceResolver resolver = this.resolverFactory.getResourceResolver(session);
                    for (IndexHandler handler : this.indexHandlers.getIndexHandlers()) {
                        handler.handleEvent(resolver, resourceType, eventTopics, nodePath, (String[])event.getProperty("resourceChangedAttributes"), (String[])event.getProperty("resourceAddedAttributes"), (String[])event.getProperty("resourceRemovedAttributes"));
                    }
                    return;
                }
                catch (Exception e) {
                    log.error("Error occured while processing event", (Throwable)e);
                    continue;
                }
            }
        }
    }

    protected synchronized Session getSession() {
        if (this.adminSession == null || !this.adminSession.isLive()) {
            try {
                this.adminSession = this.repository.loginAdministrative(null);
            }
            catch (RepositoryException e) {
                log.error("Error while obtaining admin session");
            }
        }
        return this.adminSession;
    }

    protected synchronized void activate(ComponentContext context) throws RepositoryException {
        if (this.repository == null) {
            throw new RepositoryException("Unsatisfied Reference to SlingRepository");
        }
        this.adminSession = this.repository.loginAdministrative(null);
        String value = this.repository.getDescriptor("crx.cluster.master");
        isMaster = "true".equals(value);
    }

    protected synchronized void deactivate(ComponentContext context) {
        if (this.adminSession != null) {
            this.adminSession.logout();
            this.adminSession = null;
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    protected void bindResolverFactory(JcrResourceResolverFactory jcrResourceResolverFactory) {
        this.resolverFactory = jcrResourceResolverFactory;
    }

    protected void unbindResolverFactory(JcrResourceResolverFactory jcrResourceResolverFactory) {
        if (this.resolverFactory == jcrResourceResolverFactory) {
            this.resolverFactory = null;
        }
    }

    protected void bindIndexHandlers(IndexHandlerCollection indexHandlerCollection) {
        this.indexHandlers = indexHandlerCollection;
    }

    protected void unbindIndexHandlers(IndexHandlerCollection indexHandlerCollection) {
        if (this.indexHandlers == indexHandlerCollection) {
            this.indexHandlers = null;
        }
    }
}

