/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.sc.lucene;

import com.adobe.cq.social.sc.lucene.LuceneQueryFactory;
import com.adobe.cq.social.ugc.api.SearchResults;
import com.day.crx.sc.qom.AbstractQueryObjectModel;
import com.day.crx.sc.qom.ConstraintSplitter;
import com.day.crx.sc.qom.Constraints;
import com.day.crx.sc.qom.JoinMerger;
import com.day.crx.sc.qom.OperandEvaluator;
import com.day.crx.sc.qom.RowComparator;
import com.day.crx.sc.qom.SimpleQueryResult;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import javax.jcr.query.qom.Column;
import javax.jcr.query.qom.Constraint;
import javax.jcr.query.qom.Join;
import javax.jcr.query.qom.Ordering;
import javax.jcr.query.qom.PropertyValue;
import javax.jcr.query.qom.QueryObjectModelFactory;
import javax.jcr.query.qom.Selector;
import javax.jcr.query.qom.Source;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.jackrabbit.commons.iterator.RowIteratorAdapter;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.store.Directory;

class QueryObjectModelImpl
extends AbstractQueryObjectModel {
    private final Directory directory;
    private final Analyzer analyzer;
    private final Session session;
    private final QueryObjectModelFactory factory;

    public QueryObjectModelImpl(Directory directory, Analyzer analyzer, Session session, QueryObjectModelFactory factory, Source source, Constraint constraint, Ordering[] orderings, Column[] columns) {
        super(source, constraint, orderings, columns);
        this.directory = directory;
        this.analyzer = analyzer;
        this.session = session;
        this.factory = factory;
    }

    public QueryResult execute() throws InvalidQueryException, RepositoryException {
        HashMap<String, Value> variables = new HashMap<String, Value>();
        for (String name : this.getBindVariableNames()) {
            variables.put(name, this.getBindValue(name));
        }
        OperandEvaluator evaluator = new OperandEvaluator(this.session.getValueFactory(), variables);
        Source source = this.getSource();
        if (source instanceof Selector) {
            Selector selector = (Selector)source;
            LuceneQueryFactory lqf = new LuceneQueryFactory(this.directory, this.analyzer, this.session, variables);
            return this.executeSelector(selector, lqf, evaluator);
        }
        if (source instanceof Join) {
            Join join = (Join)source;
            if (join.getJoinType() == "jcr.join.type.right.outer") {
                join = this.factory.join(join.getRight(), join.getLeft(), "jcr.join.type.left.outer", join.getJoinCondition());
            }
            return this.executeJoin(join, evaluator);
        }
        throw new UnsupportedRepositoryOperationException("Unknown source type: " + source);
    }

    protected QueryResult executeSelector(Selector selector, LuceneQueryFactory lqf, OperandEvaluator evaluator) throws RepositoryException {
        Map<String, NodeType> selectorMap = this.getSelectorNames((Source)selector);
        String[] selectorNames = selectorMap.keySet().toArray(new String[selectorMap.size()]);
        Map<String, PropertyValue> columnMap = this.getColumnMap(selectorMap);
        String[] columnNames = columnMap.keySet().toArray(new String[columnMap.size()]);
        try {
            long offset = this.getOffset();
            long limit = this.getLimit();
            SearchResults<Row> results = lqf.execute(columnMap, selector, this.getConstraint(), this.getOrderings(), offset, limit);
            RowIteratorAdapter rows = new RowIteratorAdapter(results.getResults());
            SimpleQueryResult result = new SimpleQueryResult(columnNames, selectorNames, (RowIterator)rows, results.getTotalNumberOfResults());
            return result;
        }
        catch (IOException e) {
            throw new RepositoryException("Failed to access the query index", (Throwable)e);
        }
    }

    private QueryResult executeJoin(Join join, OperandEvaluator evaluator) throws RepositoryException {
        RowIteratorAdapter rightRows;
        JoinMerger merger = JoinMerger.getJoinMerger(join, this.getColumnMap(this.getSelectorNames((Source)join)), evaluator, this.factory);
        ConstraintSplitter splitter = new ConstraintSplitter(this.getConstraint(), this.factory, merger.getLeftSelectors(), merger.getRightSelectors());
        Source left = join.getLeft();
        Constraint leftConstraint = splitter.getLeftConstraint();
        QueryResult leftResult = this.factory.createQuery(left, leftConstraint, null, null).execute();
        ArrayList<Row> leftRows = new ArrayList<Row>();
        for (Row row : JcrUtils.getRows((QueryResult)leftResult)) {
            leftRows.add(row);
        }
        Source right = join.getRight();
        List<Constraint> rightConstraints = merger.getRightJoinConstraints(leftRows);
        if (rightConstraints.size() < 500) {
            Constraint rightConstraint = Constraints.and(this.factory, Constraints.or(this.factory, rightConstraints), splitter.getRightConstraint());
            rightRows = this.factory.createQuery(right, rightConstraint, null, null).execute().getRows();
        } else {
            ArrayList<Row> list = new ArrayList<Row>();
            for (int i = 0; i < rightConstraints.size(); i += 500) {
                Constraint rightConstraint = Constraints.and(this.factory, Constraints.or(this.factory, rightConstraints.subList(i, Math.min(i + 500, rightConstraints.size()))), splitter.getRightConstraint());
                QueryResult rigthResult = this.factory.createQuery(right, rightConstraint, null, null).execute();
                for (Row row : JcrUtils.getRows((QueryResult)rigthResult)) {
                    list.add(row);
                }
            }
            rightRows = new RowIteratorAdapter(list);
        }
        QueryResult result = merger.merge((RowIterator)new RowIteratorAdapter(leftRows), (RowIterator)rightRows);
        return result;
    }

    private Map<String, PropertyValue> getColumnMap(Map<String, NodeType> selectors) throws RepositoryException {
        LinkedHashMap<String, PropertyValue> map = new LinkedHashMap<String, PropertyValue>();
        Column[] columns = this.getColumns();
        if (columns != null && columns.length > 0) {
            for (int i = 0; i < columns.length; ++i) {
                String name = columns[i].getColumnName();
                if (name != null) {
                    map.put(name, this.factory.propertyValue(columns[i].getSelectorName(), columns[i].getPropertyName()));
                    continue;
                }
                String selector = columns[i].getSelectorName();
                map.putAll(this.getColumnMap(selector, selectors.get(selector)));
            }
        } else {
            for (Map.Entry<String, NodeType> selector : selectors.entrySet()) {
                map.putAll(this.getColumnMap(selector.getKey(), selector.getValue()));
            }
        }
        return map;
    }

    private Map<String, PropertyValue> getColumnMap(String selector, NodeType type) throws RepositoryException {
        LinkedHashMap<String, PropertyValue> map = new LinkedHashMap<String, PropertyValue>();
        for (PropertyDefinition definition : type.getPropertyDefinitions()) {
            String name = definition.getName();
            if (definition.isMultiple() || "*".equals(name)) continue;
            map.put(selector + "." + name, this.factory.propertyValue(selector, name));
        }
        return map;
    }

    private Map<String, NodeType> getSelectorNames(Source source) throws RepositoryException {
        if (source instanceof Selector) {
            Selector selector = (Selector)source;
            return Collections.singletonMap(selector.getSelectorName(), this.getNodeType(selector));
        }
        if (source instanceof Join) {
            Join join = (Join)source;
            LinkedHashMap<String, NodeType> map = new LinkedHashMap<String, NodeType>();
            map.putAll(this.getSelectorNames(join.getLeft()));
            map.putAll(this.getSelectorNames(join.getRight()));
            return map;
        }
        throw new UnsupportedRepositoryOperationException("Unknown source type: " + source);
    }

    private NodeType getNodeType(Selector selector) throws RepositoryException {
        try {
            return this.session.getWorkspace().getNodeTypeManager().getNodeType(selector.getNodeTypeName());
        }
        catch (NoSuchNodeTypeException e) {
            throw new InvalidQueryException("Selected node type does not exist: " + selector, (Throwable)e);
        }
    }

    public QueryResult sort(QueryResult result, OperandEvaluator evaluator) throws RepositoryException {
        Ordering[] orderings = this.getOrderings();
        long offset = this.getOffset();
        long limit = this.getLimit();
        if (orderings != null && orderings.length > 0 || offset != 0L || limit >= 0L) {
            int size;
            List<Object> rows = new ArrayList<Row>();
            RowIterator iterator = result.getRows();
            while (iterator.hasNext()) {
                rows.add(iterator.nextRow());
            }
            if (orderings != null && orderings.length > 0) {
                Collections.sort(rows, new RowComparator(orderings, evaluator));
            }
            long totalNumberOfResults = rows.size();
            if (offset > 0L) {
                size = rows.size();
                rows = rows.subList((int)Math.min(offset, (long)size), size);
            }
            if (limit >= 0L) {
                size = rows.size();
                rows = rows.subList(0, (int)Math.min(limit, (long)size));
            }
            return new SimpleQueryResult(result.getColumnNames(), result.getSelectorNames(), (RowIterator)new RowIteratorAdapter(rows), totalNumberOfResults);
        }
        return result;
    }
}

