/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.ugc.impl;

import com.adobe.cq.social.sc.lucene.LuceneSearchCollection;
import com.adobe.cq.social.ugc.api.Constraint;
import com.adobe.cq.social.ugc.api.ConstraintGroup;
import com.adobe.cq.social.ugc.api.ConstraintVisitor;
import com.adobe.cq.social.ugc.api.DefaultConstraintVisitor;
import com.adobe.cq.social.ugc.api.FullTextConstraint;
import com.adobe.cq.social.ugc.api.PathConstraint;
import com.adobe.cq.social.ugc.api.RangeConstraint;
import com.adobe.cq.social.ugc.api.RelatedSearch;
import com.adobe.cq.social.ugc.api.SearchResults;
import com.adobe.cq.social.ugc.api.SetConstraint;
import com.adobe.cq.social.ugc.api.UgcFilter;
import com.adobe.cq.social.ugc.api.UgcFilterQueryWriter;
import com.adobe.cq.social.ugc.api.UgcIndexerUtil;
import com.adobe.cq.social.ugc.api.UgcNodeIndexerExtension;
import com.adobe.cq.social.ugc.api.UgcSearch;
import com.adobe.cq.social.ugc.api.ValueConstraint;
import com.adobe.cq.social.ugc.impl.ListSearchResults;
import com.adobe.cq.social.ugc.impl.UgcNodeIndexer;
import com.adobe.cq.social.ugc.impl.UserGeneratedContentVisitor;
import com.day.crx.sc.api.SearchCollection;
import com.day.crx.sc.api.SearchUpdater;
import com.day.crx.sc.qom.SimpleQueryResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.jcr.ItemVisitor;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.ObservationManager;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.launchpad.api.StartupListener;
import org.apache.sling.launchpad.api.StartupMode;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service(value={UgcSearch.class, RelatedSearch.class, StartupListener.class})
@Component(immediate=true)
@Properties(value={@Property(name="id", value={"ugc-sc"})})
@Reference(name="extensionProvider", referenceInterface=UgcNodeIndexerExtension.class, bind="bindExtension", unbind="unbindExtension", cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC)
public class LuceneUgcSearch
implements UgcSearch,
SearchCollection,
RelatedSearch,
StartupListener {
    private static final Logger LOG = LoggerFactory.getLogger(LuceneUgcSearch.class);
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference(policy=ReferencePolicy.STATIC, bind="bind", unbind="unbind")
    private SlingRepository repository;
    private Session adminSession;
    private final Map<String, LuceneSearchCollection> luceneSCs;
    private final List<UgcNodeIndexerExtension> extensionsToInit;
    private final Map<String, Collection<SearchUpdater>> searchUpdaters = new ConcurrentHashMap<String, Collection<SearchUpdater>>();
    private volatile boolean startupFinished = false;

    public LuceneUgcSearch() {
        this.luceneSCs = new HashMap<String, LuceneSearchCollection>();
        this.extensionsToInit = new LinkedList<UgcNodeIndexerExtension>();
    }

    @Activate
    private void activate(ComponentContext ctx) throws RepositoryException {
        this.adminSession = this.repository.loginAdministrative(null);
    }

    public void inform(StartupMode startupMode, boolean finished) {
        if (finished) {
            this.startupFinished(startupMode);
        }
    }

    public void startupFinished(StartupMode startupMode) {
        LOG.info("activating {} extensions after startup complete", (Object)this.extensionsToInit.size());
        for (UgcNodeIndexerExtension extension : this.extensionsToInit) {
            try {
                this.initSearchCollection(extension);
            }
            catch (RepositoryException e) {
                LOG.error("failed to init extension", (Throwable)e);
            }
        }
        this.extensionsToInit.clear();
        this.startupFinished = true;
    }

    public void startupProgress(float ratio) {
    }

    @Deactivate
    private void deactivate(ComponentContext ctx) {
        for (LuceneSearchCollection luceneSC : this.luceneSCs.values()) {
            luceneSC.stop();
        }
        if (this.adminSession != null && this.adminSession.isLive()) {
            this.adminSession.logout();
            this.adminSession = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSearchCollection(UgcNodeIndexerExtension extension) throws RepositoryException {
        Object object = LuceneSearchCollection.writeSync;
        synchronized (object) {
            Node parentNode;
            Node configNode = null;
            String name = extension.getName();
            boolean supportFacetedSearch = extension.suppportFacetedSearch();
            Node taxNode = null;
            if (this.adminSession.nodeExists("/var/search-collections")) {
                if (this.adminSession.nodeExists("/var/search-collections/" + name)) {
                    configNode = this.adminSession.getNode("/var/search-collections/" + name);
                } else {
                    Node parentNode2 = this.adminSession.getNode("/var/search-collections");
                    configNode = parentNode2.addNode(name, "{http://www.jcp.org/jcr/nt/1.0}unstructured");
                    configNode.addMixin("mix:lockable");
                    configNode.setProperty("includes", extension.getIncludePaths());
                    this.adminSession.save();
                }
            } else {
                Node etcNode = this.adminSession.getNode("/var");
                parentNode = etcNode.addNode("search-collections", "{http://www.jcp.org/jcr/nt/1.0}unstructured");
                configNode = parentNode.addNode(name, "{http://www.jcp.org/jcr/nt/1.0}unstructured");
                configNode.addMixin("mix:lockable");
                configNode.setProperty("includes", extension.getIncludePaths());
                this.adminSession.save();
            }
            if (supportFacetedSearch) {
                String taxPath = "/var/search-collections/" + name + "taxo";
                if (this.adminSession.nodeExists(taxPath)) {
                    taxNode = this.adminSession.getNode(taxPath);
                } else {
                    parentNode = this.adminSession.getNode("/var/search-collections");
                    taxNode = parentNode.addNode(name + "taxo", "{http://www.jcp.org/jcr/nt/1.0}unstructured");
                    configNode.addMixin("mix:lockable");
                    taxNode.setProperty("includes", extension.getIncludePaths());
                    this.adminSession.save();
                }
            }
            UgcNodeIndexer nodeIndexer = new UgcNodeIndexer(this.resourceResolverFactory, extension);
            LuceneSearchCollection ugcSearch = new LuceneSearchCollection(configNode, taxNode, nodeIndexer, false);
            this.luceneSCs.put(extension.getName(), ugcSearch);
            String[] includesPaths = extension.getIncludePaths().split(",");
            String[] primaryTypes = extension.getPrimaryTypes();
            for (int i = 0; i < primaryTypes.length; ++i) {
                String nodeType = primaryTypes[i];
                if (!configNode.hasNodes()) {
                    UserGeneratedContentVisitor ugcVisitor = new UserGeneratedContentVisitor(nodeType);
                    for (String include : includesPaths) {
                        String includeString = include.trim();
                        if (!this.adminSession.nodeExists(includeString)) continue;
                        Node rootNode = this.adminSession.getNode(includeString);
                        rootNode.accept((ItemVisitor)ugcVisitor);
                    }
                    Set<String> paths = ugcVisitor.getPaths();
                    this.update(paths);
                }
                for (String include : includesPaths) {
                    if (extension.isEnabled()) {
                        this.addUpdatersForExtension(ugcSearch, extension, include, nodeType);
                        continue;
                    }
                    LOG.info("skipping disabled extension {}", (Object)extension.getName());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindExtension(UgcNodeIndexerExtension extension) {
        block6: {
            try {
                if (this.startupFinished) {
                    this.initSearchCollection(extension);
                    break block6;
                }
                List<UgcNodeIndexerExtension> list = this.extensionsToInit;
                synchronized (list) {
                    this.extensionsToInit.add(extension);
                }
            }
            catch (RepositoryException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void unbindExtension(UgcNodeIndexerExtension extension) {
        this.luceneSCs.remove(extension.getName());
        this.removeUpdatersForExtension(extension);
    }

    protected void bind(SlingRepository rep) {
        this.repository = rep;
    }

    protected void unbind(SlingRepository rep) {
        this.repository = null;
    }

    @Override
    public int getIndex(String scName, Session session, UgcFilter listing, String targetPath, long added) throws RepositoryException {
        SearchResults<Node> results = this.find(scName, session, listing, 0, 1);
        int start = 0;
        int end = (int)results.getTotalNumberOfResults();
        while (start <= end) {
            int mid = (end + start) / 2;
            results = this.find(scName, session, listing, mid, 1);
            if (results.getResults().size() != 1) {
                return -1;
            }
            Node target = results.getResults().get(0);
            if (target.getPath().equals(targetPath)) {
                return mid;
            }
            if (target.getProperty("added").getDate().getTime().getTime() > added) {
                end = mid - 1;
                continue;
            }
            start = mid + 1;
        }
        return -1;
    }

    @Override
    public List<String> findMLT(String scName, String target, String resourceTypeFilter, String componentFilter, String statusFilter, String[] mltFields, int maxResults, int minTermFreq, int minDocFreq) throws RepositoryException {
        return this.luceneSCs.get(scName).findMLT(target, resourceTypeFilter, componentFilter, statusFilter, mltFields, maxResults, minTermFreq, minDocFreq);
    }

    @Override
    public List<String> findMLT(String scName, String target, String resourceTypeFilter, String componentFilter, String[] mltFields, int maxResults, int minTermFreq, int minDocFreq) throws RepositoryException {
        return this.findMLT(scName, target, resourceTypeFilter, componentFilter, null, mltFields, maxResults, minTermFreq, minDocFreq);
    }

    @Override
    public Map<String, Integer> findFacets(String scName, String fieldName, String parentFilter, String componentFilter, int count) throws RepositoryException {
        return this.luceneSCs.get(scName).findFacets(fieldName, parentFilter, componentFilter, count);
    }

    @Override
    public SearchResults<Node> find(String scName, Session session, UgcFilter filter, int offset, int limit) throws RepositoryException {
        filter.accept(new VariableHandler(filter));
        UgcFilterQueryWriter queryWriter = new UgcFilterQueryWriter();
        String statement = queryWriter.write(filter);
        Query query = this.createQuery(scName, session, statement, "JCR-SQL2");
        if (offset > 0) {
            query.setOffset((long)offset);
        }
        if (limit > 0) {
            query.setLimit((long)limit);
        }
        if (filter.hasVariables()) {
            Map<String, Object> variables = filter.getVariables();
            ValueFactory vf = session.getValueFactory();
            for (Map.Entry<String, Object> variable : variables.entrySet()) {
                Object value = variable.getValue();
                Value val = value instanceof Integer ? vf.createValue((long)((Integer)value).intValue()) : (value instanceof Boolean ? vf.createValue(((Boolean)value).booleanValue()) : (value instanceof Double ? vf.createValue(((Double)value).doubleValue()) : (value instanceof Long ? vf.createValue(((Long)value).longValue()) : vf.createValue(variable.getValue().toString()))));
                query.bindValue(variable.getKey(), val);
            }
        }
        QueryResult result = query.execute();
        ArrayList<Node> nodes = new ArrayList<Node>();
        NodeIterator nodeIterator = result.getNodes();
        while (nodeIterator.hasNext()) {
            Node node = nodeIterator.nextNode();
            nodes.add(node);
        }
        return new ListSearchResults<Node>(nodes, ((SimpleQueryResult)result).getTotalNumberOfResults());
    }

    @Override
    public SearchResults<Resource> find(String scName, ResourceResolver resolver, UgcFilter filter, int offset, int limit) throws RepositoryException {
        ArrayList<Resource> resourceList = new ArrayList<Resource>();
        Session session = (Session)resolver.adaptTo(Session.class);
        SearchResults<Node> srn = this.find(scName, session, filter, offset, limit);
        List<Node> nodes = srn.getResults();
        for (Node node : nodes) {
            Resource resultResource = resolver.getResource(node.getPath());
            if (null == resultResource) continue;
            resourceList.add(resultResource);
        }
        return new ListSearchResults<Resource>(resourceList, srn.getTotalNumberOfResults());
    }

    public Query createQuery(String scName, Session session, String statement, String language) throws RepositoryException {
        return this.luceneSCs.get(scName).createQuery(session, statement, language);
    }

    @Override
    @Deprecated
    public Query createQuery(Session session, String statement, String language) throws RepositoryException {
        return null;
    }

    @Override
    public void run() {
        for (LuceneSearchCollection luceneSC : this.luceneSCs.values()) {
            luceneSC.run();
        }
    }

    @Override
    public void stop() {
        for (LuceneSearchCollection luceneSC : this.luceneSCs.values()) {
            luceneSC.stop();
        }
    }

    @Override
    public void update(Set<String> paths) {
        for (LuceneSearchCollection luceneSC : this.luceneSCs.values()) {
            luceneSC.update(paths);
        }
    }

    private void addUpdatersForExtension(SearchCollection sc, UgcNodeIndexerExtension extension, String include, String nodeType) {
        SearchUpdater addOrModifyupdater = new SearchUpdater(sc, extension);
        SearchUpdater deleteUpdater = new SearchUpdater(sc, extension);
        Collection<SearchUpdater> extensionUpdaters = this.searchUpdaters.get(extension.getName());
        if (extensionUpdaters == null) {
            extensionUpdaters = new ArrayList<SearchUpdater>();
            this.searchUpdaters.put(extension.getName(), extensionUpdaters);
        }
        extensionUpdaters.add(addOrModifyupdater);
        extensionUpdaters.add(deleteUpdater);
        try {
            String[] stringArray;
            ObservationManager observationManager = this.adminSession.getWorkspace().getObservationManager();
            if (nodeType == null) {
                stringArray = null;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = nodeType;
            }
            observationManager.addEventListener((EventListener)addOrModifyupdater, 61, include, true, null, stringArray, true);
            observationManager.addEventListener((EventListener)deleteUpdater, 2, include, true, null, null, true);
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    private synchronized void removeUpdatersForExtension(UgcNodeIndexerExtension extension) {
        try {
            ObservationManager observationManager = this.adminSession.getWorkspace().getObservationManager();
            Collection<SearchUpdater> updaters = this.searchUpdaters.remove(extension.getName());
            if (updaters != null) {
                for (SearchUpdater updater : updaters) {
                    observationManager.removeEventListener((EventListener)updater);
                }
            } else {
                LOG.info("no search updaters for extension:{}", (Object)extension.getName());
            }
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    private static class VariableHandler
    extends DefaultConstraintVisitor
    implements ConstraintVisitor {
        private static final char VARIABLE_CHAR = '$';
        private int varCount;
        private final UgcFilter ugcFilter;

        public VariableHandler(UgcFilter ugcFilter) {
            this.ugcFilter = ugcFilter;
        }

        @Override
        public void visitFullTextConstraint(FullTextConstraint fullTextConstraint) {
        }

        @Override
        public void visitPathConstraint(PathConstraint pathConstraint) {
        }

        public void visitValueConstraint(ValueConstraint valueConstraint) {
            Object value = valueConstraint.getValue();
            if (!this.isVariable(value)) {
                String varName = this.createVariable(value);
                valueConstraint.setValue(varName);
            }
        }

        @Override
        public void visitConstraintGroup(ConstraintGroup constraintGroup) {
            if (constraintGroup.hasConstraints()) {
                Collection<Constraint> constraints = constraintGroup.getConstraints();
                for (Constraint constraint : constraints) {
                    constraint.accept(this);
                }
            }
        }

        public void visitSetConstraint(SetConstraint setConstraint) {
            for (int i = 0; i < setConstraint.size(); ++i) {
                Object item = setConstraint.get(i);
                if (this.isVariable(item)) continue;
                String itemVarName = this.createVariable(item);
                setConstraint.set(i, itemVarName);
            }
        }

        public void visitRangeConstraint(RangeConstraint rangeConstraint) {
            Object minValue = rangeConstraint.getMinValue();
            Object maxValue = rangeConstraint.getMaxValue();
            if (!this.isVariable(minValue)) {
                String minVarName = this.createVariable(minValue);
                rangeConstraint.setMinValue(minVarName);
            }
            if (!this.isVariable(maxValue)) {
                String maxVarName = this.createVariable(maxValue);
                rangeConstraint.setMaxValue(maxVarName);
            }
        }

        protected String createVariable(Object value) {
            String varName = "_" + this.varCount;
            if (value instanceof Date) {
                this.ugcFilter.setVariableValue(varName, UgcIndexerUtil.dateToString((Date)value));
            } else {
                this.ugcFilter.setVariableValue(varName, value);
            }
            ++this.varCount;
            return '$' + varName;
        }

        protected boolean isVariable(Object value) {
            return value instanceof String && ((String)value).charAt(0) == '$';
        }
    }
}

