/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.sc.api;

import com.adobe.cq.social.ugc.api.UgcNodeIndexerExtension;
import com.day.crx.sc.api.SearchCollection;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import org.apache.jackrabbit.api.observation.JackrabbitEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchUpdater
implements EventListener {
    private static final Logger log = LoggerFactory.getLogger(SearchUpdater.class);
    private final SearchCollection collection;
    private final UgcNodeIndexerExtension indexerExtension;

    public SearchUpdater(SearchCollection collection) {
        this(collection, null);
    }

    public SearchUpdater(SearchCollection collection, UgcNodeIndexerExtension indexerExtension) {
        this.collection = collection;
        this.indexerExtension = indexerExtension;
    }

    public void onEvent(EventIterator events) {
        LinkedHashSet<String> paths = new LinkedHashSet<String>();
        while (events.hasNext()) {
            Event event = events.nextEvent();
            try {
                if (event instanceof JackrabbitEvent && ((JackrabbitEvent)event).isExternal()) {
                    log.debug("skipping external event for {}", (Object)event.getPath());
                    continue;
                }
                if (!this.eventRequiresReindex(event)) continue;
                String path = event.getPath();
                switch (event.getType()) {
                    case 1: 
                    case 2: {
                        paths.add(path);
                        break;
                    }
                    case 32: {
                        Map info = event.getInfo();
                        if (info.containsKey("srcAbsPath")) {
                            paths.add(info.get("srcAbsPath").toString());
                        }
                        if (!info.containsKey("destAbsPath")) break;
                        paths.add(info.get("destAbsPath").toString());
                        break;
                    }
                    case 4: 
                    case 8: 
                    case 16: {
                        int slash = path.lastIndexOf(47);
                        if (slash > 0) {
                            paths.add(path.substring(0, slash));
                            break;
                        }
                        paths.add("/");
                    }
                }
            }
            catch (RepositoryException e) {
                log.warn("Ignoring a broken observation event: " + event, (Throwable)e);
            }
        }
        if (paths.size() > 0) {
            log.debug("collection.update call with {} paths", paths);
            this.collection.update(paths);
        }
    }

    private boolean eventRequiresReindex(Event eventToCheck) {
        boolean requiresReindex = null == this.indexerExtension ? true : this.indexerExtension.checkEventModifiesIndex(eventToCheck);
        return requiresReindex;
    }
}

