/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.sc.qom;

import com.day.crx.sc.qom.AbstractRow;
import com.day.crx.sc.qom.OperandEvaluator;
import java.util.Map;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.query.Row;
import javax.jcr.query.qom.PropertyValue;

public class JoinRow
extends AbstractRow {
    private final Row leftRow;
    private final Set<String> leftSelectors;
    private final Row rightRow;
    private final Set<String> rightSelectors;

    public JoinRow(Map<String, PropertyValue> columns, OperandEvaluator evaluator, Row leftRow, Set<String> leftSelectors, Row rightRow, Set<String> rightSelectors) {
        super(columns, evaluator);
        this.leftRow = leftRow;
        this.leftSelectors = leftSelectors;
        this.rightRow = rightRow;
        this.rightSelectors = rightSelectors;
    }

    public Node getNode() throws RepositoryException {
        throw new RepositoryException();
    }

    public Node getNode(String selectorName) throws RepositoryException {
        Row row = this.getRow(selectorName);
        if (row != null) {
            return row.getNode(selectorName);
        }
        return null;
    }

    public double getScore() throws RepositoryException {
        throw new RepositoryException();
    }

    public double getScore(String selectorName) throws RepositoryException {
        Row row = this.getRow(selectorName);
        if (row != null) {
            return row.getScore(selectorName);
        }
        return 0.0;
    }

    private Row getRow(String selector) throws RepositoryException {
        if (this.leftSelectors.contains(selector)) {
            return this.leftRow;
        }
        if (this.rightSelectors.contains(selector)) {
            return this.rightRow;
        }
        throw new RepositoryException("Selector " + selector + " is not included in this row");
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{ ");
        for (String selector : this.leftSelectors) {
            builder.append(selector);
            builder.append("=");
            try {
                builder.append(this.leftRow.getNode(selector));
            }
            catch (RepositoryException e) {
                builder.append(e.getMessage());
            }
            builder.append(" ");
        }
        for (String selector : this.rightSelectors) {
            builder.append(selector);
            builder.append("=");
            try {
                builder.append(this.rightRow.getNode(selector));
            }
            catch (RepositoryException e) {
                builder.append(e.getMessage());
            }
            builder.append(" ");
        }
        builder.append("}");
        return builder.toString();
    }
}

