/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.sc.lucene;

import com.adobe.cq.social.sc.lucene.DateField;
import com.adobe.cq.social.sc.lucene.DecimalField;
import com.adobe.cq.social.sc.lucene.DoubleField;
import com.adobe.cq.social.sc.lucene.LongField;
import com.adobe.cq.social.sc.lucene.SubtreeQuery;
import com.adobe.cq.social.ugc.api.SearchResults;
import com.adobe.cq.social.ugc.impl.ListSearchResults;
import com.day.crx.sc.qom.OperandEvaluator;
import com.day.crx.sc.qom.SelectorRow;
import com.day.crx.sc.qom.ValueComparator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.Row;
import javax.jcr.query.qom.And;
import javax.jcr.query.qom.ChildNode;
import javax.jcr.query.qom.Comparison;
import javax.jcr.query.qom.Constraint;
import javax.jcr.query.qom.DescendantNode;
import javax.jcr.query.qom.DynamicOperand;
import javax.jcr.query.qom.FullTextSearch;
import javax.jcr.query.qom.FullTextSearchScore;
import javax.jcr.query.qom.Length;
import javax.jcr.query.qom.LowerCase;
import javax.jcr.query.qom.NodeLocalName;
import javax.jcr.query.qom.NodeName;
import javax.jcr.query.qom.Not;
import javax.jcr.query.qom.Operand;
import javax.jcr.query.qom.Or;
import javax.jcr.query.qom.Ordering;
import javax.jcr.query.qom.PropertyExistence;
import javax.jcr.query.qom.PropertyValue;
import javax.jcr.query.qom.SameNode;
import javax.jcr.query.qom.Selector;
import javax.jcr.query.qom.StaticOperand;
import javax.jcr.query.qom.UpperCase;
import org.apache.jackrabbit.commons.predicate.Predicate;
import org.apache.jackrabbit.commons.predicate.Predicates;
import org.apache.jackrabbit.commons.predicate.RowPredicate;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuceneQueryFactory {
    private static final boolean ASCENDING = false;
    private static final boolean DESCENDING = true;
    private final Directory directory;
    private final Analyzer analyzer;
    private final Session session;
    private final NodeTypeManager ntManager;
    private final OperandEvaluator evaluator;

    public LuceneQueryFactory(Directory directory, Analyzer analyzer, Session session, Map<String, Value> bindVariables) throws RepositoryException {
        this.directory = directory;
        this.analyzer = analyzer;
        this.session = session;
        this.ntManager = session.getWorkspace().getNodeTypeManager();
        this.evaluator = new OperandEvaluator(session.getValueFactory(), bindVariables);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SearchResults<Row> execute(Map<String, PropertyValue> columns, Selector selector, Constraint constraint, Ordering[] orderings, long offset, long maxResults) throws RepositoryException, IOException {
        int totalNumberOfResults;
        Predicate filter = Predicate.TRUE;
        BooleanQuery query = new BooleanQuery();
        query.add(this.create(selector), BooleanClause.Occur.MUST);
        if (constraint != null) {
            String name = selector.getSelectorName();
            NodeType type = this.ntManager.getNodeType(selector.getNodeTypeName());
            filter = this.mapConstraintToQueryAndFilter(query, constraint, Collections.singletonMap(name, type));
        }
        ArrayList<SelectorRow> rows = new ArrayList<SelectorRow>();
        IndexSearcher searcher = new IndexSearcher(this.directory);
        try {
            int numResults;
            Sort sort = null;
            if (null != orderings) {
                ArrayList<SortField> sortFields = new ArrayList<SortField>();
                for (Ordering ordering : orderings) {
                    DynamicOperand operand = ordering.getOperand();
                    if (!(operand instanceof PropertyValue)) continue;
                    PropertyValue propertyValue = (PropertyValue)operand;
                    if ("jcr.order.ascending".equals(ordering.getOrder())) {
                        sortFields.add(new SortField(propertyValue.getPropertyName(), 3, false));
                        continue;
                    }
                    sortFields.add(new SortField(propertyValue.getPropertyName(), 3, true));
                }
                if (sortFields.size() > 0) {
                    sort = new Sort(sortFields.toArray(new SortField[0]));
                }
            }
            if ((numResults = (int)(offset + maxResults)) < 0) {
                numResults = Integer.MAX_VALUE;
            }
            int offsetInt = (int)offset;
            if (offset < 1L) {
                offsetInt = 0;
            }
            Object hits = null == sort ? searcher.search((Query)query, numResults) : searcher.search((Query)query, null, numResults, sort);
            ScoreDoc[] docs = hits.scoreDocs;
            int resultSize = Math.min(numResults, docs.length);
            for (int i = offsetInt; i < resultSize; ++i) {
                SelectorRow row;
                ScoreDoc doc = docs[i];
                String path = searcher.doc(doc.doc).get(":path");
                Node n = null;
                try {
                    n = this.session.getNode(path);
                }
                catch (ItemNotFoundException e) {
                }
                catch (PathNotFoundException e) {
                    // empty catch block
                }
                if (n == null || !filter.evaluate((Object)(row = new SelectorRow(columns, this.evaluator, selector.getSelectorName(), n, doc.score)))) continue;
                rows.add(row);
            }
            totalNumberOfResults = hits.totalHits;
        }
        finally {
            searcher.close();
        }
        return new ListSearchResults<Row>(rows, totalNumberOfResults);
    }

    public Query create(Selector selector) throws RepositoryException {
        ArrayList<Term> terms = new ArrayList<Term>();
        String name = selector.getNodeTypeName();
        NodeTypeIterator allTypes = this.ntManager.getAllNodeTypes();
        while (allTypes.hasNext()) {
            NodeType nt = allTypes.nextNodeType();
            if (!nt.isNodeType(name)) continue;
            terms.add(this.createNodeTypeTerm(nt));
        }
        if (terms.size() == 1) {
            return new TermQuery((Term)terms.get(0));
        }
        BooleanQuery b = new BooleanQuery();
        for (Term term : terms) {
            b.add((Query)new TermQuery(term), BooleanClause.Occur.SHOULD);
        }
        return b;
    }

    protected Term createNodeTypeTerm(NodeType type) throws RepositoryException {
        if (type.isMixin()) {
            return new Term("jcr:mixinTypes", type.getName());
        }
        return new Term("jcr:primaryType", type.getName());
    }

    public Query create(FullTextSearch fts) throws RepositoryException {
        String field = fts.getPropertyName();
        field = field == null ? ":fulltext" : ":fulltext:" + field;
        StaticOperand expr = fts.getFullTextSearchExpression();
        QueryParser parser = new QueryParser(Version.LUCENE_36, field, this.analyzer);
        parser.setAllowLeadingWildcard(true);
        try {
            return parser.parse(this.evaluator.getValue(expr).getString());
        }
        catch (ParseException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public Query create(PropertyExistence prop) throws RepositoryException {
        String propName = prop.getPropertyName();
        return new TermQuery(new Term(":properties", propName));
    }

    protected Predicate mapConstraintToQueryAndFilter(BooleanQuery query, Constraint constraint, Map<String, NodeType> selectorMap) throws RepositoryException, IOException {
        Object filter = Predicate.TRUE;
        if (constraint instanceof And) {
            And and = (And)constraint;
            filter = this.mapConstraintToQueryAndFilter(query, and.getConstraint1(), selectorMap);
            Predicate other = this.mapConstraintToQueryAndFilter(query, and.getConstraint2(), selectorMap);
            if (filter == Predicate.TRUE) {
                filter = other;
            } else if (other != Predicate.TRUE) {
                filter = Predicates.and((Predicate[])new Predicate[]{filter, other});
            }
        } else if (constraint instanceof Comparison) {
            Comparison c = (Comparison)constraint;
            Transform transform = new Transform(c.getOperand1());
            DynamicOperand left = transform.operand;
            final String operator = c.getOperator();
            StaticOperand right = c.getOperand2();
            if (left instanceof Length || left instanceof FullTextSearchScore || (!"jcr.operator.equal.to".equals(operator) || transform.transform != 0) && (left instanceof NodeName || left instanceof NodeLocalName)) {
                try {
                    int type = 0;
                    if (left instanceof Length) {
                        type = 3;
                    } else if (left instanceof FullTextSearchScore) {
                        type = 4;
                    }
                    final DynamicOperand operand = c.getOperand1();
                    final Value value = this.evaluator.getValue(right, type);
                    filter = new RowPredicate(){

                        protected boolean evaluate(Row row) throws RepositoryException {
                            return new ValueComparator().evaluate(operator, LuceneQueryFactory.this.evaluator.getValue((Operand)operand, row), value);
                        }
                    };
                }
                catch (ValueFormatException e) {
                    throw new InvalidQueryException((Throwable)e);
                }
            } else {
                Query cq = this.getComparisonQuery(left, transform.transform, operator, right, selectorMap);
                query.add(cq, BooleanClause.Occur.MUST);
            }
        } else if (constraint instanceof DescendantNode) {
            DescendantNode descendantNode = (DescendantNode)constraint;
            String path = descendantNode.getAncestorPath();
            if (path.equals("/")) {
                query.add((Query)new TermQuery(new Term(":path", path)), BooleanClause.Occur.MUST_NOT);
            } else {
                query.add((Query)new PrefixQuery(new Term(":path", path + "/")), BooleanClause.Occur.MUST);
            }
        } else if (constraint instanceof Not) {
            query.add(this.create(constraint, selectorMap), BooleanClause.Occur.MUST_NOT);
        } else {
            query.add(this.create(constraint, selectorMap), BooleanClause.Occur.MUST);
        }
        return filter;
    }

    protected Query create(Constraint constraint, Map<String, NodeType> selectorMap) throws RepositoryException, IOException {
        if (constraint instanceof And) {
            return this.getAndQuery((And)constraint, selectorMap);
        }
        if (constraint instanceof Or) {
            return this.getOrQuery((Or)constraint, selectorMap);
        }
        if (constraint instanceof Not) {
            return this.getNotQuery((Not)constraint, selectorMap);
        }
        if (constraint instanceof PropertyExistence) {
            return this.create((PropertyExistence)constraint);
        }
        if (constraint instanceof Comparison) {
            Comparison c = (Comparison)constraint;
            Transform left = new Transform(c.getOperand1());
            return this.getComparisonQuery(left.operand, left.transform, c.getOperator(), c.getOperand2(), selectorMap);
        }
        if (constraint instanceof FullTextSearch) {
            return this.create((FullTextSearch)constraint);
        }
        if (constraint instanceof SameNode) {
            SameNode sn = (SameNode)constraint;
            return new TermQuery(new Term(":path", sn.getPath()));
        }
        if (constraint instanceof ChildNode) {
            ChildNode cn = (ChildNode)constraint;
            return new TermQuery(new Term(":parent", cn.getParentPath()));
        }
        if (constraint instanceof DescendantNode) {
            DescendantNode dn = (DescendantNode)constraint;
            return new SubtreeQuery(dn.getAncestorPath(), false);
        }
        throw new UnsupportedRepositoryOperationException("Unknown constraint type: " + constraint);
    }

    protected BooleanQuery getAndQuery(And and, Map<String, NodeType> selectorMap) throws RepositoryException, IOException {
        BooleanQuery query = new BooleanQuery();
        this.addBooleanConstraint(query, and.getConstraint1(), BooleanClause.Occur.MUST, selectorMap);
        this.addBooleanConstraint(query, and.getConstraint2(), BooleanClause.Occur.MUST, selectorMap);
        return query;
    }

    protected BooleanQuery getOrQuery(Or or, Map<String, NodeType> selectorMap) throws RepositoryException, IOException {
        BooleanQuery query = new BooleanQuery();
        this.addBooleanConstraint(query, or.getConstraint1(), BooleanClause.Occur.SHOULD, selectorMap);
        this.addBooleanConstraint(query, or.getConstraint2(), BooleanClause.Occur.SHOULD, selectorMap);
        return query;
    }

    protected BooleanQuery getNotQuery(Not not, Map<String, NodeType> selectorMap) throws RepositoryException, IOException {
        BooleanQuery query = new BooleanQuery();
        this.addBooleanConstraint(query, not.getConstraint(), BooleanClause.Occur.SHOULD, selectorMap);
        return query;
    }

    protected void addBooleanConstraint(BooleanQuery query, Constraint constraint, BooleanClause.Occur occur, Map<String, NodeType> selectorMap) throws RepositoryException, IOException {
        if (occur == BooleanClause.Occur.MUST && constraint instanceof And) {
            And and = (And)constraint;
            this.addBooleanConstraint(query, and.getConstraint1(), occur, selectorMap);
            this.addBooleanConstraint(query, and.getConstraint2(), occur, selectorMap);
        } else if (occur == BooleanClause.Occur.SHOULD && constraint instanceof Or) {
            Or or = (Or)constraint;
            this.addBooleanConstraint(query, or.getConstraint1(), occur, selectorMap);
            this.addBooleanConstraint(query, or.getConstraint2(), occur, selectorMap);
        } else {
            query.add(this.create(constraint, selectorMap), occur);
        }
    }

    protected Query getComparisonQuery(DynamicOperand left, int transform, String operator, StaticOperand rigth, Map<String, NodeType> selectorMap) throws RepositoryException {
        if (left instanceof PropertyValue) {
            PropertyValue pv = (PropertyValue)left;
            String field = pv.getPropertyName();
            int type = 0;
            NodeType nt = selectorMap.get(pv.getSelectorName());
            if (nt != null) {
                for (PropertyDefinition pd : nt.getPropertyDefinitions()) {
                    if (!pd.getName().equals(pv.getPropertyName())) continue;
                    type = pd.getRequiredType();
                }
            }
            return this.getPropertyValueQuery(field, operator, this.evaluator.getValue(rigth), type, transform);
        }
        if (left instanceof NodeName) {
            return this.getNodeNameQuery(transform, operator, rigth);
        }
        if (left instanceof NodeLocalName) {
            return this.getNodeLocalNameQuery(transform, operator, rigth);
        }
        throw new UnsupportedRepositoryOperationException("Unknown operand type: " + left);
    }

    protected Query getNodeNameQuery(int transform, String operator, StaticOperand right) throws RepositoryException {
        String name = this.evaluator.getValue(right).getString();
        return new TermQuery(new Term(":name", name));
    }

    protected Query getNodeLocalNameQuery(int transform, String operator, StaticOperand right) throws RepositoryException {
        String name = this.evaluator.getValue(right).getString();
        return new TermQuery(new Term(":local", name));
    }

    protected Query getPropertyValueQuery(String field, String operator, Value value, int type, int transform) throws RepositoryException {
        String string = this.getValueString(value, type);
        Term term = new Term(field, string);
        if ("jcr.operator.like".equals(operator)) {
            return new WildcardQuery(term);
        }
        if ("jcr.operator.equal.to".equals(operator)) {
            return new TermQuery(term);
        }
        if ("jcr.operator.greater.than".equals(operator)) {
            return new TermRangeQuery(field, string, "\uffff", false, true);
        }
        if ("jcr.operator.greater.than.or.equal.to".equals(operator)) {
            return new TermRangeQuery(field, string, "\uffff", true, true);
        }
        if ("jcr.operator.less.than".equals(operator)) {
            return new TermRangeQuery(field, "", string, true, false);
        }
        if ("jcr.operator.less.than.or.equal.to".equals(operator)) {
            return new TermRangeQuery(field, "", string, true, true);
        }
        if ("jcr.operator.not.equal.to".equals(operator)) {
            BooleanQuery query = new BooleanQuery();
            query.add((Query)new TermQuery(term), BooleanClause.Occur.MUST_NOT);
            return query;
        }
        throw new UnsupportedRepositoryOperationException();
    }

    private String getValueString(Value value, int type) throws RepositoryException {
        switch (value.getType()) {
            case 5: {
                return DateField.dateToString(value.getDate().getTime());
            }
            case 4: {
                return DoubleField.doubleToString(value.getDouble());
            }
            case 3: {
                return LongField.longToString(value.getLong());
            }
            case 12: {
                return DecimalField.decimalToString(value.getDecimal());
            }
        }
        return value.getString();
    }

    protected static class Transform {
        private final DynamicOperand operand;
        private final int transform;

        public Transform(DynamicOperand operand) {
            this.transform = operand instanceof UpperCase ? 2 : (operand instanceof LowerCase ? 1 : 0);
            while (true) {
                if (operand instanceof UpperCase) {
                    operand = ((UpperCase)operand).getOperand();
                    continue;
                }
                if (!(operand instanceof LowerCase)) break;
                operand = ((LowerCase)operand).getOperand();
            }
            this.operand = operand;
        }
    }
}

