/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.ugc.api;

import com.adobe.cq.social.ugc.api.UgcCategoryProperty;
import com.adobe.cq.social.ugc.api.UgcIndexProperty;
import com.adobe.cq.social.ugc.api.UgcNodeIndexerExtension;
import java.util.LinkedList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.observation.Event;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractUgcNodeIndexerExtension
implements UgcNodeIndexerExtension {
    private static final String primaryType = "jcr:primaryType";
    private static final String FIELD_UUID = ":uuid".intern();
    private static final String FIELD_PRIMARY_TYPE = "jcr:primaryType".intern();
    private static final String FIELD_PATH = ":path".intern();
    private static final String FIELD_PARENT = ":parent".intern();
    private static final String FIELD_NAME = ":name".intern();
    private static final String FIELD_LOCAL = ":local".intern();
    public static final String PROP_ENABLED = "indexer.extension.enabled";
    protected boolean enabled = true;

    @Override
    public boolean checkPrimaryType(NodeType primaryType) {
        return true;
    }

    @Override
    public boolean checkResourceType(String resourceType) {
        return true;
    }

    @Override
    public boolean checkResource(Resource resource) {
        return true;
    }

    @Override
    public boolean checkNode(Node node) {
        return true;
    }

    @Override
    public boolean checkEventModifiesIndex(Event event) {
        return true;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean suppportFacetedSearch() {
        return false;
    }

    @Override
    public List<UgcIndexProperty> getAllUgcIndexProperties(ResourceResolver resolver, Node node) throws RepositoryException {
        LinkedList<UgcIndexProperty> result = new LinkedList<UgcIndexProperty>();
        result.add(new UgcIndexProperty(FIELD_UUID, node.getIdentifier(), true, UgcIndexProperty.Index.NOT_ANALYZED_NO_NORMS));
        result.add(new UgcIndexProperty(FIELD_PRIMARY_TYPE, node.getPrimaryNodeType().getName(), true, UgcIndexProperty.Index.NOT_ANALYZED_NO_NORMS));
        result.add(new UgcIndexProperty(FIELD_PATH, node.getPath(), true, UgcIndexProperty.Index.NOT_ANALYZED_NO_NORMS));
        try {
            result.add(new UgcIndexProperty(FIELD_PARENT, node.getParent().getPath(), false, UgcIndexProperty.Index.NOT_ANALYZED_NO_NORMS));
        }
        catch (RepositoryException e) {
            // empty catch block
        }
        String name = node.getName();
        result.add(new UgcIndexProperty(FIELD_NAME, name, false, UgcIndexProperty.Index.NOT_ANALYZED_NO_NORMS));
        name = name.substring(name.indexOf(58) + 1);
        result.add(new UgcIndexProperty(FIELD_LOCAL, name, false, UgcIndexProperty.Index.NOT_ANALYZED_NO_NORMS));
        result.addAll(this.getUgcIndexProperties(resolver, node));
        return result;
    }

    public abstract List<UgcIndexProperty> getUgcIndexProperties(ResourceResolver var1, Node var2) throws RepositoryException;

    @Override
    public List<UgcCategoryProperty> getUgcIndexedCategories(ResourceResolver resolver, Node node) throws RepositoryException {
        return null;
    }
}

