/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.ugc.api;

import com.adobe.cq.social.ugc.api.AbstractPropertyConstraint;
import com.adobe.cq.social.ugc.api.Constraint;
import com.adobe.cq.social.ugc.api.ConstraintVisitor;
import com.adobe.cq.social.ugc.api.Operator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetConstraint<T>
extends AbstractPropertyConstraint
implements Constraint {
    private List<T> values;

    public SetConstraint(String propertyName) {
        this(propertyName, Operator.And);
    }

    public SetConstraint(String propertyName, Collection<T> values) {
        this(propertyName, values, Operator.And);
    }

    public SetConstraint(String propertyName, Operator operator) {
        super(propertyName, operator);
    }

    public SetConstraint(String propertyName, Collection<T> values, Operator operator) {
        super(propertyName, operator);
        this.addAll(values);
    }

    public void add(T value) {
        if (null == this.values) {
            this.values = new ArrayList<T>();
        }
        this.values.add(value);
    }

    public void addAll(Collection<T> vals) {
        if (null == this.values) {
            this.values = new ArrayList<T>();
        }
        this.values.addAll(vals);
    }

    public int size() {
        int result = null == this.values ? 0 : this.values.size();
        return result;
    }

    public T get(int index) {
        if (null == this.values) {
            throw new IndexOutOfBoundsException("No values exist cannot retrieve value for index " + index);
        }
        T result = this.values.get(index);
        return result;
    }

    public void set(int i, T value) {
        if (null == this.values || i >= this.values.size()) {
            this.add(value);
        } else if (i < 0) {
            throw new IndexOutOfBoundsException(i + " is not in range [0, " + (this.values.size() - 1) + "]");
        }
        this.values.set(i, value);
    }

    public Collection<T> getValues() {
        List result = null == this.values ? Collections.emptyList() : this.values;
        return result;
    }

    @Override
    public void accept(ConstraintVisitor constraintVisitor) {
        constraintVisitor.visitSetConstraint(this);
    }
}

