/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.ugc.api;

import com.adobe.cq.social.ugc.api.ComparisonType;
import com.adobe.cq.social.ugc.api.Constraint;
import com.adobe.cq.social.ugc.api.ConstraintGroup;
import com.adobe.cq.social.ugc.api.ConstraintVisitor;
import com.adobe.cq.social.ugc.api.Operator;
import com.adobe.cq.social.ugc.api.PathConstraint;
import com.adobe.cq.social.ugc.api.PathConstraintType;
import com.adobe.cq.social.ugc.api.UgcSort;
import com.adobe.cq.social.ugc.api.ValueConstraint;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UgcFilter {
    public static final String DEFAULT_CONTENT_TYPE = "cq:Comment";
    private String contentType;
    private List<UgcSort> sortOrder;
    private Collection<Constraint> constraints = new Vector<Constraint>();
    private Map<String, Object> variables = new HashMap<String, Object>();
    private ConstraintGroup pathFilters;
    private Map<String, ConstraintGroup> orFilters;
    private Map<String, ConstraintGroup> andFilters;

    public UgcFilter() {
        this(DEFAULT_CONTENT_TYPE);
    }

    public UgcFilter(String contentType) {
        this.contentType = contentType;
    }

    public void addConstraint(Constraint constraint) {
        if (null == this.constraints) {
            this.constraints = new Vector<Constraint>();
        }
        this.constraints.add(constraint);
    }

    public void and(Constraint constraint) {
        constraint.setOperator(Operator.And);
        this.addConstraint(constraint);
    }

    public void or(Constraint constraint) {
        constraint.setOperator(Operator.Or);
        this.addConstraint(constraint);
    }

    public boolean hasConstraints() {
        return null != this.constraints;
    }

    public Collection<Constraint> getConstraints() {
        Collection<Object> result = null == this.constraints ? Collections.emptyList() : this.constraints;
        return result;
    }

    public void addSort(UgcSort sort) {
        if (null == this.sortOrder) {
            this.sortOrder = new Vector<UgcSort>();
        }
        this.sortOrder.add(sort);
    }

    public String getContentType() {
        return this.contentType;
    }

    public boolean isSorted() {
        return null != this.sortOrder && 0 < this.sortOrder.size();
    }

    public List<UgcSort> getSortOrder() {
        return this.sortOrder;
    }

    public boolean hasVariables() {
        return null != this.variables && 0 < this.variables.size();
    }

    public <T> void setVariableValue(String variableName, T variable) {
        if (null == this.variables) {
            this.variables = new HashMap<String, Object>();
        }
        this.variables.put(variableName, variable);
    }

    public Map<String, Object> getVariables() {
        Map<Object, Object> result = null == this.variables ? Collections.emptyMap() : this.variables;
        return result;
    }

    public void accept(ConstraintVisitor constraintVisitor) {
        if (this.hasConstraints()) {
            for (Constraint constraint : this.constraints) {
                constraint.accept(constraintVisitor);
            }
        }
    }

    protected void initConstraintGroups() {
        if (null == this.orFilters) {
            this.orFilters = new HashMap<String, ConstraintGroup>();
            this.andFilters = new HashMap<String, ConstraintGroup>();
        }
    }

    protected ComparisonType getComparisonType(Comparison comparison) {
        ComparisonType comparisonType;
        switch (comparison) {
            case EQUALS: {
                comparisonType = ComparisonType.Equals;
                break;
            }
            case GREATER_THAN: {
                comparisonType = ComparisonType.GreaterThan;
                break;
            }
            case GREATER_THAN_EQUAL_TO: {
                comparisonType = ComparisonType.GreaterThanOrEqualTo;
                break;
            }
            case LESS_THAN: {
                comparisonType = ComparisonType.LessThan;
                break;
            }
            case LESS_THAN_EQUAL_TO: {
                comparisonType = ComparisonType.LessThanOrEqualTo;
                break;
            }
            case NOT_EQUALS: {
                comparisonType = ComparisonType.NotEquals;
                break;
            }
            default: {
                throw new RuntimeException("Comparison " + comparison.name() + " not supported");
            }
        }
        return comparisonType;
    }

    @Deprecated
    public UgcSort getSort() {
        if (this.isSorted()) {
            return this.sortOrder.get(0);
        }
        return null;
    }

    @Deprecated
    public void sortByAscending(String propertyName) {
        this.addSort(new UgcSort(propertyName, UgcSort.Direction.Desc));
    }

    @Deprecated
    public void sortByDescending(String propertyName) {
        this.addSort(new UgcSort(propertyName, UgcSort.Direction.Desc));
    }

    @Deprecated
    public void filterOrByProperty(String propertyName, String propertyValue, Comparison comparison) {
        this.filterOrByConstraintGroup(propertyName, propertyName, propertyValue, comparison);
    }

    @Deprecated
    public void filterOrByConstraintGroup(String constraintGroupName, String propertyName, String propertyValue, Comparison comparison) {
        this.initConstraintGroups();
        if (!this.orFilters.containsKey(constraintGroupName)) {
            ConstraintGroup cg = new ConstraintGroup();
            this.and(cg);
            this.orFilters.put(constraintGroupName, cg);
        }
        ComparisonType comparisonType = this.getComparisonType(comparison);
        this.orFilters.get(constraintGroupName).addConstraint(new ValueConstraint<String>(propertyName, propertyValue, comparisonType, Operator.Or));
    }

    @Deprecated
    public void filterAndByProperty(String propertyName, String propertyValue, Comparison comparison) {
        this.filterAndByConstraintGroup(propertyName, propertyName, propertyValue, comparison);
    }

    @Deprecated
    public void filterAndByConstraintGroup(String constraintGroupName, String propertyName, String propertyValue, Comparison comparison) {
        this.initConstraintGroups();
        if (!this.andFilters.containsKey(constraintGroupName)) {
            ConstraintGroup cg = new ConstraintGroup();
            this.and(cg);
            this.andFilters.put(constraintGroupName, cg);
        }
        ComparisonType comparisonType = this.getComparisonType(comparison);
        this.andFilters.get(constraintGroupName).addConstraint(new ValueConstraint<String>(propertyName, propertyValue, comparisonType, Operator.And));
    }

    @Deprecated
    public boolean hasPropertyFilters() {
        return false;
    }

    @Deprecated
    public Map<String, List<PropertyFilter>> getOrPropertyFilters() {
        return Collections.emptyMap();
    }

    @Deprecated
    public Map<String, List<PropertyFilter>> getAndPropertyFilters() {
        return Collections.emptyMap();
    }

    @Deprecated
    public void filterContentType(String ct) {
        this.contentType = ct;
    }

    @Deprecated
    public boolean isContentTypeFiltered() {
        return false;
    }

    @Deprecated
    public String getContentFilter() {
        return null;
    }

    @Deprecated
    public void filterByPath(String parentPath) {
        if (null == this.pathFilters) {
            this.pathFilters = new ConstraintGroup(Operator.And);
            this.addConstraint(this.pathFilters);
        }
        this.pathFilters.addConstraint(new PathConstraint(parentPath, PathConstraintType.IsDescendantNode, Operator.Or));
    }

    @Deprecated
    public boolean isPathFiltered() {
        return false;
    }

    @Deprecated
    public String[] getPathFilters() {
        return new String[0];
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Deprecated
    public static enum Comparison {
        EQUALS("=", false),
        NOT_EQUALS("=", true),
        LESS_THAN("<", false),
        GREATER_THAN(">", false),
        LESS_THAN_EQUAL_TO("<=", false),
        GREATER_THAN_EQUAL_TO(">=", false);

        private String name;
        private boolean negation;

        private Comparison(String s, boolean n2) {
            this.name = s;
            this.negation = n2;
        }

        public boolean negation() {
            return this.negation;
        }

        public String toString() {
            return this.name;
        }
    }

    @Deprecated
    public final class PropertyFilter {
        private final Comparison comparison;
        private final String value;

        private PropertyFilter(String v, Comparison c) {
            this.value = v;
            this.comparison = c;
        }

        public Comparison getComparison() {
            return this.comparison;
        }

        public String getValue() {
            return this.value;
        }
    }
}

