/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.sc.qom;

import com.day.crx.sc.qom.JoinMerger;
import com.day.crx.sc.qom.OperandEvaluator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.query.Row;
import javax.jcr.query.qom.Constraint;
import javax.jcr.query.qom.DescendantNodeJoinCondition;
import javax.jcr.query.qom.Join;
import javax.jcr.query.qom.PropertyValue;
import javax.jcr.query.qom.QueryObjectModelFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DescendantNodeJoinMerger
extends JoinMerger {
    private final String descendantSelector;
    private final String ancestorSelector;

    public DescendantNodeJoinMerger(Join join, Map<String, PropertyValue> columns, OperandEvaluator evaluator, QueryObjectModelFactory factory, DescendantNodeJoinCondition condition) throws RepositoryException {
        super(join, columns, evaluator, factory);
        this.descendantSelector = condition.getDescendantSelectorName();
        this.ancestorSelector = condition.getAncestorSelectorName();
    }

    @Override
    public Set<String> getLeftValues(Row row) throws RepositoryException {
        return this.getValues(this.leftSelectors, row);
    }

    @Override
    public Set<String> getRightValues(Row row) throws RepositoryException {
        return this.getValues(this.rightSelectors, row);
    }

    @Override
    public List<Constraint> getRightJoinConstraints(List<Row> leftRows) throws RepositoryException {
        HashSet<String> paths = new HashSet<String>();
        for (Row row : leftRows) {
            paths.addAll(this.getLeftValues(row));
        }
        ArrayList<Constraint> constraints = new ArrayList<Constraint>();
        for (String path : paths) {
            if (this.rightSelectors.contains(this.descendantSelector)) {
                constraints.add((Constraint)this.factory.descendantNode(this.descendantSelector, path));
                continue;
            }
            constraints.add((Constraint)this.factory.sameNode(this.ancestorSelector, path));
        }
        return constraints;
    }

    private Set<String> getValues(Set<String> selectors, Row row) throws RepositoryException {
        if (selectors.contains(this.descendantSelector)) {
            Node node = row.getNode(this.descendantSelector);
            if (node != null) {
                HashSet<String> values = new HashSet<String>();
                while (node.getDepth() > 0) {
                    node = node.getParent();
                    values.add(node.getPath());
                }
                return values;
            }
        } else if (selectors.contains(this.ancestorSelector)) {
            Node node = row.getNode(this.ancestorSelector);
            if (node != null) {
                return Collections.singleton(node.getPath());
            }
        } else {
            throw new RepositoryException("Invalid descendant node join");
        }
        return Collections.emptySet();
    }
}

