/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.sc.lucene;

import com.adobe.cq.social.sc.lucene.JCRLock;
import java.io.IOException;
import javax.jcr.Session;
import javax.jcr.lock.LockManager;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockFactory;

public class JCRLockFactory
extends LockFactory {
    private final Session session;
    private final String path;

    JCRLockFactory(Session session, String path) {
        this.session = session;
        this.path = path;
    }

    public Lock makeLock(String lockName) {
        return new JCRLock(this.session, this.path);
    }

    public void clearLock(String lockName) throws IOException {
        try {
            LockManager lm = this.session.getWorkspace().getLockManager();
            if (lm.holdsLock(this.path)) {
                lm.unlock(this.path);
            }
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }
}

