/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.ugc.api;

import com.adobe.cq.social.sc.lucene.DateField;
import java.util.Date;
import org.apache.commons.lang.StringUtils;

public final class UgcIndexerUtil {
    private static final char PAD_CHAR = '0';
    private static final String NEGATIVE_PREFIX = "-";
    private static final String POSITIVE_PREFIX = "0";
    private static final int INTEGER_MAX_PADDING = Integer.toString(Integer.MAX_VALUE).length();
    private static final int LONG_MAX_PADDING = Long.toString(Long.MAX_VALUE).length();

    private UgcIndexerUtil() {
    }

    public static String dateToString(Date date) {
        return DateField.dateToString(date);
    }

    public static String escapeQuery(String query) {
        if (query == null) {
            return null;
        }
        String escapedQuery = query.replace("/", "");
        escapedQuery = escapedQuery.replace(":", "");
        escapedQuery = escapedQuery.replace("_", "");
        escapedQuery = escapedQuery.replace(NEGATIVE_PREFIX, "");
        return escapedQuery;
    }

    public static String longToString(long value) {
        return UgcIndexerUtil.longToString(value, LONG_MAX_PADDING);
    }

    public static String longToString(long value, int padSize) {
        return (value >= 0L ? POSITIVE_PREFIX : NEGATIVE_PREFIX) + StringUtils.leftPad((String)Long.toString(value), (int)padSize, (char)'0');
    }

    public static String integerToString(int value) {
        return UgcIndexerUtil.integerToString(value, INTEGER_MAX_PADDING);
    }

    public static String integerToString(int value, int padSize) {
        return (value >= 0 ? POSITIVE_PREFIX : NEGATIVE_PREFIX) + StringUtils.leftPad((String)Integer.toString(value), (int)padSize, (char)'0');
    }
}

