/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.ugc.impl;

import com.adobe.cq.social.sc.lucene.LuceneSearchCollection;
import com.adobe.cq.social.srp.FacetRangeField;
import com.adobe.cq.social.srp.FacetSearchResult;
import com.adobe.cq.social.srp.SearchSortField;
import com.adobe.cq.social.srp.SocialResource;
import com.adobe.cq.social.srp.SocialResourceProvider;
import com.adobe.cq.social.srp.SocialResourceSearchResult;
import com.adobe.cq.social.srp.config.SocialResourceConfiguration;
import com.adobe.cq.social.ugc.api.Constraint;
import com.adobe.cq.social.ugc.api.ConstraintGroup;
import com.adobe.cq.social.ugc.api.ConstraintVisitor;
import com.adobe.cq.social.ugc.api.DefaultConstraintVisitor;
import com.adobe.cq.social.ugc.api.FullTextConstraint;
import com.adobe.cq.social.ugc.api.PathConstraint;
import com.adobe.cq.social.ugc.api.RangeConstraint;
import com.adobe.cq.social.ugc.api.RelatedSearch;
import com.adobe.cq.social.ugc.api.SearchResults;
import com.adobe.cq.social.ugc.api.SetConstraint;
import com.adobe.cq.social.ugc.api.UgcFilter;
import com.adobe.cq.social.ugc.api.UgcFilterQueryWriter;
import com.adobe.cq.social.ugc.api.UgcIndexerUtil;
import com.adobe.cq.social.ugc.api.UgcNodeIndexerExtension;
import com.adobe.cq.social.ugc.api.UgcSearch;
import com.adobe.cq.social.ugc.api.UgcSort;
import com.adobe.cq.social.ugc.api.ValueConstraint;
import com.adobe.cq.social.ugc.impl.ListSearchResults;
import com.adobe.cq.social.ugc.impl.ServiceUserWrapper;
import com.adobe.cq.social.ugc.impl.UgcNodeIndexer;
import com.adobe.cq.social.ugc.impl.UserGeneratedContentVisitor;
import com.adobe.cq.social.ugcbase.SocialUtils;
import com.adobe.cq.social.ugcbase.core.SocialResourceUtils;
import com.day.crx.sc.api.SearchCollection;
import com.day.crx.sc.qom.SimpleQueryResult;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.jcr.ItemVisitor;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.discovery.TopologyEvent;
import org.apache.sling.discovery.TopologyEventListener;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.launchpad.api.StartupListener;
import org.apache.sling.launchpad.api.StartupMode;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service(value={UgcSearch.class, RelatedSearch.class, StartupListener.class, TopologyEventListener.class})
@Component(immediate=true)
@Properties(value={@Property(name="id", value={"ugc-sc"})})
@Reference(name="extensionProvider", referenceInterface=UgcNodeIndexerExtension.class, bind="bindExtension", unbind="unbindExtension", cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC)
public class LuceneUgcSearch
implements UgcSearch,
SearchCollection,
RelatedSearch,
StartupListener,
TopologyEventListener {
    private static final String JCR_PRIMARY_TYPE = "+(jcr:primaryType:";
    private static final String JCR_PRIMARY_TYPE_NO_PARENS = "+jcr:primaryType:";
    private static final Logger log = LoggerFactory.getLogger(LuceneUgcSearch.class);
    private static final String UGC_CONTENT_PATH = "/content/usergenerated/content";
    private static final Object UGC_WRITER = "ugc-writer";
    private static final Logger LOG = LoggerFactory.getLogger(LuceneUgcSearch.class);
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference
    private SocialUtils socialUtils;
    @Reference(policy=ReferencePolicy.STATIC, bind="bind", unbind="unbind")
    private SlingRepository repository;
    @Reference
    private ResourceResolverFactory rrf;
    private Session adminSession;
    private final Map<String, LuceneSearchCollection> luceneSCs = Collections.synchronizedMap(new HashMap());
    private final List<UgcNodeIndexerExtension> extensionsToInit;
    private volatile boolean startupFinished = false;
    private static volatile boolean isLeader = false;

    public LuceneUgcSearch() {
        this.luceneSCs.put(null, new LuceneSearchCollection());
        this.extensionsToInit = new LinkedList<UgcNodeIndexerExtension>();
    }

    @Activate
    protected void activate(ComponentContext ctx) throws RepositoryException {
        this.adminSession = this.repository.loginAdministrative(null);
        this.luceneSCs.put(null, new LuceneSearchCollection());
    }

    public void inform(StartupMode startupMode, boolean finished) {
        if (finished) {
            this.startupFinished(startupMode);
        }
    }

    public void handleTopologyEvent(TopologyEvent topologyEvent) {
        if (topologyEvent.getType() == TopologyEvent.Type.TOPOLOGY_CHANGED || topologyEvent.getType() == TopologyEvent.Type.TOPOLOGY_INIT) {
            boolean newLeaderState = topologyEvent.getNewView().getLocalInstance().isLeader();
            LOG.debug("LuceneUgcSearch Topology event. Current isLeader: {}  New isLeader: {}", (Object)isLeader, (Object)newLeaderState);
            isLeader = newLeaderState;
        }
    }

    public static boolean isTopologyLeader() {
        return isLeader;
    }

    public void startupFinished(StartupMode startupMode) {
        LOG.info("activating {} extensions after startup complete", (Object)this.extensionsToInit.size());
        for (UgcNodeIndexerExtension extension : this.extensionsToInit) {
            try {
                this.initSearchCollection(extension);
            }
            catch (RepositoryException e) {
                LOG.error("failed to init extension", (Throwable)e);
            }
        }
        this.extensionsToInit.clear();
        this.startupFinished = true;
    }

    public void startupProgress(float ratio) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deactivate
    protected void deactivate(ComponentContext ctx) {
        Map<String, LuceneSearchCollection> map = this.luceneSCs;
        synchronized (map) {
            for (LuceneSearchCollection luceneSC : this.luceneSCs.values()) {
                try {
                    luceneSC.stop();
                }
                catch (Exception e) {
                    log.warn("Exception while stopping: ", (Throwable)e);
                }
            }
            this.luceneSCs.clear();
        }
        if (this.adminSession != null) {
            this.adminSession.logout();
            this.adminSession = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSearchCollection(UgcNodeIndexerExtension extension) throws RepositoryException {
        Object object = LuceneSearchCollection.writeSync;
        synchronized (object) {
            Node configNode = null;
            String name = extension.getName();
            boolean supportFacetedSearch = extension.suppportFacetedSearch();
            Node taxNode = null;
            Session localAdminSession = null;
            try {
                Node parentNode;
                localAdminSession = this.repository.loginAdministrative(null);
                if (localAdminSession.nodeExists("/var/search-collections")) {
                    if (localAdminSession.nodeExists("/var/search-collections/" + name)) {
                        configNode = localAdminSession.getNode("/var/search-collections/" + name);
                    } else {
                        Node parentNode2 = localAdminSession.getNode("/var/search-collections");
                        configNode = parentNode2.addNode(name, "{http://www.jcp.org/jcr/nt/1.0}unstructured");
                        configNode.addMixin("mix:lockable");
                        configNode.setProperty("includes", extension.getIncludePaths());
                        localAdminSession.save();
                    }
                } else {
                    Node etcNode = localAdminSession.getNode("/var");
                    parentNode = etcNode.addNode("search-collections", "{http://www.jcp.org/jcr/nt/1.0}unstructured");
                    configNode = parentNode.addNode(name, "{http://www.jcp.org/jcr/nt/1.0}unstructured");
                    configNode.addMixin("mix:lockable");
                    configNode.setProperty("includes", extension.getIncludePaths());
                    localAdminSession.save();
                }
                if (supportFacetedSearch) {
                    String taxPath = "/var/search-collections/" + name + "taxo";
                    if (localAdminSession.nodeExists(taxPath)) {
                        taxNode = localAdminSession.getNode(taxPath);
                    } else {
                        parentNode = localAdminSession.getNode("/var/search-collections");
                        taxNode = parentNode.addNode(name + "taxo", "{http://www.jcp.org/jcr/nt/1.0}unstructured");
                        configNode.addMixin("mix:lockable");
                        taxNode.setProperty("includes", extension.getIncludePaths());
                        localAdminSession.save();
                    }
                }
                UgcNodeIndexer nodeIndexer = new UgcNodeIndexer(this.resourceResolverFactory, extension);
                LuceneSearchCollection ugcSearch = new LuceneSearchCollection(configNode, taxNode, nodeIndexer, false);
                this.luceneSCs.put(extension.getName(), ugcSearch);
                localAdminSession = null;
                configNode = this.adminSession.getNode(configNode.getPath());
                String[] includesPaths = extension.getIncludePaths().split(",");
                String[] primaryTypes = extension.getPrimaryTypes();
                for (int i = 0; i < primaryTypes.length; ++i) {
                    String nodeType = primaryTypes[i];
                    if (configNode.hasNodes()) continue;
                    UserGeneratedContentVisitor ugcVisitor = new UserGeneratedContentVisitor(nodeType);
                    for (String include : includesPaths) {
                        String includeString = include.trim();
                        if (!this.adminSession.nodeExists(includeString)) continue;
                        Node rootNode = this.adminSession.getNode(includeString);
                        rootNode.accept((ItemVisitor)ugcVisitor);
                    }
                    Set<String> paths = ugcVisitor.getPaths();
                    this.update(paths);
                }
            }
            finally {
                if (localAdminSession != null) {
                    localAdminSession.logout();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindExtension(UgcNodeIndexerExtension extension) {
        block6: {
            try {
                if (this.startupFinished) {
                    this.initSearchCollection(extension);
                    break block6;
                }
                List<UgcNodeIndexerExtension> list = this.extensionsToInit;
                synchronized (list) {
                    this.extensionsToInit.add(extension);
                }
            }
            catch (RepositoryException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void unbindExtension(UgcNodeIndexerExtension extension) {
        this.removeLuceneSearchCollection(extension.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeLuceneSearchCollection(String name) {
        Map<String, LuceneSearchCollection> map = this.luceneSCs;
        synchronized (map) {
            LuceneSearchCollection searchCollection = this.luceneSCs.remove(name);
            if (searchCollection != null) {
                searchCollection.stop();
            }
        }
    }

    protected void bind(SlingRepository rep) {
        this.repository = rep;
    }

    protected void unbind(SlingRepository rep) {
        if (this.repository == rep) {
            this.repository = null;
        }
    }

    @Override
    public int getIndex(String scName, Session session, UgcFilter listing, String targetPath, long added) throws RepositoryException {
        SearchResults<Node> results = this.find(scName, session, listing, 0, 1);
        int start = 0;
        int end = (int)results.getTotalNumberOfResults();
        while (start <= end) {
            int mid = (end + start) / 2;
            results = this.find(scName, session, listing, mid, 1);
            if (results.getResults().size() != 1) {
                return -1;
            }
            Node target = results.getResults().get(0);
            if (target.getPath().equals(targetPath)) {
                return mid;
            }
            if (target.getProperty("added").getDate().getTime().getTime() > added) {
                end = mid - 1;
                continue;
            }
            start = mid + 1;
        }
        return -1;
    }

    @Override
    public List<String> findMLT(String scName, String target, String resourceTypeFilter, String componentFilter, String statusFilter, String[] mltFields, int maxResults, int minTermFreq, int minDocFreq) throws RepositoryException {
        return this.luceneSCs.get(scName).findMLT(target, resourceTypeFilter, componentFilter, statusFilter, mltFields, maxResults, minTermFreq, minDocFreq);
    }

    @Override
    public List<String> findMLT(String scName, String target, String resourceTypeFilter, String componentFilter, String[] mltFields, int maxResults, int minTermFreq, int minDocFreq) throws RepositoryException {
        return this.findMLT(scName, target, resourceTypeFilter, componentFilter, null, mltFields, maxResults, minTermFreq, minDocFreq);
    }

    @Override
    public Map<String, Integer> findFacets(String scName, String fieldName, String resourceTypeFilter, String componentFilter, int count) throws RepositoryException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("findFacets for field: " + fieldName + " resource: " + resourceTypeFilter + " component: " + componentFilter);
        }
        ArrayList<String> fieldNames = new ArrayList<String>();
        fieldNames.add(fieldName);
        Map<String, Map<String, Integer>> facetsMap = this.findFacets(scName, fieldNames, resourceTypeFilter, componentFilter, count);
        if (facetsMap != null && !facetsMap.isEmpty()) {
            return facetsMap.get(fieldName);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Map<String, Integer>> findFacets(String scName, List<String> fieldNames, String resourceTypeFilter, String componentFilter, int count) throws RepositoryException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("findFacets for fields: " + fieldNames + " resource: " + resourceTypeFilter + " component: " + componentFilter);
        }
        if (StringUtils.isEmpty((String)componentFilter)) {
            LOG.warn("Component filter must be supplied");
            return Collections.emptyMap();
        }
        SocialResourceProvider srp = null;
        ResourceResolver serviceResolver = null;
        Map<String, Map<String, Integer>> facetResult = new HashMap<String, Map<String, Integer>>();
        try {
            serviceResolver = ServiceUserWrapper.getServiceResourceResolver(this.rrf, Collections.singletonMap("sling.service.subservice", UGC_WRITER));
            Resource resource = serviceResolver.resolve(componentFilter);
            srp = this.getSocialResourceProvider(serviceResolver, resource);
            if (srp == null) {
                LOG.debug("findFacets using lucene SC search for: {}", fieldNames);
                facetResult = this.luceneSCs.get(scName).findFacets(fieldNames, resourceTypeFilter, componentFilter, count);
            } else {
                LOG.debug("findFacets using SRP search for: {}", fieldNames);
                facetResult = srp.findFacets(serviceResolver, fieldNames, resourceTypeFilter, componentFilter, count);
            }
            if (serviceResolver.isLive()) {
                serviceResolver.close();
            }
        }
        catch (LoginException e) {
            LOG.error("error obtaining resource resolver: ", (Throwable)e);
        }
        finally {
            if (serviceResolver != null && serviceResolver.isLive()) {
                serviceResolver.close();
            }
        }
        if (LOG.isDebugEnabled() && !facetResult.isEmpty()) {
            LOG.debug("facetFind result: {}", facetResult);
        }
        return facetResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Map<String, Integer>> findFacets(List<String> fieldNames, String resourceTypeFilter, String componentFilter, int count) throws RepositoryException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("findFacets for fields: " + fieldNames + " resource: " + resourceTypeFilter + " component: " + componentFilter);
        }
        if (StringUtils.isEmpty((String)componentFilter)) {
            LOG.warn("Component filter must be supplied");
            return Collections.emptyMap();
        }
        SocialResourceProvider srp = null;
        ResourceResolver serviceResolver = null;
        Map<String, Map<String, Integer>> facetResult = new HashMap<String, Map<String, Integer>>();
        try {
            serviceResolver = ServiceUserWrapper.getServiceResourceResolver(this.rrf, Collections.singletonMap("sling.service.subservice", UGC_WRITER));
            Resource resource = serviceResolver.resolve(componentFilter);
            srp = this.getSocialResourceProvider(serviceResolver, resource);
            if (srp == null) {
                LOG.error("Unable to get Social Resource provider for: {}", (Object)resource.getName());
                Map<String, Map<String, Integer>> map = Collections.emptyMap();
                return map;
            }
            facetResult = srp.findFacets(serviceResolver, fieldNames, resourceTypeFilter, componentFilter, count);
            if (serviceResolver.isLive()) {
                serviceResolver.close();
            }
        }
        catch (LoginException e) {
            LOG.error("error obtaining resource resolver: ", (Throwable)e);
        }
        finally {
            if (serviceResolver != null && serviceResolver.isLive()) {
                serviceResolver.close();
            }
        }
        if (LOG.isDebugEnabled() && !facetResult.isEmpty()) {
            LOG.debug("facetFind result: {}", facetResult);
        }
        return facetResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Map<String, Integer>> findFacetRanges(List<FacetRangeField> facetRanges, String resourceTypeFilter, String componentFilter, int count) throws RepositoryException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("findFacetRanges with range for fields: " + facetRanges + " resource: " + resourceTypeFilter + " component: " + componentFilter);
        }
        if (StringUtils.isEmpty((String)componentFilter)) {
            LOG.warn("Component filter must be supplied");
            return Collections.emptyMap();
        }
        SocialResourceProvider srp = null;
        ResourceResolver serviceResolver = null;
        Map<String, Map<String, Integer>> facetResult = new HashMap<String, Map<String, Integer>>();
        try {
            serviceResolver = ServiceUserWrapper.getServiceResourceResolver(this.rrf, Collections.singletonMap("sling.service.subservice", UGC_WRITER));
            LOG.debug("In findFacetRanges getting SRP for {}", (Object)componentFilter);
            Resource resource = serviceResolver.resolve(componentFilter);
            srp = this.getSocialResourceProvider(serviceResolver, resource);
            if (srp == null) {
                LOG.error("Unable to get Social Resource provider for: {}", (Object)resource.getName());
                Map<String, Map<String, Integer>> map = Collections.emptyMap();
                return map;
            }
            facetResult = srp.findFacetRanges(serviceResolver, facetRanges, resourceTypeFilter, componentFilter, count);
            if (serviceResolver.isLive()) {
                serviceResolver.close();
            }
        }
        catch (LoginException e) {
            LOG.error("error obtaining resource resolver: ", (Throwable)e);
        }
        finally {
            if (serviceResolver != null && serviceResolver.isLive()) {
                serviceResolver.close();
            }
        }
        if (LOG.isDebugEnabled() && !facetResult.isEmpty()) {
            LOG.debug("facetFind result: {}", facetResult);
        }
        return facetResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FacetSearchResult findFacets(List<String> fieldNames, List<FacetRangeField> facetRanges, String resourceTypeFilter, String componentFilter, int count) throws RepositoryException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("findFacet count and  range for fields: " + facetRanges + " resource: " + resourceTypeFilter + " component: " + componentFilter);
        }
        if (StringUtils.isEmpty((String)componentFilter)) {
            LOG.warn("Component filter must be supplied");
            FacetSearchResult emptyResult = new FacetSearchResult();
            return emptyResult;
        }
        SocialResourceProvider srp = null;
        ResourceResolver serviceResolver = null;
        FacetSearchResult facetResult = new FacetSearchResult();
        try {
            serviceResolver = ServiceUserWrapper.getServiceResourceResolver(this.rrf, Collections.singletonMap("sling.service.subservice", UGC_WRITER));
            LOG.debug("In findFacetRanges getting SRP for {}", (Object)componentFilter);
            Resource resource = serviceResolver.resolve(componentFilter);
            srp = this.getSocialResourceProvider(serviceResolver, resource);
            if (srp == null) {
                LOG.error("Unable to get Social Resource provider for: {}", (Object)resource.getName());
                FacetSearchResult facetSearchResult = facetResult;
                return facetSearchResult;
            }
            facetResult = srp.findFacets(serviceResolver, fieldNames, facetRanges, resourceTypeFilter, componentFilter, count);
            if (serviceResolver.isLive()) {
                serviceResolver.close();
            }
        }
        catch (LoginException e) {
            LOG.error("error obtaining resource resolver: ", (Throwable)e);
        }
        finally {
            if (serviceResolver != null && serviceResolver.isLive()) {
                serviceResolver.close();
            }
        }
        return facetResult;
    }

    @Override
    public SearchResults<Node> find(String scName, Session session, UgcFilter filter, int offset, int limit) throws RepositoryException {
        filter.accept(new VariableHandler(filter));
        Query query = this.getJcrSql2Query(scName, session, filter, offset, limit);
        SearchResults<Node> srn = this.findNodes(query);
        return srn;
    }

    private SearchResults<Node> findNodes(Query query) throws RepositoryException {
        QueryResult result = query.execute();
        ArrayList<Node> nodes = new ArrayList<Node>();
        NodeIterator nodeIterator = result.getNodes();
        while (nodeIterator.hasNext()) {
            Node node = nodeIterator.nextNode();
            nodes.add(node);
        }
        return new ListSearchResults<Node>(nodes, ((SimpleQueryResult)result).getTotalNumberOfResults());
    }

    @Override
    public SearchResults<Resource> find(String scName, ResourceResolver resolver, UgcFilter filter, int offset, int limit) throws RepositoryException {
        return this.find(scName, resolver, filter, offset, limit, true);
    }

    @Override
    public SearchResults<Resource> find(String scName, ResourceResolver resolver, UgcFilter filter, int offset, int limit, boolean requiresTotal) throws RepositoryException {
        Query jcrSql2Query;
        long searchTotal = 0L;
        ArrayList<Resource> resourceList = new ArrayList<Resource>();
        Session session = (Session)resolver.adaptTo(Session.class);
        SocialResourceProvider srp = null;
        String constraintPath = "";
        boolean havePathConstraint = false;
        Collection<Constraint> constraints = filter.getConstraints();
        for (Constraint constraint : constraints) {
            if (!(constraint instanceof ConstraintGroup)) continue;
            Collection<Constraint> constraintCollection = ((ConstraintGroup)constraint).getConstraints();
            long conColSize = constraintCollection.size();
            for (Constraint con : constraintCollection) {
                String mappedPath;
                if (!(con instanceof PathConstraint)) continue;
                havePathConstraint = true;
                constraintPath = ((PathConstraint)con).getPath();
                LOG.debug("Path constraint is: {} ", (Object)constraintPath);
                if (srp == null) {
                    srp = this.socialUtils.getSocialResourceProvider(constraintPath);
                    srp.setConfig(this.socialUtils.getDefaultStorageConfig());
                    if (srp != null && !srp.getContentType().equals("cq:Comment")) {
                        filter.setContentType(srp.getContentType());
                    }
                }
                if (constraintPath.startsWith("/content/usergenerated")) {
                    if (srp == null || srp.getLanguages().contains("JSRP_SQL")) continue;
                    if (conColSize > 1L) {
                        ((PathConstraint)con).setPath("\\" + constraintPath + "*");
                        continue;
                    }
                    ((PathConstraint)con).setPath("\\" + constraintPath);
                    continue;
                }
                if (srp != null) {
                    mappedPath = this.socialUtils.resourceToUGCStoragePath(resolver.getResource(constraintPath));
                    if (srp.getLanguages().contains("JSRP_SQL")) {
                        ((PathConstraint)con).setPath(mappedPath);
                    } else if (srp != null && !srp.getLanguages().contains("JSRP_SQL")) {
                        if (conColSize > 1L) {
                            ((PathConstraint)con).setPath("*" + mappedPath + "*");
                        } else {
                            ((PathConstraint)con).setPath("*" + mappedPath);
                        }
                    }
                    LOG.debug("SocialResource Mapped constraint path for {} is: {}", (Object)constraintPath, (Object)mappedPath);
                    continue;
                }
                mappedPath = this.socialUtils.resourceToUGCStoragePath(resolver.getResource(constraintPath));
                ((PathConstraint)con).setPath(mappedPath);
                LOG.debug("JCR Mapped constraint path for {} is: {}", (Object)constraintPath, (Object)mappedPath);
            }
        }
        if (!havePathConstraint) {
            LOG.debug("No path supplied.  Will try default provider configuration");
            srp = this.getDefaultSocialResourceProvider(resolver);
            if (srp != null && !srp.getContentType().equals("cq:Comment")) {
                filter.setContentType(srp.getContentType());
            }
        }
        if (srp != null) {
            LOG.debug("SocialResource search using asi path {}", (Object)srp.getASIPath());
            jcrSql2Query = this.getJcrSql2Query(scName, session, filter, offset, limit, true);
            SocialResourceSearchResult searchResult = this.findCloudResources(srp, resolver, null, jcrSql2Query, filter, offset, limit, requiresTotal);
            if (searchResult != null) {
                searchTotal = searchResult.getNumFound();
                for (Resource resource : searchResult) {
                    resourceList.add(resource);
                }
                LOG.debug("Social find searchResult count is: {}", (Object)searchTotal);
            }
        } else {
            LOG.debug("Node search");
            jcrSql2Query = this.getJcrSql2Query(scName, session, filter, offset, limit);
            SearchResults<Node> nodeResult = this.findNodes(jcrSql2Query);
            if (nodeResult != null) {
                List<Node> nodes = nodeResult.getResults();
                searchTotal = nodeResult.getTotalNumberOfResults();
                for (Node node : nodes) {
                    Resource resultResource = resolver.getResource(node.getPath());
                    if (null == resultResource) continue;
                    resourceList.add(resultResource);
                }
                LOG.debug("Node find searchResult count is: {}", (Object)searchTotal);
            }
        }
        long total = searchTotal;
        if (searchTotal > (long)limit && limit > 0 && !requiresTotal) {
            total = limit + 1;
        }
        return new ListSearchResults<Resource>(resourceList, total);
    }

    private SocialResourceSearchResult findCloudResources(SocialResourceProvider srp, ResourceResolver resolver, String component, Query jcrSql2Query, UgcFilter filter, int offset, int limit, boolean requiresTotal) {
        String cloudQuery;
        List<UgcSort> ugcSortList = filter.getSortOrder();
        ArrayList<SearchSortField> sortList = new ArrayList<SearchSortField>();
        LOG.trace("findCloudResources");
        if (ugcSortList != null) {
            for (UgcSort ugcField : ugcSortList) {
                SearchSortField sortField = new SearchSortField(ugcField.getPropertyName(), ugcField.isAscending());
                sortList.add(sortField);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Search result sort property {} ascending {}", (Object)sortField.getPropertyName(), (Object)sortField.isAscending());
            }
        } else {
            SearchSortField sortField = new SearchSortField("added", false);
            sortList.add(sortField);
        }
        if (srp.getLanguages().contains("JSRP_SQL")) {
            UgcFilterQueryWriter queryWriter = new UgcFilterQueryWriter();
            cloudQuery = queryWriter.write(filter);
            sortList.clear();
            LOG.debug("Component: {} Jcr-SQL2 query is: {}", (Object)component, (Object)cloudQuery);
        } else {
            String luceneQuery = jcrSql2Query.getStatement();
            LOG.debug("Component: {} lucene query is: {}", (Object)component, (Object)luceneQuery);
            int index = 0;
            if (luceneQuery.startsWith(JCR_PRIMARY_TYPE)) {
                index = luceneQuery.indexOf(")") + 1;
                if (index == 0) {
                    throw new RuntimeException("Invalid query string (missing closing paren): " + luceneQuery);
                }
                if (luceneQuery.length() == index) {
                    LOG.warn("Searching only for primary type is not recommended: {}", (Object)luceneQuery);
                } else if (luceneQuery.charAt(index) == ' ') {
                    ++index;
                }
            } else if (luceneQuery.startsWith(JCR_PRIMARY_TYPE_NO_PARENS) && (index = luceneQuery.indexOf(" ") + 1) == 0) {
                index = luceneQuery.length();
                LOG.warn("Searching only for primary type is not recommended: {}", (Object)luceneQuery);
            }
            cloudQuery = luceneQuery.substring(index);
            LOG.debug("Search result resource cloud query is: {}", (Object)cloudQuery);
        }
        SocialResourceSearchResult searchResult = srp.find(resolver, component, cloudQuery, sortList, offset, limit, requiresTotal);
        if (searchResult != null) {
            LOG.debug("searchResult count is: {}", (Object)searchResult.getNumFound());
        }
        return searchResult;
    }

    public Query createQuery(String scName, Session session, String statement, String language) throws RepositoryException {
        return this.luceneSCs.get(scName).createQuery(session, statement, language);
    }

    @Override
    @Deprecated
    public Query createQuery(Session session, String statement, String language) throws RepositoryException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Map<String, LuceneSearchCollection> map = this.luceneSCs;
        synchronized (map) {
            for (LuceneSearchCollection luceneSC : this.luceneSCs.values()) {
                luceneSC.run();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Map<String, LuceneSearchCollection> map = this.luceneSCs;
        synchronized (map) {
            for (LuceneSearchCollection luceneSC : this.luceneSCs.values()) {
                luceneSC.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Set<String> paths) {
        Map<String, LuceneSearchCollection> map = this.luceneSCs;
        synchronized (map) {
            for (LuceneSearchCollection luceneSC : this.luceneSCs.values()) {
                luceneSC.update(paths);
            }
        }
    }

    Query getJcrSql2Query(String scName, Session session, UgcFilter filter, int offset, int limit, boolean isSRPQuery) throws RepositoryException {
        filter.accept(new VariableHandler(filter, isSRPQuery));
        UgcFilterQueryWriter queryWriter = new UgcFilterQueryWriter();
        String statement = queryWriter.write(filter);
        LOG.debug("The JSRPQUERY statement is: {} ", (Object)statement);
        Query query = this.createQuery(scName, session, statement, "JSRP_SQL");
        if (offset > 0) {
            query.setOffset((long)offset);
        }
        if (limit > 0) {
            query.setLimit((long)limit);
        }
        return query;
    }

    Query getJcrSql2Query(String scName, Session session, UgcFilter filter, int offset, int limit) throws RepositoryException {
        return this.getJcrSql2Query(scName, session, filter, offset, limit, false);
    }

    private SocialResourceProvider getSocialResourceProvider(ResourceResolver resolver, Resource resource) {
        if (resource == null) {
            LOG.debug("Resource is null. Have no starting point for getting the SRP configuration.");
            return null;
        }
        SocialResourceConfiguration src = this.socialUtils.getStorageConfig(resource);
        SocialResourceProvider resProvider = null;
        if (src != null) {
            LOG.debug("have a src asiPath: {}", (Object)src.getAsiPath());
            resProvider = LuceneUgcSearch.getProvider(resolver, src);
            LOG.debug("getSocialResourceProvider have provider");
        } else {
            LOG.debug("Unable to get storage configuration.");
        }
        return resProvider;
    }

    private static SocialResourceProvider getProvider(ResourceResolver resolver, SocialResourceConfiguration config) {
        if (config == null) {
            LOG.debug("Unable to get a SocialResourceProvider.  Configuration is null.");
            return null;
        }
        String remotePath = config.getAsiPath();
        if (StringUtils.isEmpty((String)remotePath)) {
            LOG.debug("Unable to get a SocialResourceProvider.  Remote path is empty.");
            return null;
        }
        SocialResource remoteResource = SocialResourceUtils.getSocialResource((Resource)resolver.getResource(remotePath));
        if (remoteResource != null) {
            SocialResourceProvider resProvider = remoteResource.getResourceProvider();
            if (resProvider != null) {
                LOG.debug("Got SocialResourceProvider for resource at {}", (Object)remotePath);
                resProvider.setConfig(config);
                return resProvider;
            }
            LOG.error("Unable to get a SocialResourceProvider for resource at {}", (Object)remotePath);
        } else {
            LOG.error("Remote resource is null or not a SocialResource");
        }
        return null;
    }

    private SocialResourceProvider getDefaultSocialResourceProvider(ResourceResolver resolver) {
        LOG.trace("getDefaultSocialResourceProvider");
        SocialResourceConfiguration config = this.socialUtils.getDefaultStorageConfig();
        return LuceneUgcSearch.getProvider(resolver, config);
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected void bindSocialUtils(SocialUtils socialUtils) {
        this.socialUtils = socialUtils;
    }

    protected void unbindSocialUtils(SocialUtils socialUtils) {
        if (this.socialUtils == socialUtils) {
            this.socialUtils = null;
        }
    }

    protected void bindRrf(ResourceResolverFactory resourceResolverFactory) {
        this.rrf = resourceResolverFactory;
    }

    protected void unbindRrf(ResourceResolverFactory resourceResolverFactory) {
        if (this.rrf == resourceResolverFactory) {
            this.rrf = null;
        }
    }

    static class VariableHandler
    extends DefaultConstraintVisitor
    implements ConstraintVisitor {
        private static final char VARIABLE_CHAR = '$';
        private int varCount;
        private final UgcFilter ugcFilter;
        private final boolean isSRPQuery;

        public VariableHandler(UgcFilter ugcFilter) {
            this.ugcFilter = ugcFilter;
            this.isSRPQuery = false;
        }

        public VariableHandler(UgcFilter ugcFilter, boolean isSRPQuery) {
            this.ugcFilter = ugcFilter;
            this.isSRPQuery = isSRPQuery;
        }

        @Override
        public void visitFullTextConstraint(FullTextConstraint fullTextConstraint) {
        }

        @Override
        public void visitPathConstraint(PathConstraint pathConstraint) {
        }

        public void visitValueConstraint(ValueConstraint valueConstraint) {
            Object value = valueConstraint.getValue();
            if (!this.isVariable(value)) {
                String varName = this.createVariable(value);
                valueConstraint.setValue(varName);
            }
        }

        @Override
        public void visitConstraintGroup(ConstraintGroup constraintGroup) {
            if (constraintGroup.hasConstraints()) {
                Collection<Constraint> constraints = constraintGroup.getConstraints();
                for (Constraint constraint : constraints) {
                    constraint.accept(this);
                }
            }
        }

        public void visitSetConstraint(SetConstraint setConstraint) {
            for (int i = 0; i < setConstraint.size(); ++i) {
                Object item = setConstraint.get(i);
                if (this.isVariable(item)) continue;
                String itemVarName = this.createVariable(item);
                setConstraint.set(i, itemVarName);
            }
        }

        public void visitRangeConstraint(RangeConstraint rangeConstraint) {
            Object minValue = rangeConstraint.getMinValue();
            Object maxValue = rangeConstraint.getMaxValue();
            if (!this.isVariable(minValue)) {
                String minVarName = this.createVariable(minValue);
                rangeConstraint.setMinValue(minVarName);
            }
            if (!this.isVariable(maxValue)) {
                String maxVarName = this.createVariable(maxValue);
                rangeConstraint.setMaxValue(maxVarName);
            }
        }

        protected String createVariable(Object value) {
            String varName = "_" + this.varCount;
            if (value instanceof Date) {
                if (this.isSRPQuery) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
                    sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
                    String dateString = sdf.format(((Date)value).getTime());
                    this.ugcFilter.setVariableValue(varName, dateString);
                } else {
                    this.ugcFilter.setVariableValue(varName, UgcIndexerUtil.dateToString((Date)value));
                }
            } else {
                this.ugcFilter.setVariableValue(varName, value);
            }
            ++this.varCount;
            return '$' + varName;
        }

        protected boolean isVariable(Object value) {
            return value instanceof String && ((String)value).charAt(0) == '$';
        }
    }
}

