/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.ugc.impl;

import com.adobe.cq.social.sc.lucene.DefaultNodeIndexer;
import com.adobe.cq.social.sc.lucene.NodeIndexer;
import com.adobe.cq.social.ugc.api.UgcCategoryProperty;
import com.adobe.cq.social.ugc.api.UgcIndexProperty;
import com.adobe.cq.social.ugc.api.UgcNodeIndexerExtension;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.document.NumericField;
import org.apache.lucene.facet.index.CategoryDocumentBuilder;
import org.apache.lucene.facet.taxonomy.CategoryPath;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UgcNodeIndexer
extends DefaultNodeIndexer
implements NodeIndexer {
    private final ResourceResolverFactory resolverFactory;
    private final UgcNodeIndexerExtension ext;
    private static final Logger log = LoggerFactory.getLogger(UgcNodeIndexer.class);

    public UgcNodeIndexer(ResourceResolverFactory resolverFactory, UgcNodeIndexerExtension ext) {
        this.resolverFactory = resolverFactory;
        this.ext = ext;
    }

    public UgcNodeIndexerExtension getUgcNodeIndexerExtension() {
        return this.ext;
    }

    @Override
    public Document createDocument(Node node, CategoryDocumentBuilder categoryDocBuilder) throws RepositoryException {
        if (!this.ext.checkNode(node)) {
            return null;
        }
        if (!this.ext.checkPrimaryType(node.getPrimaryNodeType())) {
            return null;
        }
        ResourceResolver resolver = null;
        try {
            resolver = this.resolverFactory.getAdministrativeResourceResolver(null);
            Resource resource = resolver.resolve(node.getPath());
            if (!this.ext.checkResource(resource)) {
                Document document = null;
                return document;
            }
            String resourceType = resource.getResourceType();
            if (resourceType != null && !this.ext.checkResourceType(resourceType)) {
                Document document = null;
                return document;
            }
            Document document = new Document();
            List<UgcIndexProperty> properties = this.ext.getAllUgcIndexProperties(resolver, node);
            List<UgcCategoryProperty> categories = null;
            ArrayList<CategoryPath> categoryPaths = null;
            if (this.ext.suppportFacetedSearch()) {
                categories = this.ext.getUgcIndexedCategories(resolver, node);
                categoryPaths = new ArrayList<CategoryPath>();
                for (UgcCategoryProperty entry : categories) {
                    String key = entry.key();
                    String value = entry.value();
                    categoryPaths.add(new CategoryPath(new CharSequence[]{key, value}));
                }
            }
            for (UgcIndexProperty prop : properties) {
                NumericField numField;
                Object val = prop.getValue();
                if (val instanceof String) {
                    document.add((Fieldable)new Field(prop.getName(), false, (String)val, prop.isStore() ? Field.Store.YES : Field.Store.NO, prop.getFieldIndex(), Field.TermVector.NO));
                } else if (val instanceof Integer) {
                    numField = new NumericField(prop.getName());
                    numField.setIntValue(((Integer)val).intValue());
                    document.add((Fieldable)numField);
                } else if (val instanceof Long) {
                    numField = new NumericField(prop.getName());
                    numField.setLongValue(((Long)val).longValue());
                    document.add((Fieldable)numField);
                } else if (val instanceof Double) {
                    numField = new NumericField(prop.getName());
                    numField.setDoubleValue(((Double)val).doubleValue());
                    document.add((Fieldable)numField);
                } else if (val instanceof Float) {
                    numField = new NumericField(prop.getName());
                    numField.setFloatValue(((Float)val).floatValue());
                    document.add((Fieldable)numField);
                } else {
                    log.error("Unsupported index property type: " + val.getClass().getName());
                }
                if (!prop.isFullText()) continue;
                String fulltext = val.toString();
                document.add((Fieldable)new Field(":fulltext:" + prop.getName(), fulltext, prop.isStore() ? Field.Store.YES : Field.Store.NO, Field.Index.ANALYZED_NO_NORMS, Field.TermVector.NO));
                document.add((Fieldable)new Field(":fulltext", false, fulltext, prop.isStore() ? Field.Store.YES : Field.Store.NO, Field.Index.ANALYZED_NO_NORMS, Field.TermVector.NO));
            }
            if (null != categoryDocBuilder) {
                categoryDocBuilder.setCategoryPaths(categoryPaths);
                categoryDocBuilder.build(document);
            }
            Document document2 = document;
            return document2;
        }
        catch (LoginException e) {
            throw new RepositoryException("LoginException for node: " + node.getPath(), (Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryException("IOException for node: " + node.getPath(), (Throwable)e);
        }
        finally {
            resolver.close();
        }
    }
}

