/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.analytics.client;

import com.adobe.granite.analytics.client.ConnectionUtil;
import com.adobe.granite.analytics.client.JsonUtil;
import com.adobe.granite.analytics.client.auth.ClientAuthenticator;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import org.apache.commons.io.IOUtils;

public class AnalyticsClient {
    private final Proxy proxy;
    private final ClientAuthenticator authenticator;
    private final String endpoint;

    AnalyticsClient(ClientAuthenticator authenticator, String endpoint, Proxy proxy) {
        this.authenticator = authenticator;
        this.endpoint = endpoint;
        this.proxy = proxy;
    }

    public <T> T callMethod(String method, Object data, Type resultType) throws IOException {
        String request = JsonUtil.GSON.toJson(data);
        String response = this.callMethod(method, request);
        return (T)JsonUtil.GSON.fromJson(response, resultType);
    }

    public String callMethod(String method, String data) throws IOException {
        URL url = new URL(String.format("https://%s/admin/1.4/rest/?method=%s", this.endpoint, method));
        HttpURLConnection connection = this.proxy == null ? (HttpURLConnection)url.openConnection() : (HttpURLConnection)url.openConnection(this.proxy);
        this.authenticator.authenticate(connection);
        connection.setDoOutput(true);
        IOUtils.write((String)data, (OutputStream)connection.getOutputStream());
        return ConnectionUtil.readResponse(connection);
    }
}

