/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.analytics.client;

import com.adobe.granite.analytics.client.AnalyticsClient;
import com.adobe.granite.analytics.client.auth.AuthenticatorBuilder;
import java.io.IOException;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.nio.file.Files;
import java.nio.file.Path;

public class AnalyticsClientBuilder {
    private final AuthenticatorBuilder authBuild = new AuthenticatorBuilder();
    private String endpoint;
    private Proxy proxy;

    public AnalyticsClientBuilder setEndpoint(String endpoint) {
        if (endpoint == null) {
            throw new NullPointerException("Endpoint can't be null");
        }
        this.authBuild.setEndpoint(endpoint);
        this.endpoint = endpoint;
        return this;
    }

    public AnalyticsClientBuilder authenticateWithSecret(String username, String secret) {
        this.authBuild.setUsername(username);
        this.authBuild.setSecret(secret);
        this.authBuild.setType(AuthenticatorBuilder.AuthType.WSSE);
        return this;
    }

    public AnalyticsClientBuilder authenticateWithJWTOAuth(Path privateKeyPath, String clientId, String username) throws IOException {
        this.authBuild.setPrivateKey(Files.readAllBytes(privateKeyPath));
        this.authBuild.setClientId(clientId);
        this.authBuild.setUsername(username);
        this.authBuild.setType(AuthenticatorBuilder.AuthType.JWTO_OAUTH);
        return this;
    }

    public AnalyticsClientBuilder authenticateWithJWTOAuth(byte[] privateKey, String clientId, String username) {
        this.authBuild.setPrivateKey(privateKey);
        this.authBuild.setClientId(clientId);
        this.authBuild.setUsername(username);
        this.authBuild.setType(AuthenticatorBuilder.AuthType.JWTO_OAUTH);
        return this;
    }

    public AnalyticsClientBuilder authenticateWithClientCredentialsOAuth(String clientId, String secret) {
        this.authBuild.setClientId(clientId);
        this.authBuild.setSecret(secret);
        this.authBuild.setType(AuthenticatorBuilder.AuthType.CREDENTIALS_OAUTH);
        return this;
    }

    public AnalyticsClientBuilder withProxy(String hostname, int port) {
        this.proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(hostname, port));
        this.authBuild.setProxy(this.proxy);
        return this;
    }

    public AnalyticsClientBuilder withProxy(String hostname, int port, final String username, final String password) {
        this.withProxy(hostname, port);
        Authenticator authenticator = new Authenticator(){

            @Override
            public PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(username, password.toCharArray());
            }
        };
        Authenticator.setDefault(authenticator);
        return this;
    }

    public AnalyticsClient build() {
        if (this.endpoint == null) {
            throw new IllegalStateException("Endpoint hasn't been set");
        }
        return new AnalyticsClient(this.authBuild.build(), this.endpoint, this.proxy);
    }
}

