/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.analytics.client;

import com.adobe.granite.analytics.client.ApiException;
import com.adobe.granite.analytics.client.JsonUtil;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import org.apache.commons.io.IOUtils;

public final class ConnectionUtil {
    private ConnectionUtil() {
    }

    public static String readResponse(HttpURLConnection connection) throws IOException {
        int status = connection.getResponseCode();
        if (status < 200 || status > 299) {
            InputStream errorStream = connection.getErrorStream();
            if (errorStream != null) {
                String errorMessage = IOUtils.toString((InputStream)errorStream);
                try {
                    JsonObject jsonResult = (JsonObject)JsonUtil.GSON.fromJson(errorMessage, JsonObject.class);
                    throw new ApiException((JsonElement)jsonResult);
                }
                catch (JsonSyntaxException e) {
                    // empty catch block
                }
            }
            throw new IOException(String.format("HTTP error %d %s", connection.getResponseCode(), connection.getResponseMessage()));
        }
        return IOUtils.toString((InputStream)connection.getInputStream());
    }
}

