/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.analytics.client.auth;

import com.adobe.granite.analytics.client.auth.ClientAuthenticator;
import com.adobe.granite.analytics.client.auth.OAuthenticator;
import com.adobe.granite.analytics.client.auth.WsseAuthenticator;
import com.adobe.granite.analytics.client.auth.oauth.ClientCredentials;
import com.adobe.granite.analytics.client.auth.oauth.JwtBearer;
import java.net.Proxy;

public class AuthenticatorBuilder {
    private String clientId;
    private String username;
    private String secret;
    private byte[] privateKey;
    private String endpoint;
    private AuthType type;
    private Proxy proxy;

    public AuthenticatorBuilder setType(AuthType type) {
        if (type == null) {
            throw new NullPointerException("Authentication type can't be null");
        }
        this.type = type;
        return this;
    }

    public AuthenticatorBuilder setClientId(String clientId) {
        if (clientId == null) {
            throw new NullPointerException("ClientId can't be null");
        }
        this.clientId = clientId;
        return this;
    }

    public AuthenticatorBuilder setUsername(String username) {
        if (username == null) {
            throw new NullPointerException("Username can't be null");
        }
        this.username = username;
        return this;
    }

    public AuthenticatorBuilder setSecret(String secret) {
        if (secret == null) {
            throw new NullPointerException("Secret can't be null");
        }
        this.secret = secret;
        return this;
    }

    public AuthenticatorBuilder setPrivateKey(byte[] privateKey) {
        if (privateKey == null) {
            throw new NullPointerException("Private key can't be null");
        }
        this.privateKey = privateKey;
        return this;
    }

    public AuthenticatorBuilder setEndpoint(String endpoint) {
        if (endpoint == null) {
            throw new NullPointerException("Endpoint can't be null");
        }
        this.endpoint = endpoint;
        return this;
    }

    public AuthenticatorBuilder setProxy(Proxy proxy) {
        if (proxy == null) {
            throw new NullPointerException("Proxy can't be null");
        }
        this.proxy = proxy;
        return this;
    }

    public ClientAuthenticator build() {
        switch (this.type) {
            case CREDENTIALS_OAUTH: {
                return new OAuthenticator(new ClientCredentials(this.clientId, this.secret), this.endpoint, this.proxy);
            }
            case JWTO_OAUTH: {
                return new OAuthenticator(new JwtBearer(this.privateKey, this.clientId, this.username, this.endpoint), this.endpoint, this.proxy);
            }
            case WSSE: {
                return new WsseAuthenticator(this.username, this.secret);
            }
        }
        throw new IllegalStateException("Authentication type hasn't been chosen: " + (Object)((Object)this.type));
    }

    public static enum AuthType {
        WSSE,
        JWTO_OAUTH,
        CREDENTIALS_OAUTH;

    }
}

