/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.analytics.client.auth;

import com.adobe.granite.analytics.client.ConnectionUtil;
import com.adobe.granite.analytics.client.JsonUtil;
import com.adobe.granite.analytics.client.auth.ClientAuthenticator;
import com.adobe.granite.analytics.client.auth.oauth.GrantType;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public class OAuthenticator
implements ClientAuthenticator {
    private static final String OAUTH_URL = "https://%s/token";
    private final String endpoint;
    private final Proxy proxy;
    private final GrantType grantType;
    private String accessToken;
    private Calendar expires;

    public OAuthenticator(GrantType grantType, String endpoint, Proxy proxy) {
        this.endpoint = endpoint;
        this.proxy = proxy;
        this.grantType = grantType;
    }

    @Override
    public void authenticate(HttpURLConnection connection) throws JsonSyntaxException, IOException {
        if (!this.isTokenValid()) {
            this.getToken();
        }
        connection.addRequestProperty("Authorization", String.format("Bearer %s", this.accessToken));
    }

    private boolean isTokenValid() {
        Calendar now = Calendar.getInstance();
        return this.accessToken != null && now.before(this.expires);
    }

    private void getToken() throws JsonSyntaxException, IOException {
        URL url = new URL(String.format(OAUTH_URL, this.endpoint));
        HttpURLConnection conn = this.proxy == null ? (HttpURLConnection)url.openConnection() : (HttpURLConnection)url.openConnection(this.proxy);
        this.setupPostRequest(conn);
        JsonObject response = (JsonObject)JsonUtil.GSON.fromJson(ConnectionUtil.readResponse(conn), JsonObject.class);
        this.accessToken = response.get("access_token").getAsString();
        this.expires = Calendar.getInstance();
        this.expires.add(13, response.get("expires_in").getAsInt());
    }

    private void setupPostRequest(HttpURLConnection conn) throws IOException {
        conn.setDoOutput(true);
        conn.setRequestMethod("POST");
        this.grantType.processRequest(conn);
        this.addPostParams(conn, this.grantType.getParameters());
    }

    private void addPostParams(HttpURLConnection conn, Map<String, String> parameters) throws IOException {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> pair : parameters.entrySet()) {
            if (first) {
                first = false;
            } else {
                result.append('&');
            }
            result.append(URLEncoder.encode(pair.getKey(), StandardCharsets.UTF_8.name()));
            result.append('=');
            result.append(URLEncoder.encode(pair.getValue(), StandardCharsets.UTF_8.name()));
        }
        IOUtils.write((String)result.toString(), (OutputStream)conn.getOutputStream());
    }
}

