/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.analytics.client.auth;

import com.adobe.granite.analytics.client.auth.ClientAuthenticator;
import java.net.HttpURLConnection;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.UUID;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;

public class WsseAuthenticator
implements ClientAuthenticator {
    private final String username;
    private final String secret;

    public WsseAuthenticator(String username, String secret) {
        this.username = username;
        this.secret = secret;
    }

    @Override
    public void authenticate(HttpURLConnection connection) {
        connection.addRequestProperty("X-WSSE", this.getHeader());
    }

    private String getHeader() {
        String nonce = UUID.randomUUID().toString();
        String created = WsseAuthenticator.currentDate();
        String passwordDigest = WsseAuthenticator.getBase64Digest(nonce, created, this.secret);
        StringBuilder builder = new StringBuilder("UsernameToken ");
        WsseAuthenticator.addField(builder, "Username", this.username).append(", ");
        WsseAuthenticator.addField(builder, "PasswordDigest", passwordDigest).append(", ");
        WsseAuthenticator.addField(builder, "Nonce", Base64.encodeBase64String((byte[])nonce.getBytes())).append(", ");
        WsseAuthenticator.addField(builder, "Created", created);
        return builder.toString();
    }

    private static StringBuilder addField(StringBuilder builder, String fieldName, String fieldValue) {
        builder.append(fieldName).append("=\"").append(fieldValue).append('\"');
        return builder;
    }

    private static String currentDate() {
        TimeZone tz = TimeZone.getTimeZone("UTC");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm'Z'");
        df.setTimeZone(tz);
        return df.format(new Date());
    }

    private static String getBase64Digest(String ... strings) {
        MessageDigest digest = DigestUtils.getSha1Digest();
        digest.reset();
        for (String s : strings) {
            DigestUtils.updateDigest((MessageDigest)digest, (String)s);
        }
        return Base64.encodeBase64String((byte[])digest.digest());
    }
}

