/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.analytics.client.auth.oauth;

import com.adobe.granite.analytics.client.auth.oauth.GrantType;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.net.HttpURLConnection;
import java.util.LinkedHashMap;
import java.util.Map;

public class JwtBearer
implements GrantType {
    private final byte[] privateKey;
    private final String clientId;
    private final String username;
    private final String endpoint;

    public JwtBearer(byte[] privateKey, String clientId, String username, String endpoint) {
        this.privateKey = privateKey;
        this.clientId = clientId;
        this.username = username;
        this.endpoint = endpoint;
    }

    @Override
    public Map<String, String> getParameters() {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("grant_type", "urn:ietf:params:oauth:grant-type:jwt-bearer");
        params.put("client_id", this.clientId);
        params.put("assertion", this.getAssertion());
        return params;
    }

    private String getAssertion() {
        return Jwts.builder().setIssuer(this.clientId).setSubject(this.username).setAudience(this.endpoint).signWith(SignatureAlgorithm.HS256, this.privateKey).compact();
    }

    @Override
    public void processRequest(HttpURLConnection conn) {
    }
}

