/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.analytics.client.methods;

import com.adobe.analytics.client.domain.Bookmark;
import com.adobe.analytics.client.domain.BookmarkFolder;
import com.adobe.granite.analytics.client.AnalyticsClient;
import com.adobe.granite.analytics.client.JsonUtil;
import com.adobe.granite.analytics.client.domain.CompanyReportSuites;
import com.adobe.granite.analytics.client.domain.ReportDescription;
import com.adobe.granite.analytics.client.domain.ReportSuiteEvars;
import com.adobe.granite.analytics.client.domain.ReportSuiteEvents;
import com.adobe.granite.analytics.client.domain.ReportSuiteProps;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ReportSuiteMethods {
    private final AnalyticsClient client;
    private Map<String, Bookmark> reportDescriptionBookmarksMap;

    public ReportSuiteMethods(AnalyticsClient client) {
        this.client = client;
        this.reportDescriptionBookmarksMap = new HashMap<String, Bookmark>();
    }

    public CompanyReportSuites getReportSuites() throws IOException {
        return (CompanyReportSuites)this.client.callMethod("Company.GetReportSuites", JsonUtil.o("types", JsonUtil.a("standard")), (Type)((Object)CompanyReportSuites.class));
    }

    public List<ReportSuiteEvars> getEvars(String ... rsid) throws IOException {
        Type type = new TypeToken<List<ReportSuiteEvars>>(){}.getType();
        return (List)this.client.callMethod("ReportSuite.GetEvars", JsonUtil.o("rsid_list", rsid), type);
    }

    public List<ReportSuiteProps> getProps(String ... rsid) throws IOException {
        Type type = new TypeToken<List<ReportSuiteProps>>(){}.getType();
        return (List)this.client.callMethod("ReportSuite.GetProps", JsonUtil.o("rsid_list", rsid), type);
    }

    public List<ReportSuiteEvents> getEvents(String ... rsid) throws IOException {
        Type type = new TypeToken<List<ReportSuiteEvents>>(){}.getType();
        return (List)this.client.callMethod("ReportSuite.GetEvents", JsonUtil.o("rsid_list", rsid), type);
    }

    public List<BookmarkFolder> getBookmarksFolders() throws IOException {
        Type type = new TypeToken<Map<String, List<BookmarkFolder>>>(){}.getType();
        Map foldersResponseMap = (Map)this.client.callMethod("Bookmark.GetBookmarks", null, type);
        List folders = (List)foldersResponseMap.get("folders");
        for (BookmarkFolder bookmarkFolder : folders) {
            bookmarkFolder.setClient(this.client);
        }
        return folders;
    }

    public ReportDescription getReportDescription(int bookmarkId) throws IOException {
        Type type = new TypeToken<ReportDescription>(){}.getType();
        return (ReportDescription)this.client.callMethod("Bookmark.GetReportDescription", JsonUtil.o("bookmark_id", bookmarkId), type);
    }

    public ReportDescription getReportDescriptionByBookmarkName(String bookmarkName) throws IOException {
        Bookmark bookmark;
        if (this.reportDescriptionBookmarksMap.isEmpty()) {
            this.loadBookmarks();
        }
        if ((bookmark = this.reportDescriptionBookmarksMap.get(bookmarkName)) != null) {
            return bookmark.getReportDescription();
        }
        return null;
    }

    private void loadBookmarks() throws IOException {
        List<BookmarkFolder> bookmarkFolders = this.getBookmarksFolders();
        for (BookmarkFolder folder : bookmarkFolders) {
            for (Bookmark bookmark : folder.getBookmarks()) {
                this.reportDescriptionBookmarksMap.put(bookmark.getName(), bookmark);
            }
        }
    }
}

